/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class DamageNumbersClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve("damage_numbers_client.json");
    public boolean enabled = true;
    public ShowMode showMode = ShowMode.ALL;
    public boolean showPetDamage = true;
    public boolean onlyShowPartyDamage = false;
    public double viewDistance = 32.0;
    private static DamageNumbersClientConfig INSTANCE;

    private DamageNumbersClientConfig() {
    }

    public static DamageNumbersClientConfig get() {
        if (INSTANCE == null) {
            boolean needSave = false;
            try {
                if (Files.exists(FILE, new LinkOption[0])) {
                    INSTANCE = (DamageNumbersClientConfig)GSON.fromJson(Files.readString(FILE), DamageNumbersClientConfig.class);
                    if (INSTANCE == null) {
                        INSTANCE = new DamageNumbersClientConfig();
                        needSave = true;
                    }
                    if (DamageNumbersClientConfig.INSTANCE.showMode == null) {
                        DamageNumbersClientConfig.INSTANCE.showMode = ShowMode.ALL;
                        needSave = true;
                    }
                } else {
                    INSTANCE = new DamageNumbersClientConfig();
                    needSave = true;
                }
            }
            catch (Exception e) {
                INSTANCE = new DamageNumbersClientConfig();
                needSave = true;
            }
            if (needSave) {
                DamageNumbersClientConfig.save();
            }
        }
        return INSTANCE;
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)DamageNumbersClientConfig.get()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double viewDistanceSq() {
        double d = Math.max(2.0, Math.min(256.0, this.viewDistance));
        return d * d;
    }

    public static enum ShowMode {
        ALL,
        PLAYERS_ONLY,
        NONE;

    }
}

