/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class HealingNumbersClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve("healing_numbers_client.json");
    public Mode mode = Mode.ALL;
    public AmountMode amountMode = AmountMode.ATTEMPTED;
    private static HealingNumbersClientConfig INSTANCE;

    private HealingNumbersClientConfig() {
    }

    public static synchronized HealingNumbersClientConfig get() {
        if (INSTANCE == null) {
            boolean needSave = false;
            try {
                if (Files.exists(FILE, new LinkOption[0])) {
                    INSTANCE = (HealingNumbersClientConfig)GSON.fromJson(Files.readString(FILE), HealingNumbersClientConfig.class);
                    if (INSTANCE == null) {
                        INSTANCE = new HealingNumbersClientConfig();
                        needSave = true;
                    } else {
                        if (HealingNumbersClientConfig.INSTANCE.mode == null) {
                            HealingNumbersClientConfig.INSTANCE.mode = Mode.ALL;
                            needSave = true;
                        }
                        if (HealingNumbersClientConfig.INSTANCE.amountMode == null) {
                            HealingNumbersClientConfig.INSTANCE.amountMode = AmountMode.ATTEMPTED;
                            needSave = true;
                        }
                    }
                } else {
                    INSTANCE = new HealingNumbersClientConfig();
                    needSave = true;
                }
            }
            catch (Exception e) {
                INSTANCE = new HealingNumbersClientConfig();
                needSave = true;
            }
            if (needSave) {
                HealingNumbersClientConfig.save();
            }
        }
        return INSTANCE;
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)HealingNumbersClientConfig.get()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum Mode {
        NONE,
        ALL;

    }

    public static enum AmountMode {
        APPLIED,
        ATTEMPTED;

    }
}

