/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class PartyMemberInfoClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "rpgsystems_memberinfo_client.json";
    private static PartyMemberInfoClientConfig INSTANCE;
    public boolean showHpBar = true;
    public boolean showHungerBar = true;
    public boolean showStaminaBar = false;
    public boolean showManaBar = false;
    public boolean showRpgManaBar = false;

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }

    public static synchronized PartyMemberInfoClientConfig get() {
        if (INSTANCE == null) {
            PartyMemberInfoClientConfig.load();
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        Path p = PartyMemberInfoClientConfig.path();
        boolean needSave = false;
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(p);){
                INSTANCE = (PartyMemberInfoClientConfig)GSON.fromJson((Reader)r, PartyMemberInfoClientConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new PartyMemberInfoClientConfig();
                    needSave = true;
                }
            }
            catch (Throwable t) {
                INSTANCE = new PartyMemberInfoClientConfig();
                needSave = true;
            }
        } else {
            INSTANCE = new PartyMemberInfoClientConfig();
            needSave = true;
        }
        INSTANCE.enforceMaxThreeBars();
        if (needSave) {
            PartyMemberInfoClientConfig.save();
        }
    }

    public static synchronized void save() {
        try {
            Files.createDirectories(PartyMemberInfoClientConfig.path().getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(PartyMemberInfoClientConfig.path(), new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void enforceMaxThreeBars() {
        int count = 0;
        if (this.showHpBar) {
            ++count;
        }
        if (this.showHungerBar) {
            ++count;
        }
        if (this.showStaminaBar) {
            ++count;
        }
        if (this.showManaBar) {
            ++count;
        }
        if (this.showRpgManaBar) {
            ++count;
        }
        if (count <= 3) {
            return;
        }
        if (this.showRpgManaBar && count > 3) {
            this.showRpgManaBar = false;
            --count;
        }
        if (this.showManaBar && count > 3) {
            this.showManaBar = false;
            --count;
        }
        if (this.showStaminaBar && count > 3) {
            this.showStaminaBar = false;
            --count;
        }
        if (this.showHungerBar && count > 3) {
            this.showHungerBar = false;
            --count;
        }
        if (count > 3) {
            this.showHpBar = false;
        }
    }
}

