/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import net.pixeldreamstudios.rpgsystems.client.config.MiscClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyJoinRequests;

@Environment(value=EnvType.CLIENT)
public final class PartyJoinRequestHud
implements HudRenderCallback {
    private static final class_2960 TOAST_TEX = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_join_request_notification.png");
    private static final int TEX_W = 64;
    private static final int TEX_H = 32;
    private static final float SCALE = 0.5f;
    private static final int VIS_W = Math.round(32.0f);
    private static final int VIS_H = Math.round(16.0f);
    private static final int STACK_GAP = 6;
    private static final long SHOW_MS = 5000L;
    private static final long SLIDE_MS = 300L;
    private static boolean filtered = false;
    private static final List<Toast> TOASTS = new ArrayList<Toast>();
    private static final Set<String> KNOWN_REQUESTERS = new HashSet<String>();

    public static void init() {
        HudRenderCallback.EVENT.register((Object)new PartyJoinRequestHud());
    }

    public void onHudRender(class_332 ctx, class_9779 tickCounter) {
        int baseBottom;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1690.field_1842) {
            return;
        }
        PartyJoinRequestHud.ensureNearest();
        HashSet<CallSite> current = new HashSet<CallSite>();
        for (ClientPartyJoinRequests.Req r : new ArrayList<ClientPartyJoinRequests.Req>(ClientPartyJoinRequests.all())) {
            String key = "join:" + (r.requesterName == null ? "Unknown" : r.requesterName);
            current.add((CallSite)((Object)key));
            if (!KNOWN_REQUESTERS.add(key)) continue;
            TOASTS.add(new Toast(key, System.currentTimeMillis()));
        }
        KNOWN_REQUESTERS.removeIf(k -> !current.contains(k));
        long now = System.currentTimeMillis();
        TOASTS.removeIf(t -> now - t.startAtMs >= 5300L);
        MiscClientConfig cfg = MiscClientConfig.get();
        int baseLeft = cfg.joinRequestHudX;
        int nextBottom = baseBottom = ctx.method_51443() - cfg.joinRequestHudY;
        ListIterator<Toast> it = TOASTS.listIterator(TOASTS.size());
        while (it.hasPrevious()) {
            Toast t2 = it.previous();
            float slide = PartyJoinRequestHud.slideProgress(now - t2.startAtMs);
            int offX = -VIS_W - baseLeft;
            int targetX = baseLeft;
            int drawX = Math.round(PartyJoinRequestHud.lerp(offX, targetX, slide));
            int drawY = nextBottom - VIS_H;
            nextBottom = drawY - 6;
            class_4587 m = ctx.method_51448();
            m.method_22903();
            m.method_46416((float)drawX, (float)drawY, 0.0f);
            m.method_22905(0.5f, 0.5f, 1.0f);
            ctx.method_25290(TOAST_TEX, 0, 0, 0.0f, 0.0f, 64, 32, 64, 32);
            m.method_22909();
        }
    }

    private static float slideProgress(long elapsedMs) {
        if (elapsedMs <= 300L) {
            return (float)elapsedMs / 300.0f;
        }
        if (elapsedMs >= 5000L) {
            return 1.0f - (float)Math.min(300L, elapsedMs - 5000L) / 300.0f;
        }
        return 1.0f;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * Math.max(0.0f, Math.min(1.0f, t));
    }

    private static void ensureNearest() {
        if (filtered) {
            return;
        }
        class_1060 tm = class_310.method_1551().method_1531();
        class_1044 tex = tm.method_4619(TOAST_TEX);
        if (tex != null) {
            tex.method_4527(false, false);
        }
        filtered = true;
    }

    private static final class Toast {
        final String key;
        final long startAtMs;

        Toast(String k, long t) {
            this.key = k;
            this.startAtMs = t;
        }
    }
}

