/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import net.pixeldreamstudios.rpgsystems.client.enemy.EnemyHealthBarRenderer;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.client.title.TitleStyleUtil;
import net.pixeldreamstudios.rpgsystems.client.title.TitleTextureResolver;
import net.pixeldreamstudios.rpgsystems.client.title.config.TitlesClientConfig;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class TitlePlayerRenderer {
    private static final float BASE_WORLD_W = 0.6f;
    private static final float NAME_GAP = 0.2f;
    private static final float Y_OFFSET = 0.55f;
    private static final double MAX_DISTANCE_SQ = 2304.0;
    private static final float MIN_ALPHA_FAR = 0.35f;

    private TitlePlayerRenderer() {
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> {});
        ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> {});
        WorldRenderEvents.LAST.register(TitlePlayerRenderer::render);
    }

    private static void render(WorldRenderContext context) {
        class_638 world = context.world();
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        if (world == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1690.field_1842) {
            return;
        }
        boolean isFirstPerson = client.field_1690.method_31044().method_31034();
        class_243 camPos = camera.method_19326();
        float tickDelta = client.method_60646().method_60637(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (class_742 entity : world.method_18456()) {
            float maxDist;
            float dist;
            float t;
            float nearFactor;
            float distanceAlpha;
            float finalAlpha;
            class_238 box;
            double distSq;
            class_2960 titleId;
            boolean invisible;
            class_742 player = entity;
            if (!player.method_5805()) continue;
            class_746 viewer = client.field_1724;
            boolean bl = invisible = viewer != null ? player.method_5756((class_1657)viewer) : player.method_5767();
            if (invisible || (titleId = player.method_5667().equals(client.field_1724 != null ? client.field_1724.method_5667() : null) ? TitleClientData.getSelfActive() : TitleClientData.getActive(player.method_5667())) == null || (distSq = player.method_5649(camPos.field_1352, camPos.field_1351, camPos.field_1350)) > 2304.0 || !TitlePlayerRenderer.isOnScreen(context, box = player.method_5829()) || (finalAlpha = TitlePlayerRenderer.clamp01(distanceAlpha = 0.35f + 0.65f * (nearFactor = 1.0f - (t = TitlePlayerRenderer.clamp01((dist = (float)Math.sqrt(distSq)) / (maxDist = (float)Math.sqrt(2304.0))))))) <= 0.01f) continue;
            double ex = TitlePlayerRenderer.lerp(tickDelta, player.field_6014, player.method_23317());
            double ey = TitlePlayerRenderer.lerp(tickDelta, player.field_6036, player.method_23318());
            double ez = TitlePlayerRenderer.lerp(tickDelta, player.field_5969, player.method_23321());
            double head = box.method_17940() + (double)0.55f;
            float hpOffset = EnemyHealthBarRenderer.getNameYOffset((class_1309)player, tickDelta) * 0.6f;
            boolean isSelf = client.field_1724 != null && player.method_5628() == client.field_1724.method_5628();
            TitlesClientConfig titleCfg = TitlesClientConfig.get();
            if (isSelf && !titleCfg.showOwnTitle || !isSelf && !titleCfg.showOthersTitles || isSelf && isFirstPerson) continue;
            float gapAboveName = isSelf ? 0.0f : 0.2f;
            matrices.method_22903();
            matrices.method_22904(ex - camPos.field_1352, ey - camPos.field_1351 + head + (double)hpOffset + (double)gapAboveName, ez - camPos.field_1350);
            TitlePlayerRenderer.faceCamera(matrices, camera);
            TitleTextureResolver.FrameInfo fi = TitleTextureResolver.currentFrame(titleId);
            if (fi != null) {
                float worldW = 0.6f;
                float worldH = worldW * ((float)fi.frameHeight / (float)fi.frameWidth);
                matrices.method_22905(worldW, worldH, 1.0f);
                RenderSystem.setShader(class_757::method_34548);
                RenderSystem.setShaderTexture((int)0, (class_2960)fi.textureId);
                TitlePlayerRenderer.drawQuadLitUV(matrices.method_23760().method_23761(), fi.u0, fi.v0, fi.u1, fi.v1, finalAlpha);
                matrices.method_22909();
                continue;
            }
            Title tTitle = TitleRegistry.get(titleId);
            class_2561 label = tTitle != null ? tTitle.displayName : class_2561.method_43470((String)titleId.method_12832());
            TitlePlayerRenderer.drawStyledTitle3D(context, matrices, label, finalAlpha);
            matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
    }

    private static void drawQuadLitUV(Matrix4f mat, float u0, float v0, float u1, float v1, float alpha) {
        int light = class_765.method_23687((int)15, (int)15);
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_60827(class_293.class_5596.field_27382, class_290.field_20888);
        buf.method_22918(mat, -0.5f, 0.5f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(u1, v0).method_60803(light);
        buf.method_22918(mat, 0.5f, 0.5f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(u0, v0).method_60803(light);
        buf.method_22918(mat, 0.5f, -0.5f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(u0, v1).method_60803(light);
        buf.method_22918(mat, -0.5f, -0.5f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(u1, v1).method_60803(light);
        class_286.method_43433((class_9801)buf.method_60800());
    }

    private static void drawStyledTitle3D(WorldRenderContext context, class_4587 matrices, class_2561 text, float alpha) {
        class_327 tr = class_310.method_1551().field_1772;
        String raw = text.getString();
        List<TitleStyleUtil.Span> spans = TitleStyleUtil.parseSpans(raw);
        int light = class_765.method_23687((int)15, (int)15);
        float scale = 0.025f;
        matrices.method_22903();
        matrices.method_22905(-scale, -scale, scale);
        float totalW = 0.0f;
        for (TitleStyleUtil.Span sp : spans) {
            totalW += (float)tr.method_1727(sp.text());
        }
        float baseX = -totalW / 2.0f;
        class_4597 consumers = context.consumers();
        if (consumers == null) {
            consumers = class_310.method_1551().method_22940().method_23000();
        }
        long nowMs = class_156.method_658();
        float advanceX = 0.0f;
        int globalIndex = 0;
        for (TitleStyleUtil.Span span : spans) {
            int cp;
            String t = span.text();
            int localLen = t.codePointCount(0, t.length());
            int localIndex = 0;
            for (int i = 0; i < t.length(); i += Character.charCount(cp)) {
                float amp;
                int rgb;
                cp = t.codePointAt(i);
                String ch = new String(Character.toChars(cp));
                int cw = tr.method_1727(ch);
                int n = span.gradient() != null ? TitleStyleUtil.gradientRgb(localIndex, localLen, span.gradient()) : (span.rainbow() ? TitleStyleUtil.rainbowRgb(nowMs, globalIndex, span.rainbowSpeed() != null ? span.rainbowSpeed().floatValue() : 0.18f) : (rgb = TitleStyleUtil.resolveOrWhite(span.baseRgb())));
                if (span.pulseSpeed() != null) {
                    rgb = TitleStyleUtil.pulseRgb(nowMs, rgb, span.pulseSpeed().floatValue());
                }
                float yOff = 0.0f;
                if (span.wiggle()) {
                    amp = span.wiggleAmp() != null ? span.wiggleAmp().floatValue() : 2.0f;
                    yOff += TitleStyleUtil.wiggleYOffsetPx(nowMs, globalIndex, amp);
                }
                if (span.bounceAmp() != null || span.bounceSpeed() != null) {
                    amp = span.bounceAmp() != null ? span.bounceAmp().floatValue() : 0.0f;
                    float spd = span.bounceSpeed() != null ? span.bounceSpeed().floatValue() : 3.0f;
                    yOff += TitleStyleUtil.bounceYOffsetPx(nowMs, globalIndex, amp, spd);
                }
                float xOff = 0.0f;
                if (span.waveAmp() != null || span.waveSpeed() != null) {
                    float amp2 = span.waveAmp() != null ? span.waveAmp().floatValue() : 0.0f;
                    float spd = span.waveSpeed() != null ? span.waveSpeed().floatValue() : 2.5f;
                    xOff += TitleStyleUtil.waveXOffsetPx(nowMs, globalIndex, amp2, spd);
                }
                if (span.shakeAmp() != null) {
                    xOff += TitleStyleUtil.shakeXOffsetPx(nowMs, globalIndex, span.shakeAmp().floatValue());
                }
                if (span.glitchIntensity() != null && TitleStyleUtil.glitchActive(nowMs, globalIndex, span.glitchIntensity().floatValue())) {
                    xOff += TitleStyleUtil.glitchJitterX(nowMs, globalIndex, span.glitchIntensity().floatValue());
                    yOff += TitleStyleUtil.glitchJitterY(nowMs, globalIndex, span.glitchIntensity().floatValue());
                    rgb = TitleStyleUtil.glitchTintRgb(nowMs, globalIndex, rgb, span.glitchIntensity().floatValue());
                }
                int argb = (Math.round(alpha * 255.0f) & 0xFF) << 24 | rgb & 0xFFFFFF;
                tr.method_27521(ch, baseX + advanceX + xOff, yOff, argb, false, matrices.method_23760().method_23761(), consumers, class_327.class_6415.field_33993, 0, light);
                advanceX += (float)cw;
                ++globalIndex;
                ++localIndex;
            }
        }
        matrices.method_22909();
    }

    private static boolean isOnScreen(WorldRenderContext context, class_238 box) {
        class_4604 frustum = context.frustum();
        return frustum == null || frustum.method_23093(box);
    }

    private static void faceCamera(class_4587 matrices, class_4184 camera) {
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static double lerp(float t, double a, double b) {
        return a + (b - a) * (double)t;
    }
}

