/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.compat;

import net.critical_strike.CriticalStrikeMod;
import net.critical_strike.api.CriticalDamageSource;
import net.critical_strike.internal.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.pixeldreamstudios.rpgsystems.util.DamageCritLinks;

public final class CriticalStrikeCompat {
    private static final boolean IS_LOADED = FabricLoader.getInstance().isModLoaded("critical_strike");

    private CriticalStrikeCompat() {
    }

    public static void init() {
        if (!IS_LOADED) {
            return;
        }
    }

    public static void onCriticalStrikeDamage(class_1282 source, class_1309 target, boolean isMelee) {
        if (source == null || target == null) {
            return;
        }
        DamageCritLinks.link(source, DamageCritLinks.Kind.MELEE, null);
    }

    public static boolean isCriticalStrikeDamage(class_1282 source) {
        if (source == null || !IS_LOADED) {
            return false;
        }
        try {
            if (source instanceof CriticalDamageSource) {
                CriticalDamageSource critSource = (CriticalDamageSource)source;
                return critSource.rng_isCritical();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean shouldAllowVanillaJumpCrits() {
        if (!IS_LOADED) {
            return true;
        }
        try {
            Config config = (Config)CriticalStrikeMod.config.value;
            return !config.disable_vanilla_jump_criticals;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public static boolean isLoaded() {
        return IS_LOADED;
    }
}

