/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.pixeldreamstudios.rpgsystems.RPGSystems;

public final class RPGSystemsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final String FILE_NAME = "rpgsystems.json";
    private static RPGSystemsConfig INSTANCE;
    public Systems systems = new Systems();
    public Party party = new Party();

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }

    public static synchronized RPGSystemsConfig get() {
        if (INSTANCE == null) {
            RPGSystemsConfig.load();
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        Path p = RPGSystemsConfig.path();
        boolean needsSave = false;
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(p);){
                RPGSystemsConfig loaded = (RPGSystemsConfig)GSON.fromJson((Reader)r, RPGSystemsConfig.class);
                if (loaded == null) {
                    RPGSystems.LOGGER.warn("[Config] File corrupted, using defaults");
                    INSTANCE = new RPGSystemsConfig();
                    needsSave = true;
                } else {
                    String mergedJson;
                    INSTANCE = RPGSystemsConfig.mergeWithDefaults(loaded);
                    String originalJson = GSON.toJson((Object)loaded);
                    if (!originalJson.equals(mergedJson = GSON.toJson((Object)INSTANCE))) {
                        RPGSystems.LOGGER.info("[Config] Added missing fields to config");
                        needsSave = true;
                    }
                }
            }
            catch (Throwable t) {
                RPGSystems.LOGGER.error("[Config] Failed to load, using defaults", t);
                INSTANCE = new RPGSystemsConfig();
                needsSave = true;
            }
        } else {
            RPGSystems.LOGGER.info("[Config] Creating default config");
            INSTANCE = new RPGSystemsConfig();
            needsSave = true;
        }
        if (needsSave) {
            RPGSystemsConfig.save();
        }
    }

    private static RPGSystemsConfig mergeWithDefaults(RPGSystemsConfig loaded) {
        RPGSystemsConfig defaults = new RPGSystemsConfig();
        if (loaded.systems == null) {
            loaded.systems = defaults.systems;
        }
        if (loaded.party == null) {
            loaded.party = defaults.party;
        }
        return loaded;
    }

    public static synchronized void save() {
        Path p = RPGSystemsConfig.path();
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
                ((Writer)w).flush();
            }
            RPGSystems.LOGGER.debug("[Config] Saved to {}", (Object)p);
        }
        catch (IOException e) {
            RPGSystems.LOGGER.error("[Config] Failed to save", (Throwable)e);
        }
    }

    public static synchronized void reload() {
        INSTANCE = null;
        RPGSystemsConfig.load();
    }

    public static final class Systems {
        public boolean party = true;
        public boolean pet = false;
        public boolean title = true;
    }

    public static final class Party {
        public boolean logChatToConsole = true;
        public boolean useFTBTeams = false;
    }
}

