/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.mixin;

import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.pixeldreamstudios.rpgsystems.accessor.LivingEntityRawDamageAccess;
import net.pixeldreamstudios.rpgsystems.compat.CriticalStrikeCompat;
import net.pixeldreamstudios.rpgsystems.network.EnemyNet;
import net.pixeldreamstudios.rpgsystems.party.PartyAllies;
import net.pixeldreamstudios.rpgsystems.util.DamageColorUtil;
import net.pixeldreamstudios.rpgsystems.util.DamageCritLinks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityDamageMixin {
    @Unique
    private float rpgsystems$preHp;
    @Unique
    private float rpgsystems$preAbs;

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void rpgsystems$capturePreHp(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309)this;
        this.rpgsystems$preHp = self.method_6032();
        this.rpgsystems$preAbs = self.method_6067();
        if (CriticalStrikeCompat.isLoaded() && CriticalStrikeCompat.isCriticalStrikeDamage(source)) {
            DamageCritLinks.link(source, DamageCritLinks.Kind.MELEE, null);
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void rpgsystems$afterDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean sourceIsMagic;
        LivingEntityRawDamageAccess acc;
        UUID rawAttacker;
        float postAbs;
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        class_1309 self = (class_1309)this;
        class_1937 world = self.method_37908();
        if (world.method_8608()) {
            return;
        }
        float preTotal = this.rpgsystems$preHp + this.rpgsystems$preAbs;
        float postHp = self.method_6032();
        float postTotal = postHp + (postAbs = self.method_6067());
        float taken = preTotal - postTotal;
        if (taken <= 0.01f) {
            return;
        }
        class_1297 attacker = source.method_5529();
        class_1297 origin = attacker != null ? attacker : source.method_5526();
        boolean isPet = origin instanceof class_6025;
        UUID ownerUuid = PartyAllies.owningPlayerUuidFromAttacker(origin);
        UUID srcUuid = ownerUuid != null ? ownerUuid : (origin != null ? origin.method_5667() : new UUID(0L, 0L));
        float displayDamage = taken;
        boolean killedNow = postHp <= 0.0f;
        boolean rawMatchesAttacker = false;
        float rawAmount = 0.0f;
        if (self instanceof LivingEntityRawDamageAccess && (rawAttacker = (acc = (LivingEntityRawDamageAccess)self).rpgsystems$getLastRawDamageAttacker()) != null) {
            UUID cmp;
            UUID uUID = ownerUuid != null ? ownerUuid : (cmp = origin != null ? origin.method_5667() : self.method_5667());
            if (cmp.equals(rawAttacker)) {
                rawMatchesAttacker = true;
                rawAmount = acc.rpgsystems$getLastRawDamageAmount();
            }
        }
        if (killedNow && rawMatchesAttacker && rawAmount > 0.0f) {
            displayDamage = Math.max(displayDamage, rawAmount);
        }
        DamageCritLinks.Info link = DamageCritLinks.consume(source);
        boolean crit = link.isCrit();
        boolean magicCrit = link.isMagic();
        boolean bl = sourceIsMagic = source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329);
        if (magicCrit && !sourceIsMagic) {
            magicCrit = true;
        }
        int rgb = DamageColorUtil.colorOf(world, source, self, crit, magicCrit, link.colorOverride);
        class_2960 dmgId = class_2960.method_60655((String)"minecraft", (String)"unknown");
        if (source != null) {
            class_6880 entry = source.method_48793();
            dmgId = entry.method_40230().map(class_5321::method_29177).orElse(class_2960.method_60655((String)"minecraft", (String)"unknown"));
        }
        EnemyNet.broadcastDamageNumber((class_1297)self, displayDamage, crit, isPet, rgb, srcUuid, dmgId);
    }
}

