/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.pet;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3222;
import net.pixeldreamstudios.rpgsystems.pet.PetOwnable;

public final class PetCommands {
    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pet").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"claim").executes(ctx -> PetCommands.claimLookingAt((class_2168)ctx.getSource(), null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PetCommands.claimLookingAt((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"unclaim").executes(ctx -> PetCommands.unclaimLookingAt((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PetCommands.renameLookingAt((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"tp").executes(ctx -> PetCommands.tpRpgs((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"tp_rpgs").executes(ctx -> PetCommands.tpRpgs((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"tp_vanilla").executes(ctx -> PetCommands.tpVanilla((class_2168)ctx.getSource()))));
    }

    private static int tpRpgs(class_2168 src) {
        class_3222 p = src.method_44023();
        class_1308 mob = PetCommands.findOwnedRpgsPetNear(p, 16.0);
        if (mob == null) {
            p.method_43496((class_2561)class_2561.method_43470((String)"No nearby owned RPGS pet"));
            return 0;
        }
        PetCommands.teleportToPlayer(mob, p);
        p.method_43496((class_2561)class_2561.method_43470((String)"Pet teleported"));
        return 1;
    }

    private static int tpVanilla(class_2168 src) {
        class_3222 p = src.method_44023();
        class_1308 mob = PetCommands.findOwnedVanillaPetNear(p, 16.0);
        if (mob == null) {
            p.method_43496((class_2561)class_2561.method_43470((String)"No nearby vanilla tamed pet you own"));
            return 0;
        }
        PetCommands.teleportToPlayer(mob, p);
        p.method_43496((class_2561)class_2561.method_43470((String)"Pet teleported"));
        return 1;
    }

    private static void teleportToPlayer(class_1308 mob, class_3222 p) {
        if (mob.method_37908() == p.method_37908()) {
            mob.method_6082(p.method_23317(), p.method_23318(), p.method_23321(), true);
            PetCommands.orientToPlayer(mob, p);
            return;
        }
        mob.method_48105(p.method_51469(), p.method_23317(), p.method_23318(), p.method_23321(), EnumSet.noneOf(class_2709.class), p.method_36454(), p.method_36455());
    }

    private static void orientToPlayer(class_1308 mob, class_3222 p) {
        mob.method_36456(p.method_36454());
        mob.method_36457(p.method_36455());
        if (mob instanceof class_1309) {
            class_1308 le = mob;
            le.method_5847(p.method_36454());
        }
    }

    private static int claimLookingAt(class_2168 src, String name) {
        class_3222 p = src.method_44023();
        class_1308 mob = PetCommands.findMobInFront(p, 5.0);
        if (mob == null) {
            p.method_43496((class_2561)class_2561.method_43470((String)"Look at a mob within 5 blocks"));
            return 0;
        }
        PetOwnable own = (PetOwnable)mob;
        own.rpgsystems$setPet(true);
        own.rpgsystems$setOwnerUuid(p.method_5667());
        if (name != null) {
            own.rpgsystems$setPetName(name);
        }
        p.method_43496((class_2561)class_2561.method_43470((String)"Claimed pet"));
        return 1;
    }

    private static int unclaimLookingAt(class_2168 src) {
        class_3222 p = src.method_44023();
        class_1308 mob = PetCommands.findMobInFront(p, 5.0);
        if (mob == null) {
            p.method_43496((class_2561)class_2561.method_43470((String)"Look at a mob within 5 blocks"));
            return 0;
        }
        PetOwnable own = (PetOwnable)mob;
        UUID owner = own.rpgsystems$getOwnerUuid();
        if (owner == null || !owner.equals(p.method_5667())) {
            p.method_43496((class_2561)class_2561.method_43470((String)"You are not the owner"));
            return 0;
        }
        own.rpgsystems$setPet(false);
        own.rpgsystems$setOwnerUuid(null);
        own.rpgsystems$setPetName("");
        p.method_43496((class_2561)class_2561.method_43470((String)"Unclaimed pet"));
        return 1;
    }

    private static int renameLookingAt(class_2168 src, String name) {
        class_3222 p = src.method_44023();
        class_1308 mob = PetCommands.findMobInFront(p, 5.0);
        if (mob == null) {
            p.method_43496((class_2561)class_2561.method_43470((String)"Look at a mob within 5 blocks"));
            return 0;
        }
        PetOwnable own = (PetOwnable)mob;
        if (!p.method_5667().equals(own.rpgsystems$getOwnerUuid())) {
            p.method_43496((class_2561)class_2561.method_43470((String)"You are not the owner"));
            return 0;
        }
        own.rpgsystems$setPetName(name);
        p.method_43496((class_2561)class_2561.method_43470((String)"Renamed pet"));
        return 1;
    }

    private static class_1308 findMobInFront(class_3222 p, double range) {
        class_243 eyes = p.method_5836(1.0f);
        class_243 look = p.method_5828(1.0f).method_1029();
        class_243 end = eyes.method_1019(look.method_1021(range));
        class_238 box = new class_238(eyes, end).method_1014(1.0);
        List mobs = p.method_37908().method_8390(class_1308.class, box, class_1297::method_5805);
        if (mobs.isEmpty()) {
            return null;
        }
        return mobs.stream().min(Comparator.comparingDouble(m -> m.method_19538().method_1025(end))).orElse(null);
    }

    private static class_1308 findOwnedRpgsPetNear(class_3222 p, double radius) {
        List mobs = p.method_37908().method_8390(class_1308.class, p.method_5829().method_1014(radius), class_1297::method_5805);
        UUID me = p.method_5667();
        class_1308 best = null;
        double bestDist = Double.MAX_VALUE;
        for (class_1308 mob : mobs) {
            double d;
            PetOwnable own = (PetOwnable)mob;
            if (!own.rpgsystems$isPet() || !me.equals(own.rpgsystems$getOwnerUuid()) || !((d = mob.method_5858((class_1297)p)) < bestDist)) continue;
            bestDist = d;
            best = mob;
        }
        return best;
    }

    private static class_1308 findOwnedVanillaPetNear(class_3222 p, double radius) {
        List mobs = p.method_37908().method_8390(class_1308.class, p.method_5829().method_1014(radius), class_1297::method_5805);
        UUID me = p.method_5667();
        class_1308 best = null;
        double bestDist = Double.MAX_VALUE;
        for (class_1308 mob : mobs) {
            double d;
            boolean owned = false;
            if (mob instanceof class_1321) {
                class_1321 tame = (class_1321)mob;
                u = tame.method_6139();
                owned = tame.method_6181() && u != null && u.equals(me);
            } else if (mob instanceof class_1496) {
                class_1496 horse = (class_1496)mob;
                u = horse.method_6139();
                boolean bl = owned = horse.method_6727() && u != null && u.equals(me);
            }
            if (!owned || !((d = mob.method_5858((class_1297)p)) < bestDist)) continue;
            bestDist = d;
            best = mob;
        }
        return best;
    }
}

