/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.pixeldreamstudios.rpgsystems.title.PermaGroupKey;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;
import net.pixeldreamstudios.rpgsystems.util.TitlePowerBonusUtil;
import net.pixeldreamstudios.rpgsystems.util.TitleSpellBonusUtil;

public final class TitleApi {
    private TitleApi() {
    }

    public static boolean grant(class_3222 player, class_2960 titleId) {
        Title t = TitleRegistry.get(titleId);
        if (t == null) {
            return false;
        }
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        boolean added = pt.unlocked.add(titleId.toString());
        if (added) {
            state.method_80();
            String rawName = TitleApi.extractRawName(t);
            String plainName = TitleApi.stripStyleTokens(rawName);
            player.method_43496((class_2561)class_2561.method_43470((String)("You have unlocked the title " + plainName)));
            List<Title> unlocked = TitleApi.resolveUnlockedTitles(state, pt);
            TitleSpellBonusUtil.rebuildPermaTitleSpells(player, unlocked);
            TitlePowerBonusUtil.rebuildPermaTitlePowers(player, unlocked);
            TitleApi.rebuildPermaAttributes(player, unlocked);
            return true;
        }
        return false;
    }

    public static boolean revoke(class_3222 player, class_2960 titleId) {
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        boolean removed = pt.unlocked.remove(titleId.toString());
        if (removed) {
            if (pt.active != null && titleId.toString().equals(pt.active)) {
                TitleApi.applyActiveTitle(player, Optional.ofNullable(class_2960.method_60654((String)pt.active)), Optional.empty());
                pt.active = null;
            }
            state.method_80();
            List<Title> unlocked = TitleApi.resolveUnlockedTitles(state, pt);
            TitleSpellBonusUtil.rebuildPermaTitleSpells(player, unlocked);
            TitlePowerBonusUtil.rebuildPermaTitlePowers(player, unlocked);
            TitleApi.rebuildPermaAttributes(player, unlocked);
            return true;
        }
        return false;
    }

    public static boolean setActive(class_3222 player, Optional<class_2960> newActiveOpt) {
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        Optional<Object> old = Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
        if (newActiveOpt.isPresent()) {
            class_2960 id = newActiveOpt.get();
            if (!pt.unlocked.contains(id.toString())) {
                return false;
            }
            pt.active = id.toString();
        } else {
            pt.active = null;
        }
        TitleApi.applyActiveTitle(player, old, newActiveOpt);
        state.method_80();
        return true;
    }

    public static void refreshActiveOnLogin(class_3222 player) {
        class_2960 id;
        Title t;
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        if (pt.active != null && (t = TitleRegistry.get(id = class_2960.method_60654((String)pt.active))) != null) {
            TitleApi.removeBonuses(player, t);
            TitleApi.applyBonuses(player, t);
        }
        List<Title> unlocked = TitleApi.resolveUnlockedTitles(state, pt);
        Title equipped = pt.active != null ? TitleRegistry.get(class_2960.method_60654((String)pt.active)) : null;
        TitleSpellBonusUtil.rebuildAllTitleSpells(player, equipped, unlocked);
        TitlePowerBonusUtil.rebuildAllTitlePowers(player, equipped, unlocked);
        TitleApi.rebuildPermaAttributes(player, unlocked);
        float max = player.method_6063();
        if (player.method_6032() > max) {
            player.method_6033(max);
        }
    }

    public static boolean clearProgress(class_3222 player, class_2960 titleId) {
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        class_2487 removed = pt.progress.remove(titleId.toString());
        state.method_80();
        return removed != null;
    }

    public static Optional<class_2960> getActiveId(class_3222 player) {
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        return Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
    }

    public static Optional<Title> getActive(class_3222 player) {
        return TitleApi.getActiveId(player).map(TitleRegistry::get);
    }

    public static boolean isActive(class_3222 player, class_2960 titleId) {
        return TitleApi.getActiveId(player).map(id -> id.equals((Object)titleId)).orElse(false);
    }

    private static void applyActiveTitle(class_3222 player, Optional<class_2960> oldActive, Optional<class_2960> newActive) {
        oldActive.ifPresent(id -> {
            Title t = TitleRegistry.get(id);
            if (t != null) {
                TitleApi.removeBonuses(player, t);
            }
        });
        newActive.ifPresent(id -> {
            Title t = TitleRegistry.get(id);
            if (t != null) {
                TitleApi.applyBonuses(player, t);
            }
        });
        float max = player.method_6063();
        if (player.method_6032() > max) {
            player.method_6033(max);
        }
    }

    private static void applyBonuses(class_3222 player, Title t) {
        ArrayList<class_2960> spells = new ArrayList<class_2960>();
        for (Title.Bonus b : t.bonuses) {
            class_1324 inst;
            if (b.spellId != null && b.spellId.isPresent()) {
                spells.add(b.spellId.get());
                continue;
            }
            if (b.attribute == null || (inst = player.method_5996(b.attribute)) == null) continue;
            class_2960 mid = TitleApi.modifierIdEquipped(t, b);
            inst.method_6200(mid);
            inst.method_26837(new class_1322(mid, b.amount, b.operation));
        }
        if (!spells.isEmpty()) {
            TitleSpellBonusUtil.installTitleSpells(player, t.id, spells);
        }
        ArrayList<class_2960> powers = new ArrayList<class_2960>();
        for (Title.Bonus b : t.bonuses) {
            if (b.powerId == null || !b.powerId.isPresent()) continue;
            powers.add(b.powerId.get());
        }
        if (!powers.isEmpty()) {
            TitlePowerBonusUtil.installTitlePowers(player, t.id, powers);
        }
    }

    private static void removeBonuses(class_3222 player, Title t) {
        for (Title.Bonus b : t.bonuses) {
            class_1324 inst;
            if (b.spellId != null && b.spellId.isPresent() || b.attribute == null || (inst = player.method_5996(b.attribute)) == null) continue;
            class_2960 mid = TitleApi.modifierIdEquipped(t, b);
            inst.method_6200(mid);
        }
        TitleSpellBonusUtil.uninstallTitleSpells(player, t.id);
        TitlePowerBonusUtil.uninstallTitlePowers(player, t);
    }

    public static void rebuildPermaAttributes(class_3222 player, List<Title> unlockedTitles) {
        for (Title t : TitleRegistry.all().values()) {
            for (Title.Bonus b : t.permaBonuses) {
                class_1324 inst;
                if (b.attribute == null || (inst = player.method_5996(b.attribute)) == null) continue;
                class_2960 mid = TitleApi.modifierIdPerma(t, b);
                inst.method_6200(mid);
            }
        }
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        Set<String> disabled = pt.permaDisabledGroups;
        if (unlockedTitles != null) {
            for (Title t : unlockedTitles) {
                for (Title.Bonus b : t.permaBonuses) {
                    class_2960 attrId;
                    String key;
                    class_1324 inst;
                    if (b.attribute == null || (inst = player.method_5996(b.attribute)) == null || disabled.contains(key = PermaGroupKey.attr(attrId = TitleApi.attributeIdOf(b), b.operation))) continue;
                    class_2960 mid = TitleApi.modifierIdPerma(t, b);
                    inst.method_6200(mid);
                    inst.method_26837(new class_1322(mid, b.amount, b.operation));
                }
            }
        }
    }

    private static List<Title> resolveUnlockedTitles(TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        if (pt.unlocked.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Title> out = new ArrayList<Title>(pt.unlocked.size());
        for (String s : pt.unlocked) {
            try {
                class_2960 id = class_2960.method_60654((String)s);
                Title t = TitleRegistry.get(id);
                if (t == null) continue;
                out.add(t);
            }
            catch (Exception exception) {}
        }
        return out;
    }

    private static class_2960 modifierIdEquipped(Title t, Title.Bonus b) {
        class_2960 attrId = TitleApi.attributeIdOf(b);
        String path = "title/" + t.id.method_12836() + "/" + t.id.method_12832() + "/" + attrId.method_12836() + "/" + attrId.method_12832();
        return class_2960.method_60655((String)"rpg-systems", (String)path);
    }

    private static class_2960 modifierIdPerma(Title t, Title.Bonus b) {
        class_2960 attrId = TitleApi.attributeIdOf(b);
        String path = "title/perma/" + t.id.method_12836() + "/" + t.id.method_12832() + "/" + attrId.method_12836() + "/" + attrId.method_12832();
        return class_2960.method_60655((String)"rpg-systems", (String)path);
    }

    private static class_2960 attributeIdOf(Title.Bonus b) {
        return b.attribute == null ? class_2960.method_60655((String)"minecraft", (String)"unknown") : b.attribute.method_40230().map(class_5321::method_29177).orElse(class_2960.method_60655((String)"minecraft", (String)"unknown"));
    }

    private static String extractRawName(Title t) {
        try {
            class_2561 dn = t.displayName;
            if (dn instanceof class_2561) {
                class_2561 txt = dn;
                return txt.getString();
            }
            return String.valueOf(dn);
        }
        catch (Throwable ignored) {
            return t.id.method_12832();
        }
    }

    private static String stripStyleTokens(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        String out = s;
        out = out.replaceAll("(?i)\\{\\s*(?:rainbow|wiggle|gradient|pulse|shake|color|bounce|wave|glitch|clear|reset)(?:[^}]*)\\}", "");
        out = out.replaceAll("(?i)\\{\\s*/\\s*(?:rainbow|wiggle|gradient|pulse|shake|color|bounce|wave|glitch|clear|reset)\\s*\\}", "");
        out = out.replaceAll("(?i)&[0-9a-frk-o]", "");
        out = out.replace('\u00a7', ' ');
        out = out.replaceAll("\\s+", " ").trim();
        return out;
    }
}

