/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_310;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;

public final class ClientPartyPins {
    private static final List<UUID> PIN_ORDER = new ArrayList<UUID>();
    private static String lastWorldKey = null;
    private static String lastPartySignature = null;

    private ClientPartyPins() {
    }

    public static synchronized void pin(UUID uuid, int ignoredSlot, int ignoredMaxSlots) {
        if (uuid == null) {
            return;
        }
        if (!PIN_ORDER.contains(uuid)) {
            PIN_ORDER.add(uuid);
        }
    }

    public static synchronized void unpin(UUID uuid) {
        if (uuid == null) {
            return;
        }
        PIN_ORDER.remove(uuid);
    }

    public static synchronized Integer getOrder(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        int idx = PIN_ORDER.indexOf(uuid);
        return idx < 0 ? null : Integer.valueOf(idx + 1);
    }

    public static synchronized boolean isPinned(UUID uuid) {
        return ClientPartyPins.getOrder(uuid) != null;
    }

    public static synchronized int nextOrder() {
        return PIN_ORDER.size() + 1;
    }

    public static synchronized void clearAll() {
        PIN_ORDER.clear();
        lastPartySignature = null;
    }

    public static synchronized void updateScopeAndPrune(List<ClientPartyHudData.Member> members) {
        String partySig;
        String currentWorld = ClientPartyPins.resolveWorldKey();
        if (!Objects.equals(currentWorld, lastWorldKey)) {
            lastWorldKey = currentWorld;
            ClientPartyPins.clearAll();
        }
        if ((partySig = ClientPartyPins.buildSignature(members)) == null || partySig.isEmpty()) {
            if (lastPartySignature != null) {
                ClientPartyPins.clearAll();
            }
            lastPartySignature = null;
        } else if (!Objects.equals(partySig, lastPartySignature)) {
            ClientPartyPins.prunePinsToMembers(members);
            lastPartySignature = partySig;
        } else {
            ClientPartyPins.prunePinsToMembers(members);
        }
    }

    private static void prunePinsToMembers(List<ClientPartyHudData.Member> members) {
        HashSet<UUID> valid = new HashSet<UUID>();
        for (ClientPartyHudData.Member m : members) {
            if (m == null || m.uuid == null) continue;
            valid.add(m.uuid);
        }
        PIN_ORDER.removeIf(u -> !valid.contains(u));
    }

    private static String buildSignature(List<ClientPartyHudData.Member> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientPartyHudData.Member m : members) {
            if (m == null || m.uuid == null) continue;
            ids.add(m.uuid.toString());
        }
        if (ids.isEmpty()) {
            return "";
        }
        Collections.sort(ids);
        return String.join((CharSequence)"|", ids);
    }

    private static String resolveWorldKey() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1687.method_27983() == null || mc.field_1687.method_27983().method_29177() == null) {
            return "unknown";
        }
        return mc.field_1687.method_27983().method_29177().toString();
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized List<ClientPartyHudData.Member> orderedForHud(List<ClientPartyHudData.Member> rawMembers, UUID leaderUuid, int maxVisible) {
        ClientPartyPins.updateScopeAndPrune(rawMembers);
        HashMap<UUID, ClientPartyHudData.Member> byId = new HashMap<UUID, ClientPartyHudData.Member>();
        ArrayList<ClientPartyHudData.Member> online = new ArrayList<ClientPartyHudData.Member>();
        for (ClientPartyHudData.Member member : rawMembers) {
            if (member == null || member.uuid == null) continue;
            byId.put(member.uuid, member);
            if (!member.online) continue;
            online.add(member);
        }
        ArrayList<ClientPartyHudData.Member> result = new ArrayList<ClientPartyHudData.Member>();
        if (maxVisible == 0) {
            return result;
        }
        for (UUID uUID : PIN_ORDER) {
            ClientPartyHudData.Member member = (ClientPartyHudData.Member)byId.get(uUID);
            if (member == null || !member.online) continue;
            result.add(member);
        }
        ArrayList<ClientPartyHudData.Member> arrayList = new ArrayList<ClientPartyHudData.Member>();
        for (ClientPartyHudData.Member member : online) {
            if (ClientPartyPins.isPinned(member.uuid)) continue;
            arrayList.add(member);
        }
        if (leaderUuid != null) {
            void var7_13;
            Object var7_11 = null;
            for (ClientPartyHudData.Member m : arrayList) {
                if (!leaderUuid.equals(m.uuid)) continue;
                ClientPartyHudData.Member member = m;
                break;
            }
            if (var7_13 != null) {
                result.add((ClientPartyHudData.Member)var7_13);
                arrayList.remove(var7_13);
            }
        }
        result.addAll(arrayList);
        if (maxVisible > 0 && result.size() > maxVisible) {
            result = new ArrayList(result.subList(0, maxVisible));
        }
        return result;
    }
}

