/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import net.pixeldreamstudios.rpgsystems.client.config.MiscClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyInvites;

@Environment(value=EnvType.CLIENT)
public final class PartyInviteHud
implements HudRenderCallback {
    private static final class_2960 TEX_NOTIFICATION = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_invite_notification.png");
    private static final class_2960 TEX_ACCEPT = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_invite_accept.png");
    private static final class_2960 TEX_DECLINE = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_invite_decline.png");
    private static final class_2960 TEX_EXPIRED = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_invite_expired.png");
    private static final class_2960 TEX_JOIN_REQ = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_join.png");
    private static final class_2960 TEX_JOIN_REQ_ACC = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_join_accept.png");
    private static final class_2960 TEX_JOIN_REQ_DEC = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_join_decline.png");
    private static final class_2960 TEX_LEAVE = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_leave.png");
    private static final class_2960 TEX_KICK = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_kick.png");
    private static final class_2960[] ALL_TEX = new class_2960[]{TEX_NOTIFICATION, TEX_ACCEPT, TEX_DECLINE, TEX_EXPIRED, TEX_JOIN_REQ, TEX_LEAVE, TEX_KICK, TEX_JOIN_REQ_ACC, TEX_JOIN_REQ_DEC};
    private static final int TEX_W = 64;
    private static final int TEX_H = 32;
    private static final float SCALE = 0.5f;
    private static final int VIS_W = Math.round(32.0f);
    private static final int VIS_H = Math.round(16.0f);
    private static final int STACK_GAP = 6;
    private static final long SHOW_MS = 5000L;
    private static final long SLIDE_MS = 300L;
    private static boolean filtered = false;
    private static final List<Toast> TOASTS = new ArrayList<Toast>();
    private static final Set<String> SEEN = new HashSet<String>();

    public static void init() {
        HudRenderCallback.EVENT.register((Object)new PartyInviteHud());
    }

    private static class_2960 texForKind(ClientPartyInvites.NoticeKind kind) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case ClientPartyInvites.NoticeKind.INVITE_ACCEPT -> TEX_ACCEPT;
            case ClientPartyInvites.NoticeKind.INVITE_DECLINE -> TEX_DECLINE;
            case ClientPartyInvites.NoticeKind.INVITE_EXPIRED -> TEX_EXPIRED;
            case ClientPartyInvites.NoticeKind.JOIN_VIA_INVITE -> TEX_JOIN_REQ;
            case ClientPartyInvites.NoticeKind.PARTY_LEFT -> TEX_LEAVE;
            case ClientPartyInvites.NoticeKind.PARTY_KICK -> TEX_KICK;
            case ClientPartyInvites.NoticeKind.PARTY_JOIN_REQ_ACC -> TEX_JOIN_REQ_ACC;
            case ClientPartyInvites.NoticeKind.PARTY_JOIN_REQ_DEC -> TEX_JOIN_REQ_DEC;
            case ClientPartyInvites.NoticeKind.INVITE_SENT, ClientPartyInvites.NoticeKind.INVITE_RECEIVED -> TEX_NOTIFICATION;
        };
    }

    public void onHudRender(class_332 ctx, class_9779 tickCounter) {
        int baseBottom;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1690.field_1842) {
            return;
        }
        PartyInviteHud.ensureNearest();
        for (ClientPartyInvites.Notice n : new ArrayList<ClientPartyInvites.Notice>(ClientPartyInvites.notices())) {
            String key = n.createdAt + ":" + n.text;
            if (!SEEN.add(key)) continue;
            TOASTS.add(new Toast(key, System.currentTimeMillis(), PartyInviteHud.texForKind(n.kind)));
        }
        long now = System.currentTimeMillis();
        TOASTS.removeIf(t -> now - t.startAtMs >= 5300L);
        MiscClientConfig cfg = MiscClientConfig.get();
        int baseLeft = cfg.inviteHudX;
        int nextBottom = baseBottom = ctx.method_51443() - cfg.inviteHudY;
        ListIterator<Toast> it = TOASTS.listIterator(TOASTS.size());
        while (it.hasPrevious()) {
            Toast t2 = it.previous();
            float slide = PartyInviteHud.slideProgress(now - t2.startAtMs);
            int offX = -VIS_W - baseLeft;
            int targetX = baseLeft;
            int drawX = Math.round(PartyInviteHud.lerp(offX, targetX, slide));
            int drawY = nextBottom - VIS_H;
            nextBottom = drawY - 6;
            class_4587 m = ctx.method_51448();
            m.method_22903();
            m.method_46416((float)drawX, (float)drawY, 0.0f);
            m.method_22905(0.5f, 0.5f, 1.0f);
            ctx.method_25290(t2.tex, 0, 0, 0.0f, 0.0f, 64, 32, 64, 32);
            m.method_22909();
        }
    }

    private static float slideProgress(long elapsedMs) {
        if (elapsedMs <= 300L) {
            return (float)elapsedMs / 300.0f;
        }
        if (elapsedMs >= 5000L) {
            return 1.0f - (float)Math.min(300L, elapsedMs - 5000L) / 300.0f;
        }
        return 1.0f;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * Math.max(0.0f, Math.min(1.0f, t));
    }

    private static void ensureNearest() {
        if (filtered) {
            return;
        }
        class_1060 tm = class_310.method_1551().method_1531();
        for (class_2960 id : ALL_TEX) {
            class_1044 tex = tm.method_4619(id);
            if (tex == null) continue;
            tex.method_4527(false, false);
        }
        filtered = true;
    }

    private static final class Toast {
        final String key;
        final long startAtMs;
        final class_2960 tex;

        Toast(String key, long startAtMs, class_2960 tex) {
            this.key = key;
            this.startAtMs = startAtMs;
            this.tex = tex;
        }
    }
}

