/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyMemberInfoClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.compat.RpgManaCompat;
import net.pixeldreamstudios.rpgsystems.compat.TrbAttributesCompat;
import net.pixeldreamstudios.rpgsystems.compat.showbuild.ShowBuildCompatPayloads;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class PartyMemberInfoBox
implements PartyBox {
    private static final boolean DEBUG_BOX = false;
    private static final class_2960 INFO_BUTTON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/info_button.png");
    private static final int ICON_W = 16;
    private static final int ICON_H = 16;
    private static final int ICON_PAD = 4;
    private static boolean iconFiltered = false;
    private int infoBtnX = -1;
    private int infoBtnY = -1;
    private int infoBtnW = 0;
    private int infoBtnH = 0;
    private static final int TL_BOX_W = 120;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final int GAP_FROM_LEFT_COLUMN = 12;
    private static final boolean USE_FIXED_SIZE = true;
    private static final int BOX_W = 250;
    private static final int BOX_H_ONE_ROW = 41;
    private static final int PAD = 4;
    private static final int BAR_H = 8;
    private static final int ROW_VGAP = 6;
    private static final int CENTER_GAP_DEFAULT = 26;
    private static final float TEXT_SCALE = 0.6f;
    private static final int BAR_BG = -14671840;
    private static final int HP_COLOR = -13710223;
    private static final int HUNGER_COLOR = -812014;
    private static final int STAMINA_COLOR = -812014;
    private static final int MANA_COLOR = -13330213;
    private static final int RPG_MANA_COLOR = -13330213;
    private static final int VALUE_TEXT_COLOR = -1;
    private static final int VALUE_TEXT_HP_ABS_COLOR = -1128662;
    private static final class_2960 TEX_BAR_OUTLINE = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/bar_outline_memberinfo.png");
    private static final class_2960 TEX_HP_FILL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/health_bar_memberinfo.png");
    private static final class_2960 TEX_ABSORB_FILL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/absorption_bar_memberinfo.png");
    private static final class_2960 TEX_MANA_FILL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/mana_bar_memberinfo.png");
    private static final class_2960 TEX_HUNGER_FILL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/hunger_bar_memberinfo.png");
    private static boolean barTexturesFiltered = false;
    private static final int TEX_SRC_W = 108;
    private static final int TEX_SRC_H = 8;
    private static final Map<UUID, class_745> DUMMIES = new HashMap<UUID, class_745>();

    private static void ensureBarTexturesNearest() {
        class_1044 g;
        class_1044 m;
        class_1044 a;
        class_1044 h;
        if (barTexturesFiltered) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_1060 tm = mc.method_1531();
        class_1044 o = tm.method_4619(TEX_BAR_OUTLINE);
        if (o != null) {
            o.method_4527(false, false);
        }
        if ((h = tm.method_4619(TEX_HP_FILL)) != null) {
            h.method_4527(false, false);
        }
        if ((a = tm.method_4619(TEX_ABSORB_FILL)) != null) {
            a.method_4527(false, false);
        }
        if ((m = tm.method_4619(TEX_MANA_FILL)) != null) {
            m.method_4527(false, false);
        }
        if ((g = tm.method_4619(TEX_HUNGER_FILL)) != null) {
            g.method_4527(false, false);
        }
        barTexturesFiltered = true;
    }

    private static int valueColor(Bar b) {
        if (b.kind == Kind.HP && b.extraPct > 0.001f) {
            return -1128662;
        }
        return -1;
    }

    private static void drawValueTextLeft(class_332 ctx, class_327 tr, Bar b, int x, int y, float scale) {
        String cur = b.valueText;
        String rest = "";
        if (b.kind == Kind.HP) {
            String[] parts = cur.split("/", 2);
            cur = parts.length > 0 ? parts[0] : cur;
            rest = parts.length > 1 ? "/" + parts[1] : "";
        }
        int curCol = b.kind == Kind.HP && b.extraPct > 0.001f ? -1128662 : -1;
        int restCol = -1;
        PartyMemberInfoBox.drawScaledText(ctx, tr, cur, x, y, curCol, scale);
        int curW = Math.round((float)tr.method_1727(cur) * scale);
        if (!rest.isEmpty()) {
            PartyMemberInfoBox.drawScaledText(ctx, tr, rest, x + curW, y, restCol, scale);
        }
    }

    private static void drawValueTextRight(class_332 ctx, class_327 tr, Bar b, int rightX, int y, float scale) {
        String cur = b.valueText;
        String rest = "";
        if (b.kind == Kind.HP) {
            String[] parts = cur.split("/", 2);
            cur = parts.length > 0 ? parts[0] : cur;
            rest = parts.length > 1 ? "/" + parts[1] : "";
        }
        int curCol = b.kind == Kind.HP && b.extraPct > 0.001f ? -1128662 : -1;
        int restCol = -1;
        int curW = Math.round((float)tr.method_1727(cur) * scale);
        int restW = Math.round((float)tr.method_1727(rest) * scale);
        int startX = rightX - (curW + restW);
        PartyMemberInfoBox.drawScaledText(ctx, tr, cur, startX, y, curCol, scale);
        if (!rest.isEmpty()) {
            PartyMemberInfoBox.drawScaledText(ctx, tr, rest, startX + curW, y, restCol, scale);
        }
    }

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        Bar b;
        int contentLeft = canvasX + 8 + 18;
        int contentRight = canvasX + canvasW - 8 - 18;
        int infoTop = canvasY + 8 + 15;
        int leftColW = 120;
        int x = contentLeft + leftColW + 12 - 60;
        int y = infoTop;
        int autoW = Math.max(0, contentRight - x);
        int autoBottom = canvasY + canvasH - 8;
        int autoH = Math.max(0, autoBottom - y);
        List<Bar> bars = PartyMemberInfoBox.collectBars();
        int w = 250;
        int h = 41;
        ClientPartyHudData.Member m = ClientPartyHudData.getSelectedOrDefault();
        if (m == null) {
            String none = "Select a member";
            int tw = Math.round((float)tr.method_1727(none) * 0.6f);
            int n = x + (w - tw) / 2;
            Objects.requireNonNull(tr);
            PartyMemberInfoBox.drawScaledText(ctx, tr, none, n, y + (h - Math.round(9.0f * 0.6f)) / 2, -4276546, 0.6f);
            this.infoBtnH = 0;
            this.infoBtnW = 0;
            return;
        }
        if (!iconFiltered) {
            class_1060 tm = class_310.method_1551().method_1531();
            class_1044 t1 = tm.method_4619(INFO_BUTTON);
            if (t1 != null) {
                t1.method_4527(false, false);
            }
            iconFiltered = true;
        }
        PartyMemberInfoBox.ensureBarTexturesNearest();
        int topY = y + 4 + 6;
        int minBarW = 50;
        for (Bar b2 : bars) {
            int wTxt = Math.round((float)tr.method_1727(b2.valueText) * 0.6f);
            minBarW = Math.max(minBarW, wTxt + 6);
        }
        int centerGap = Math.max(10, Math.min(26, w - 8 - 2 * minBarW));
        int maxBarWEach = Math.max(0, (w - 8 - centerGap) / 2);
        int barW = Math.max(minBarW, maxBarWEach);
        int leftX = x + 4;
        int rightX = x + w - 4 - barW;
        if (bars.size() >= 1) {
            b = bars.get(0);
            PartyMemberInfoBox.drawBarSmart(ctx, leftX, topY, barW, 8, b);
            PartyMemberInfoBox.drawScaledText(ctx, tr, b.label, leftX, topY - 7, -1, 0.6f);
            PartyMemberInfoBox.drawValueTextLeft(ctx, tr, b, leftX + 3, topY + 2, 0.6f);
        }
        if (bars.size() >= 2) {
            b = bars.get(1);
            PartyMemberInfoBox.drawBarSmart(ctx, rightX, topY, barW, 8, b);
            PartyMemberInfoBox.drawRightScaledText(ctx, tr, b.label, rightX + barW, topY - 7, -1, 0.6f);
            PartyMemberInfoBox.drawValueTextRight(ctx, tr, b, rightX + barW - 3, topY + 2, 0.6f);
        }
        if (bars.size() >= 3) {
            b = bars.get(2);
            int y2 = topY + 8 + 6 + 2;
            PartyMemberInfoBox.drawBarSmart(ctx, leftX, y2, barW, 8, b);
            PartyMemberInfoBox.drawScaledText(ctx, tr, b.label, leftX, y2 - 7, -1, 0.6f);
            PartyMemberInfoBox.drawValueTextLeft(ctx, tr, b, leftX + 3, y2 + 2, 0.6f);
        }
        int barsBottom = topY + 8;
        int modelTop = barsBottom + 2;
        int modelBottom = y + h - 4;
        int availH = Math.max(0, modelBottom - modelTop);
        this.infoBtnH = 0;
        this.infoBtnW = 0;
        if (availH > 0) {
            int modelX = x + w / 2;
            int modelSize = Math.max(10, Math.min(16, availH));
            class_1657 pe = PartyMemberInfoBox.getRenderablePlayer(m.uuid, m.name);
            if (pe != null) {
                ctx.method_51448().method_22903();
                ctx.method_51448().method_46416(0.0f, 0.0f, 400.0f);
                RenderSystem.enableDepthTest();
                RenderSystem.disableCull();
                Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
                Quaternionf rotation = new Quaternionf().rotationZ((float)Math.PI);
                Quaternionf bodyRot = new Quaternionf();
                class_490.method_48472((class_332)ctx, (float)modelX, (float)modelBottom, (float)modelSize, (Vector3f)translation, (Quaternionf)rotation, (Quaternionf)bodyRot, (class_1309)pe);
                RenderSystem.enableCull();
                RenderSystem.disableDepthTest();
                ctx.method_51448().method_22909();
            }
            if (FabricLoader.getInstance().isModLoaded("showmeyourbuild")) {
                int idealX = modelX + modelSize / 2 + 4;
                int btnX = Math.min(x + w - 4 - 16, idealX);
                int btnY = modelBottom - modelSize + (modelSize - 16) / 2;
                btnY = Math.max(y + 4, Math.min(y + h - 4 - 16, btnY));
                boolean hover = PartyMemberInfoBox.isMouseOverRect(btnX, btnY, 16, 16);
                float angle = 0.0f;
                if (hover) {
                    double t = (double)(System.currentTimeMillis() % 800L) / 800.0;
                    angle = (float)(Math.sin(t * Math.PI * 2.0) * 12.0);
                }
                class_4587 ma = ctx.method_51448();
                ma.method_22903();
                ma.method_46416((float)btnX + 8.0f, (float)btnY + 8.0f, 0.0f);
                if (angle != 0.0f) {
                    ma.method_22907(class_7833.field_40718.rotationDegrees(angle));
                }
                ctx.method_25290(INFO_BUTTON, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
                ma.method_22909();
                this.infoBtnX = btnX;
                this.infoBtnY = btnY;
                this.infoBtnW = 16;
                this.infoBtnH = 16;
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (this.infoBtnW > 0 && mouseX >= (double)this.infoBtnX && mouseX < (double)(this.infoBtnX + this.infoBtnW) && mouseY >= (double)this.infoBtnY && mouseY < (double)(this.infoBtnY + this.infoBtnH)) {
            ClientPartyHudData.Member member = ClientPartyHudData.getSelectedOrDefault();
            if (member != null && member.name != null && !member.name.isBlank()) {
                ClientPlayNetworking.send((class_8710)new ShowBuildCompatPayloads.OpenBuildRequest(member.name));
            } else {
                class_310 mc = class_310.method_1551();
                if (mc != null && mc.field_1724 != null) {
                    mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)"No member selected."), false);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isMouseOverRect(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        double mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private static void drawBarFlat(class_332 ctx, int x, int y, int w, int h, float pct, int fillARGB) {
        ctx.method_25294(x, y, x + w, y + h, -14671840);
        int iw = Math.max(0, Math.min(w - 2, Math.round((float)(w - 2) * Math.max(0.0f, Math.min(1.0f, pct)))));
        ctx.method_25294(x + 1, y + 1, x + 1 + iw, y + h - 1, fillARGB);
    }

    private static void drawTexturedWhole(class_332 ctx, class_2960 tex, int x, int y, int w, int h) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        ctx.method_25290(tex, 0, 0, 0.0f, 0.0f, 108, 8, 108, 8);
        m.method_22909();
    }

    private static void drawTexturedSegment(class_332 ctx, class_2960 tex, int x, int y, int w, int h, float startPct, float endPct) {
        float s = Math.max(0.0f, Math.min(1.0f, startPct));
        float e = Math.max(0.0f, Math.min(1.0f, endPct));
        if (e <= s) {
            return;
        }
        int srcU = Math.round(108.0f * s);
        int srcW = Math.max(0, Math.round(108.0f * (e - s)));
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        ctx.method_25290(tex, srcU, 0, (float)srcU, 0.0f, srcW, 8, 108, 8);
        m.method_22909();
    }

    private static void drawBarSmart(class_332 ctx, int x, int y, int w, int h, Bar b) {
        switch (b.kind.ordinal()) {
            case 0: {
                float hp = PartyMemberInfoBox.clamp01(b.primaryPct);
                float abs = PartyMemberInfoBox.clamp01(b.extraPct);
                PartyMemberInfoBox.drawTexturedSegment(ctx, TEX_HP_FILL, x, y, w, h, 0.0f, hp);
                if (abs > 0.0f) {
                    PartyMemberInfoBox.drawTexturedSegmentWithAlpha(ctx, TEX_ABSORB_FILL, x, y, w, h, 0.0f, abs, 0.75f);
                }
                PartyMemberInfoBox.drawTexturedWhole(ctx, TEX_BAR_OUTLINE, x, y, w, h);
                break;
            }
            case 3: 
            case 4: {
                PartyMemberInfoBox.drawTexturedSegment(ctx, TEX_MANA_FILL, x, y, w, h, 0.0f, PartyMemberInfoBox.clamp01(b.primaryPct));
                PartyMemberInfoBox.drawTexturedWhole(ctx, TEX_BAR_OUTLINE, x, y, w, h);
                break;
            }
            case 1: {
                PartyMemberInfoBox.drawTexturedSegment(ctx, TEX_HUNGER_FILL, x, y, w, h, 0.0f, PartyMemberInfoBox.clamp01(b.primaryPct));
                PartyMemberInfoBox.drawTexturedWhole(ctx, TEX_BAR_OUTLINE, x, y, w, h);
                break;
            }
            case 2: {
                PartyMemberInfoBox.drawBarFlat(ctx, x, y, w, h, PartyMemberInfoBox.clamp01(b.primaryPct), b.color);
            }
        }
    }

    private static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static void drawRightScaledText(class_332 ctx, class_327 tr, String text, int rightX, int y, int color, float scale) {
        int w = Math.round((float)tr.method_1727(text) * scale);
        PartyMemberInfoBox.drawScaledText(ctx, tr, text, rightX - w, y, color, scale);
    }

    private static class_1657 getRenderablePlayer(UUID uuid, String fallbackName) {
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        if (world == null) {
            return null;
        }
        class_1657 live = world.method_18470(uuid);
        if (live != null) {
            return live;
        }
        class_745 cached = DUMMIES.get(uuid);
        if (cached != null && cached.field_17892 == world) {
            return cached;
        }
        class_634 nh = mc.method_1562();
        GameProfile profile = null;
        if (nh != null && nh.method_2871(uuid) != null) {
            profile = nh.method_2871(uuid).method_2966();
        }
        if (profile == null) {
            profile = new GameProfile(uuid, fallbackName != null ? fallbackName : uuid.toString());
        }
        class_745 dummy = new class_745(world, profile);
        dummy.field_6283 = 180.0f;
        DUMMIES.put(uuid, dummy);
        return dummy;
    }

    public static int getPreferredHeight() {
        return 41;
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y + 1, x + 1, y + h - 1, argb);
        ctx.method_25294(x + w - 1, y + 1, x + w, y + h - 1, argb);
    }

    private static List<Bar> collectBars() {
        float max;
        float now;
        PartyMemberInfoClientConfig cfg = PartyMemberInfoClientConfig.get();
        boolean staminaAvail = FabricLoader.getInstance().isModLoaded("staminaattributes");
        boolean manaAvail = FabricLoader.getInstance().isModLoaded("manaattributes");
        boolean rpgmanaAvail = FabricLoader.getInstance().isModLoaded("rpgmana");
        ClientPartyHudData.Member m = ClientPartyHudData.getSelectedOrDefault();
        if (m == null) {
            return List.of();
        }
        List<Bar> out = new ArrayList<Bar>();
        if (cfg.showHpBar) {
            float hpPct = m.maxHealth > 0.0f ? PartyMemberInfoBox.clamp01(m.health / m.maxHealth) : 0.0f;
            float absPct = m.maxHealth > 0.0f ? PartyMemberInfoBox.clamp01(m.absorption / m.maxHealth) : 0.0f;
            int nowNum = Math.round(m.health + m.absorption);
            int maxNum = Math.round(m.maxHealth);
            String txt = m.maxHealth > 0.0f ? nowNum + "/" + maxNum : "??";
            out.add(new Bar("HP", txt, hpPct, absPct, -13710223, Kind.HP));
        }
        if (cfg.showHungerBar) {
            float pct = PartyMemberInfoBox.clamp01((float)m.hunger / 20.0f);
            String txt = m.hunger >= 0 ? m.hunger + "/20" : "??";
            out.add(new Bar("Hunger", txt, pct, 0.0f, -812014, Kind.HUNGER));
        }
        if (cfg.showStaminaBar && staminaAvail) {
            now = -1.0f;
            max = -1.0f;
            if (m.staminaMax > 0.0f) {
                now = m.staminaNow;
                max = m.staminaMax;
            } else {
                Gauge v = PartyMemberInfoBox.queryTracked(m.uuid, true);
                now = v.now;
                max = v.max;
            }
            float pct = max > 0.0f ? PartyMemberInfoBox.clamp01(now / max) : 0.0f;
            String txt = now >= 0.0f && max > 0.0f ? (int)now + "/" + (int)max : "??";
            out.add(new Bar("Stamina", txt, pct, 0.0f, -812014, Kind.STAMINA));
        }
        if (cfg.showManaBar && manaAvail) {
            now = -1.0f;
            max = -1.0f;
            if (m.manaMax > 0.0f) {
                now = m.manaNow;
                max = m.manaMax;
            } else {
                Gauge v = PartyMemberInfoBox.queryTracked(m.uuid, false);
                now = v.now;
                max = v.max;
            }
            float pct = max > 0.0f ? PartyMemberInfoBox.clamp01(now / max) : 0.0f;
            String txt = max > 0.0f ? (int)now + "/" + (int)max : "??";
            out.add(new Bar("Mana", txt, pct, 0.0f, -13330213, Kind.MANA));
        }
        if (cfg.showRpgManaBar && rpgmanaAvail) {
            now = -1.0f;
            max = -1.0f;
            if (m.rpgManaMax > 0.0f) {
                now = m.rpgManaNow;
                max = m.rpgManaMax;
            } else {
                Gauge v = PartyMemberInfoBox.queryRpgMana(m.uuid);
                now = v.now;
                max = v.max;
            }
            float pct = max > 0.0f ? PartyMemberInfoBox.clamp01(now / max) : 0.0f;
            String txt = max > 0.0f ? (int)now + "/" + (int)max : "??";
            out.add(new Bar("Mana", txt, pct, 0.0f, -13330213, Kind.RPGMANA));
        }
        if (out.size() > 3) {
            out = out.subList(0, 3);
        }
        return out;
    }

    private static Gauge queryTracked(UUID uuid, boolean stamina) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return new Gauge(-1.0f, -1.0f);
        }
        if (stamina && !FabricLoader.getInstance().isModLoaded("staminaattributes")) {
            return new Gauge(-1.0f, -1.0f);
        }
        if (!stamina && !FabricLoader.getInstance().isModLoaded("manaattributes")) {
            return new Gauge(-1.0f, -1.0f);
        }
        class_1657 e = mc.field_1687.method_18470(uuid);
        if (e == null) {
            return new Gauge(-1.0f, -1.0f);
        }
        if (stamina) {
            float[] pair = TrbAttributesCompat.readStamina(e);
            return new Gauge(pair[0], pair[1]);
        }
        float[] pair = TrbAttributesCompat.readMana(e);
        return new Gauge(pair[0], pair[1]);
    }

    private static void drawTexturedSegmentWithAlpha(class_332 ctx, class_2960 tex, int x, int y, int w, int h, float startPct, float endPct, float alpha) {
        float s = Math.max(0.0f, Math.min(1.0f, startPct));
        float e = Math.max(0.0f, Math.min(1.0f, endPct));
        if (e <= s) {
            return;
        }
        int srcU = Math.round(108.0f * s);
        int srcW = Math.max(0, Math.round(108.0f * (e - s)));
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(0.0f, Math.min(1.0f, alpha)));
        ctx.method_25290(tex, srcU, 0, (float)srcU, 0.0f, srcW, 8, 108, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        m.method_22909();
    }

    private static Gauge queryRpgMana(UUID uuid) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return new Gauge(-1.0f, -1.0f);
        }
        if (!FabricLoader.getInstance().isModLoaded("rpgmana")) {
            return new Gauge(-1.0f, -1.0f);
        }
        class_1657 e = mc.field_1687.method_18470(uuid);
        if (e == null) {
            return new Gauge(-1.0f, -1.0f);
        }
        float[] pair = RpgManaCompat.readMana(e);
        return new Gauge(pair[0], pair[1]);
    }

    private record Bar(String label, String valueText, float primaryPct, float extraPct, int color, Kind kind) {
    }

    private static enum Kind {
        HP,
        HUNGER,
        STAMINA,
        MANA,
        RPGMANA;

    }

    private record Gauge(float now, float max) {
    }
}

