/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class TitlesClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "titles_client.json";
    private static TitlesClientConfig INSTANCE;
    public boolean showOwnTitle = true;
    public boolean showOthersTitles = true;

    public static TitlesClientConfig get() {
        if (INSTANCE == null) {
            INSTANCE = TitlesClientConfig.load();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TitlesClientConfig load() {
        block9: {
            Path p = TitlesClientConfig.path();
            try {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (!Files.exists(p, new LinkOption[0])) break block9;
                try (BufferedReader r222 = Files.newBufferedReader(p);){
                    TitlesClientConfig cfg = (TitlesClientConfig)GSON.fromJson((Reader)r222, TitlesClientConfig.class);
                    if (cfg != null) {
                        TitlesClientConfig titlesClientConfig = cfg;
                        return titlesClientConfig;
                    }
                }
            }
            catch (Throwable r222) {
                // empty catch block
            }
        }
        TitlesClientConfig fresh = new TitlesClientConfig();
        fresh.save();
        return fresh;
    }

    public void save() {
        try {
            Files.createDirectories(TitlesClientConfig.path().getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(TitlesClientConfig.path(), new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }
}

