/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.client.title.screen.box.TitleBox;
import net.pixeldreamstudios.rpgsystems.client.title.screen.box.TitleDescriptionBox;
import net.pixeldreamstudios.rpgsystems.client.title.screen.box.TitlesListBox;
import net.pixeldreamstudios.rpgsystems.client.title.widget.TitleButtonWidget;
import net.pixeldreamstudios.rpgsystems.network.title.TitlePayloads;
import net.pixeldreamstudios.rpgsystems.title.PermaGroupKey;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.util.SpellRender;

@Environment(value=EnvType.CLIENT)
public final class TitleScreen
extends class_437 {
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/title_screen.png");
    private static final class_2960 BACK_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/back_normal.png");
    private static final class_2960 BACK_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/back_hover.png");
    private static final class_2960 STATS_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/stats.png");
    private static final class_2960 SPELLS_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/spells.png");
    private static final class_2960 POWERS_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/powers.png");
    private static final class_2960 TOGGLE_ON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/on.png");
    private static final class_2960 TOGGLE_OFF = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/off.png");
    private static final int TOGGLE_W = 16;
    private static final int TOGGLE_H = 7;
    private static final int TOGGLE_PAD = 2;
    private MobSpotP hoveredMob = null;
    private TagSpotP hoveredTag = null;
    private final List<RowHit> currentRowHits = new ArrayList<RowHit>();
    private int x;
    private int y;
    private final int backgroundWidth = 176;
    private final int backgroundHeight = 166;
    private static final int CONTENT_TEXT_PAD_X = 3;
    private TitleButtonWidget backButton;
    private TitleButtonWidget statsButton;
    private TitleButtonWidget spellsButton;
    private TitleButtonWidget powersButton;
    private TitlesListBox titlesListBox;
    private TitleDescriptionBox descriptionBox;
    TitleBox titleBox;
    private PanelType openPanel = PanelType.NONE;
    private Section section = Section.EQUIPPED;
    private final List<MobSpotP> panelMobSpots = new ArrayList<MobSpotP>();
    private final List<TagSpotP> panelTagSpots = new ArrayList<TagSpotP>();
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int tabEquippedX;
    private int tabEquippedY;
    private int tabEquippedW;
    private int tabEquippedH;
    private int tabPermanentX;
    private int tabPermanentY;
    private int tabPermanentW;
    private int tabPermanentH;
    private int contentLeft;
    private int contentTop;
    private int contentRight;
    private int contentBottom;
    private int contentScroll = 0;
    private static final float PANEL_TEXT_SCALE = 0.65f;
    private int toggledLastY = 0;

    public TitleScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.rpgsystems.titles"));
    }

    protected void method_25426() {
        this.x = (this.field_22789 - 176) / 2;
        this.y = (this.field_22790 - 166) / 2;
        int backSize = 8;
        int backX = this.x + 176 - 5 - backSize;
        int backY = this.y + 5;
        this.backButton = new TitleButtonWidget(backX, backY, backSize, backSize, BACK_NORMAL, BACK_HOVER, () -> {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.method_1507((class_437)new class_490((class_1657)client.field_1724));
            } else {
                this.method_25419();
            }
        });
        this.method_37063((class_364)this.backButton);
        int iconSize = 8;
        int gap = 3;
        int tlX = this.x + 5 + 2;
        int tlY = this.y + 5;
        this.statsButton = new TitleButtonWidget(tlX, tlY, iconSize, iconSize, STATS_ICON, STATS_ICON, () -> this.togglePanel(PanelType.STATS));
        this.method_37063((class_364)this.statsButton);
        this.spellsButton = new TitleButtonWidget(tlX + iconSize + gap, tlY, iconSize, iconSize, SPELLS_ICON, SPELLS_ICON, () -> this.togglePanel(PanelType.SPELLS));
        this.method_37063((class_364)this.spellsButton);
        this.powersButton = new TitleButtonWidget(tlX + (iconSize + gap) * 2, tlY, iconSize, iconSize, POWERS_ICON, POWERS_ICON, () -> this.togglePanel(PanelType.POWERS));
        this.method_37063((class_364)this.powersButton);
        this.titlesListBox = new TitlesListBox(this.x, this.y, 176, 166);
        this.descriptionBox = new TitleDescriptionBox(this.x, this.y, 176, 166);
        this.titleBox = new TitleBox(this.x, this.y, 176, 166);
        this.titleBox.attachToScreen(this);
        this.titlesListBox.setSelectionListener(title -> this.descriptionBox.setTitle((Title)title));
        this.titlesListBox.setOnSelectionChanged(title -> this.titleBox.setSelectedTitle((Title)title));
        class_2960 equippedId = TitleClientData.getSelfActive();
        if (equippedId != null && TitleRegistry.get(equippedId) != null) {
            this.titlesListBox.selectById(equippedId);
        } else {
            this.titlesListBox.selectFirstVisible();
        }
        this.layoutPanel();
    }

    private int toggleX() {
        return this.contentRight - 2 - 16;
    }

    private Set<String> disabledSet() {
        return TitleClientData.getPermaDisabled();
    }

    private boolean isDisabled(String key) {
        return this.disabledSet().contains(key);
    }

    private void toggleKey(String key) {
        LinkedHashSet<String> newSet = new LinkedHashSet<String>(this.disabledSet());
        if (!newSet.add(key)) {
            newSet.remove(key);
        }
        TitleClientData.setPermaDisabled(newSet);
        this.sendPermaDisabledToServer(newSet);
    }

    private int drawToggle(class_332 ctx, int rowY, int rowH, boolean enabled) {
        float scale = 0.75f;
        int x = this.toggleX();
        int y = rowY + Math.max(0, (rowH - 7) / 2);
        int boxCx = x + 8;
        int boxCy = y + 3;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)boxCx, (float)boxCy, 0.0f);
        ctx.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        ctx.method_51448().method_46416(-8.0f, -3.5f, 0.0f);
        ctx.method_25290(enabled ? TOGGLE_ON : TOGGLE_OFF, 0, 0, 0.0f, 0.0f, 16, 7, 16, 7);
        ctx.method_51448().method_22909();
        return x;
    }

    private void togglePanel(PanelType type) {
        if (this.openPanel == type) {
            this.openPanel = PanelType.NONE;
            this.contentScroll = 0;
        } else {
            this.openPanel = type;
            this.section = Section.EQUIPPED;
            this.contentScroll = 0;
        }
        this.layoutPanel();
    }

    private void layoutPanel() {
        int startX;
        this.panelW = 150;
        this.panelH = 96;
        this.panelX = this.x + 5;
        this.panelY = this.y + 24 - 3;
        int tabsTop = this.panelY + 16;
        int tabH = 12;
        int tabGap = 6;
        class_327 tr = this.field_22793;
        int eqWText = tr.method_27525((class_5348)class_2561.method_43470((String)"Equipped"));
        int pmWText = tr.method_27525((class_5348)class_2561.method_43470((String)"Permanent"));
        int padX = 6;
        int eqW = Math.max(40, eqWText + padX * 2);
        int pmW = Math.max(56, pmWText + padX * 2);
        int tabW = Math.max(eqW, pmW);
        int total = tabW + tabGap + tabW;
        this.tabEquippedX = startX = this.panelX + (this.panelW - total) / 2;
        this.tabEquippedY = tabsTop;
        this.tabEquippedW = tabW;
        this.tabEquippedH = tabH;
        this.tabPermanentX = startX + tabW + tabGap;
        this.tabPermanentY = tabsTop;
        this.tabPermanentW = tabW;
        this.tabPermanentH = tabH;
        int left = this.panelX;
        int top = this.panelY;
        int right = this.panelX + this.panelW;
        int bottom = this.panelY + this.panelH;
        this.contentLeft = left + 6;
        this.contentTop = top + 16 + 12 + 6;
        this.contentRight = right - 6;
        this.contentBottom = bottom - 6;
    }

    private int measureLinesHeight(List<class_2561> lines, int l, int r, float scale) {
        class_327 font = this.field_22793;
        int wrapWidth = Math.max(1, Math.round((float)(r - l) / scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        int h = 0;
        for (class_2561 line : lines) {
            List wrapped = font.method_1728((class_5348)line, wrapWidth);
            h += wrapped.size() * lineH;
        }
        return h + Math.max(1, Math.round(2.0f * scale));
    }

    private int measureSpellsHeight(int count, float scale) {
        class_327 font = this.field_22793;
        int icon = Math.max(1, Math.round(12.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(icon, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        return count * lineH + Math.max(1, Math.round(2.0f * scale));
    }

    private int measurePowersHeight(int count, float scale) {
        class_327 font = this.field_22793;
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(6.0f * scale));
        return count * lineH + Math.max(1, Math.round(2.0f * scale));
    }

    private int getCurrentContentHeight() {
        ArrayList<Object> powers;
        if (this.openPanel == PanelType.NONE) {
            return 0;
        }
        if (this.openPanel == PanelType.STATS) {
            List<Object> lines;
            if (this.section == Section.EQUIPPED) {
                Title active = this.getEquippedTitle();
                lines = new ArrayList<class_2561>();
                if (active != null) {
                    lines.addAll(this.formatBonusesAttributes(active.bonuses));
                    lines.addAll(this.formatDamageLines(active.bonuses));
                }
                if (lines.isEmpty()) {
                    lines = List.of(class_2561.method_43470((String)"None"));
                }
            } else {
                Aggregated agg = this.aggregatePermanent();
                lines = new ArrayList();
                lines.addAll(this.formatAggregatedAttributes(agg.attrSums));
                lines.addAll(this.formatAggregatedDamage(agg.dmgSums));
                if (lines.isEmpty()) {
                    lines = List.of(class_2561.method_43470((String)"None"));
                }
            }
            return this.measureLinesHeight(lines, this.contentLeft + 3, this.contentRight, 0.65f);
        }
        if (this.openPanel == PanelType.SPELLS) {
            ArrayList<Object> spells;
            if (this.section == Section.EQUIPPED) {
                Title active = this.getEquippedTitle();
                spells = new ArrayList();
                if (active != null) {
                    for (Title.Bonus bns : active.bonuses) {
                        if (bns == null || bns.spellId == null || !bns.spellId.isPresent()) continue;
                        spells.add(bns.spellId.get());
                    }
                }
            } else {
                spells = new ArrayList<class_2960>(this.aggregatePermanent().spells);
            }
            if (spells.isEmpty()) {
                return this.measureLinesHeight(List.of(class_2561.method_43470((String)"None")), this.contentLeft + 3, this.contentRight, 0.65f);
            }
            return this.measureSpellsHeight(spells.size(), 0.65f);
        }
        if (this.section == Section.EQUIPPED) {
            Title active = this.getEquippedTitle();
            powers = new ArrayList();
            if (active != null) {
                for (Title.Bonus bns : active.bonuses) {
                    if (bns == null || bns.powerId == null || !bns.powerId.isPresent()) continue;
                    powers.add(bns.powerId.get());
                }
            }
        } else {
            powers = new ArrayList<class_2960>(this.aggregatePermanent().powers);
        }
        if (powers.isEmpty()) {
            return this.measureLinesHeight(List.of(class_2561.method_43470((String)"None")), this.contentLeft + 3, this.contentRight, 0.65f);
        }
        return this.measurePowersHeight(powers.size(), 0.65f);
    }

    private void clampScroll() {
        int viewH = this.contentBottom - this.contentTop;
        int contentH = this.getCurrentContentHeight();
        int maxScroll = Math.max(0, contentH - viewH);
        if (this.contentScroll < 0) {
            this.contentScroll = 0;
        }
        if (this.contentScroll > maxScroll) {
            this.contentScroll = maxScroll;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.titlesListBox.setScreenOrigin(this.x, this.y);
        this.titlesListBox.setBackgroundSize(176, 166);
        this.titlesListBox.render(context, mouseX, mouseY, delta);
        this.descriptionBox.setScreenOrigin(this.x, this.y);
        this.descriptionBox.setBackgroundSize(176, 166);
        this.descriptionBox.render(context, mouseX, mouseY);
        this.titleBox.setScreenOrigin(this.x, this.y);
        this.titleBox.setBackgroundSize(176, 166);
        this.titleBox.render(context);
        int titleX = this.x + 88;
        int titleY = this.y + 7;
        context.method_27534(this.field_22793, this.field_22785, titleX, titleY, 0xFFFFFF);
        if (this.statsButton != null && this.statsButton.method_49606()) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Stats"), mouseX, mouseY);
        } else if (this.spellsButton != null && this.spellsButton.method_49606()) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Spells"), mouseX, mouseY);
        } else if (this.powersButton != null && this.powersButton.method_49606()) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Powers"), mouseX, mouseY);
        }
        if (this.openPanel != PanelType.NONE) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            this.renderPanel(context, mouseX, mouseY, delta);
            context.method_51448().method_22909();
        } else {
            this.descriptionBox.renderHints(context, mouseX, mouseY);
        }
    }

    private void renderPanel(class_332 ctx, int mouseX, int mouseY, float delta) {
        int left = this.panelX;
        int top = this.panelY;
        int right = this.panelX + this.panelW;
        int bottom = this.panelY + this.panelH;
        this.panelMobSpots.clear();
        this.panelTagSpots.clear();
        ctx.method_25294(left, top, right, bottom, -1072689136);
        ctx.method_49601(left, top, this.panelW, this.panelH, -1);
        String title = switch (this.openPanel.ordinal()) {
            case 1 -> "Stats";
            case 2 -> "Spells";
            case 3 -> "Powers";
            default -> "";
        };
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)title), left + this.panelW / 2, top + 4, 0xFFFFFF);
        this.renderTabs(ctx, mouseX, mouseY);
        int contentLeft = left + 6;
        int contentTop = top + 16 + 12 + 6;
        int contentRight = right - 6;
        int contentBottom = bottom - 6;
        ctx.method_25294(contentLeft - 1, contentTop - 1, contentRight + 1, contentBottom + 1, -16777216);
        ctx.method_25294(contentLeft, contentTop, contentRight, contentBottom, -1340795627);
        this.clampScroll();
        ctx.method_44379(contentLeft, contentTop, contentRight, contentBottom);
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, (float)(-this.contentScroll), 0.0f);
        this.currentRowHits.clear();
        switch (this.openPanel.ordinal()) {
            case 1: {
                this.renderStatsContent(ctx, contentLeft, contentTop, contentRight, contentBottom);
                break;
            }
            case 2: {
                this.renderSpellsContent(ctx, contentLeft, contentTop, contentRight, contentBottom);
                break;
            }
            case 3: {
                this.renderPowersContent(ctx, contentLeft, contentTop, contentRight, contentBottom);
                break;
            }
        }
        ctx.method_51448().method_22909();
        ctx.method_44380();
        if (this.isWithin(mouseX, mouseY, contentLeft, contentTop, contentRight - contentLeft, contentBottom - contentTop)) {
            for (MobSpotP mobSpotP : this.panelMobSpots) {
                if (!mobSpotP.hit(mouseX, mouseY)) continue;
                ctx.method_51448().method_22903();
                ctx.method_51448().method_46416(0.0f, 0.0f, 2000.0f);
                TitleDescriptionBox.renderMobTooltip(ctx, mouseX, mouseY, mobSpotP.id, mobSpotP.name);
                ctx.method_51448().method_22909();
                return;
            }
            for (TagSpotP tagSpotP : this.panelTagSpots) {
                if (!tagSpotP.hit(mouseX, mouseY)) continue;
                ctx.method_51448().method_22903();
                ctx.method_51448().method_46416(0.0f, 0.0f, 2000.0f);
                TitleDescriptionBox.renderTagTooltip(ctx, mouseX, mouseY, tagSpotP.tagId);
                ctx.method_51448().method_22909();
                return;
            }
        }
    }

    private void renderTabs(class_332 ctx, int mouseX, int mouseY) {
        boolean eqSelected = this.section == Section.EQUIPPED;
        int eqBg = eqSelected ? -14013910 : -15066598;
        int pmBg = !eqSelected ? -14013910 : -15066598;
        ctx.method_25294(this.tabEquippedX, this.tabEquippedY, this.tabEquippedX + this.tabEquippedW, this.tabEquippedY + this.tabEquippedH, eqBg);
        ctx.method_49601(this.tabEquippedX, this.tabEquippedY, this.tabEquippedW, this.tabEquippedH, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Equipped"), this.tabEquippedX + this.tabEquippedW / 2, this.tabEquippedY + 2, 0xFFFFFF);
        ctx.method_25294(this.tabPermanentX, this.tabPermanentY, this.tabPermanentX + this.tabPermanentW, this.tabPermanentY + this.tabPermanentH, pmBg);
        ctx.method_49601(this.tabPermanentX, this.tabPermanentY, this.tabPermanentW, this.tabPermanentH, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Permanent"), this.tabPermanentX + this.tabPermanentW / 2, this.tabPermanentY + 2, 0xFFFFFF);
    }

    private void renderStatsContent(class_332 ctx, int l, int t, int r, int b) {
        if (this.section == Section.EQUIPPED) {
            ArrayList<class_2561> lines = new ArrayList<class_2561>();
            Title active = this.getEquippedTitle();
            if (active != null) {
                lines.addAll(this.formatBonusesAttributes(active.bonuses));
                lines.addAll(this.formatDamageLines(active.bonuses));
            }
            if (lines.isEmpty()) {
                lines.add((class_2561)class_2561.method_43470((String)"None"));
            }
            this.drawLinesScrollable(ctx, l + 3, t, lines, 0.65f);
            return;
        }
        Aggregated agg = this.aggregatePermanent();
        this.drawAggregatedAttributesWithToggles(ctx, l, t, agg.attrSums, 0.65f);
        int yAfterAttrs = this.toggledLastY;
        this.drawAggregatedDamageWithTogglesAndSpots(ctx, l, yAfterAttrs, agg.dmgSums, 0.65f);
        if (agg.attrSums.isEmpty() && agg.dmgSums.isEmpty()) {
            this.drawLinesScrollable(ctx, l + 3, t, List.of(class_2561.method_43470((String)"None")), 0.65f);
        }
    }

    private void renderSpellsContent(class_332 ctx, int l, int t, int r, int b) {
        if (this.section == Section.EQUIPPED) {
            ArrayList<class_2561> lines = new ArrayList<class_2561>();
            Title active = this.getEquippedTitle();
            if (active != null) {
                lines.addAll(this.formatBonusesAttributes(active.bonuses));
            }
            if (!lines.isEmpty()) {
                this.drawLinesScrollable(ctx, l + 3, t, lines, 0.65f);
                int usedH = this.measureLinesHeight(lines, l + 3, this.contentRight, 0.65f);
                this.drawDamageRowsScrollable(ctx, l, t + usedH, active != null ? active.bonuses : List.of(), 0.65f);
            } else if (active != null) {
                this.drawDamageRowsScrollable(ctx, l, t, active.bonuses, 0.65f);
            } else {
                this.drawLinesScrollable(ctx, l + 3, t, List.of(class_2561.method_43470((String)"None")), 0.65f);
            }
            return;
        }
        Aggregated agg = this.aggregatePermanent();
        ArrayList<class_2960> spells = new ArrayList<class_2960>(agg.spells);
        if (spells.isEmpty()) {
            this.drawLinesScrollable(ctx, l + 3, t, List.of(class_2561.method_43470((String)"None")), 0.65f);
            return;
        }
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(1.3f));
        int icon = Math.max(1, Math.round(7.7999997f));
        int gap = Math.max(1, Math.round(2.6f));
        Objects.requireNonNull(font);
        int lineH = Math.max(icon, Math.round(9.0f * 0.65f)) + Math.max(1, Math.round(1.3f));
        for (class_2960 sid : spells) {
            class_2960 tex = SpellRender.iconTexture((class_2960)sid);
            class_2561 name = this.resolveSpellName(sid);
            int iconY = y + (lineH - icon) / 2;
            ctx.method_25290(tex, l, iconY, 0.0f, 0.0f, icon, icon, icon, icon);
            class_5481 class_54812 = name.method_30937();
            Objects.requireNonNull(font);
            this.drawScaled(ctx, class_54812, l + icon + gap + 3, iconY + (icon - Math.round(9.0f * 0.65f)) / 2, 0xFFFFFF, 0.65f);
            String key = PermaGroupKey.spell(sid);
            this.drawToggle(ctx, y, lineH, !this.isDisabled(key));
            this.currentRowHits.add(new RowHit(y - this.contentScroll, lineH, key));
            y += lineH;
        }
    }

    private void renderPowersContent(class_332 ctx, int l, int t, int r, int b) {
        if (this.section == Section.EQUIPPED) {
            ArrayList<class_2960> powers = new ArrayList<class_2960>();
            Title active = this.getEquippedTitle();
            if (active != null) {
                for (Title.Bonus bns : active.bonuses) {
                    if (bns == null || bns.powerId == null || !bns.powerId.isPresent()) continue;
                    powers.add(bns.powerId.get());
                }
            }
            if (powers.isEmpty()) {
                this.drawLinesScrollable(ctx, l + 3, t, List.of(class_2561.method_43470((String)"None")), 0.65f);
            } else {
                this.drawPowerRowsScrollable(ctx, l, t, powers, 0.65f);
            }
            return;
        }
        Aggregated agg = this.aggregatePermanent();
        ArrayList<class_2960> powers = new ArrayList<class_2960>(agg.powers);
        if (powers.isEmpty()) {
            this.drawLinesScrollable(ctx, l + 3, t, List.of(class_2561.method_43470((String)"None")), 0.65f);
            return;
        }
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(1.3f));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * 0.65f)) + Math.max(1, Math.round(3.8999999f));
        for (class_2960 pid : powers) {
            class_5250 line = class_2561.method_43470((String)("\u2022 " + TitleScreen.toTitleCase(pid.method_12832())));
            this.drawScaled(ctx, line.method_30937(), l + 3, y, 0xFFFFFF, 0.65f);
            String key = PermaGroupKey.power(pid);
            this.drawToggle(ctx, y, lineH, !this.isDisabled(key));
            this.currentRowHits.add(new RowHit(y - this.contentScroll, lineH, key));
            y += lineH;
        }
    }

    private void drawAggregatedAttributesWithToggles(class_332 ctx, int l, int t, Map<AttrKey, Double> sums, float scale) {
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(2.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        ArrayList<Map.Entry<AttrKey, Double>> entries = new ArrayList<Map.Entry<AttrKey, Double>>(sums.entrySet());
        entries.sort(Comparator.comparing(e -> ((AttrKey)e.getKey()).attrId.toString()));
        boolean ilt = this.iltPresent();
        for (Map.Entry entry : entries) {
            class_5250 rowText;
            String raw;
            int[] span;
            String sign;
            AttrKey k = (AttrKey)entry.getKey();
            double amt = (Double)entry.getValue();
            class_1320 attr = (class_1320)class_7923.field_41190.method_10223(k.attrId);
            class_5250 attrName = class_2561.method_43471((String)attr.method_26830());
            String string = sign = amt >= 0.0 ? "+" : "";
            if (ilt && (span = IconLeadingUtil.firstIconSpan((String)(raw = attrName.getString())))[0] >= 0) {
                String icon = raw.substring(span[0], span[1]);
                String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
                String rest = IconLeadingUtil.stripSectionCodes((String)restRaw).replaceFirst("^\\s+", "");
                class_5250 iconText = class_2561.method_43470((String)(icon + " "));
                class_5250 restText = class_2561.method_43470((String)rest);
                rowText = k.op == class_1322.class_1323.field_6328 ? class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt) + " "))).method_10852((class_2561)restText) : (k.op == class_1322.class_1323.field_6330 ? class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (base)")) : class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
                String key = PermaGroupKey.attr(k.attrId, k.op);
                this.drawScaled(ctx, rowText.method_30937(), l + 3, y, 0xFFFFFF, scale);
                this.drawToggle(ctx, y, lineH, !this.isDisabled(key));
                this.currentRowHits.add(new RowHit(y - this.contentScroll, lineH, key));
                y += lineH;
                continue;
            }
            rowText = k.op == class_1322.class_1323.field_6328 ? class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt) + " "))).method_10852((class_2561)attrName) : (k.op == class_1322.class_1323.field_6330 ? class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (base)")) : class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
            String key = PermaGroupKey.attr(k.attrId, k.op);
            this.drawScaled(ctx, rowText.method_30937(), l + 3, y, 0xFFFFFF, scale);
            this.drawToggle(ctx, y, lineH, !this.isDisabled(key));
            this.currentRowHits.add(new RowHit(y - this.contentScroll, lineH, key));
            y += lineH;
        }
        this.toggledLastY = y;
    }

    private void drawDamageRowsScrollable(class_332 ctx, int l, int t, List<Title.Bonus> bonuses, float scale) {
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(2.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        for (Title.Bonus b : bonuses) {
            if (b == null || (b.damageTarget == null || b.damageTarget.isEmpty()) && (b.damageTag == null || b.damageTag.isEmpty())) continue;
            String value = b.damageOp == Title.DamageOp.ADDED ? (b.damageAmount >= 0.0 ? "+" : "") + TitleScreen.trim(b.damageAmount) : (b.damageAmount * 100.0 >= 0.0 ? "+" : "") + TitleScreen.trim(b.damageAmount * 100.0) + "%";
            class_5250 pre = class_2561.method_43470((String)("\u2022 " + value + " DMG vs "));
            int x = l + 3;
            class_5481 preOT = pre.method_30937();
            this.drawScaled(ctx, preOT, x, y, 0xFFFFFF, scale);
            x += Math.round((float)font.method_30880(preOT) * scale);
            if (b.damageTarget != null && b.damageTarget.isPresent()) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(b.damageTarget.get());
                class_5250 mobName = class_2561.method_43471((String)type.method_5882());
                class_5481 mobOT = mobName.method_30937();
                int w = Math.round((float)font.method_30880(mobOT) * scale);
                this.drawScaled(ctx, mobOT, x, y, 0xFFFFFF, scale);
                Objects.requireNonNull(font);
                this.panelMobSpots.add(new MobSpotP(x, y - this.contentScroll, w, Math.round(9.0f * scale), b.damageTarget.get(), (class_2561)mobName));
                x += w;
            } else if (b.damageTag != null && b.damageTag.isPresent()) {
                class_2960 tagId = b.damageTag.get();
                String pretty = TitleScreen.toTitleCase(tagId.method_12832());
                class_5250 tagText = class_2561.method_43470((String)pretty).method_27694(s -> s.method_30938(Boolean.valueOf(true)));
                class_5481 tagOT = tagText.method_30937();
                int w = Math.round((float)font.method_30880(tagOT) * scale);
                this.drawScaled(ctx, tagOT, x, y, 0xFFFFFF, scale);
                Objects.requireNonNull(font);
                this.panelTagSpots.add(new TagSpotP(x, y - this.contentScroll, w, Math.round(9.0f * scale), tagId));
                x += w;
            }
            y += lineH;
        }
    }

    private void drawAggregatedDamageWithTogglesAndSpots(class_332 ctx, int l, int t, Map<DmgKey, Double> sums, float scale) {
        class_327 font = this.field_22793;
        int y = Math.max(t, this.toggledLastY == 0 ? t : this.toggledLastY);
        y += Math.max(0, Math.round(1.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        ArrayList<Map.Entry<DmgKey, Double>> entries = new ArrayList<Map.Entry<DmgKey, Double>>(sums.entrySet());
        entries.sort(Comparator.comparing(e -> (((DmgKey)e.getKey()).isTag ? "#" : "") + ((DmgKey)e.getKey()).idOrTag.toString()));
        for (Map.Entry entry : entries) {
            DmgKey k = (DmgKey)entry.getKey();
            double amt = (Double)entry.getValue();
            String value = k.op == Title.DamageOp.ADDED ? (amt >= 0.0 ? "+" : "") + TitleScreen.trim(amt) : (amt * 100.0 >= 0.0 ? "+" : "") + TitleScreen.trim(amt * 100.0) + "%";
            class_5250 pre = class_2561.method_43470((String)("\u2022 " + value + " DMG vs "));
            int x = l + 3;
            class_5481 preOT = pre.method_30937();
            this.drawScaled(ctx, preOT, x, y, 0xFFFFFF, scale);
            x += Math.round((float)font.method_30880(preOT) * scale);
            if (!k.isTag) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(k.idOrTag);
                class_5250 mobName = class_2561.method_43471((String)type.method_5882());
                class_5481 mobOT = mobName.method_30937();
                w = Math.round((float)font.method_30880(mobOT) * scale);
                this.drawScaled(ctx, mobOT, x, y, 0xFFFFFF, scale);
                Objects.requireNonNull(font);
                this.panelMobSpots.add(new MobSpotP(x, y - this.contentScroll, w, Math.round(9.0f * scale), k.idOrTag, (class_2561)mobName));
            } else {
                String pretty = TitleScreen.toTitleCase(k.idOrTag.method_12832());
                class_5250 tagText = class_2561.method_43470((String)pretty).method_27694(s -> s.method_30938(Boolean.valueOf(true)));
                class_5481 tagOT = tagText.method_30937();
                w = Math.round((float)font.method_30880(tagOT) * scale);
                this.drawScaled(ctx, tagOT, x, y, 0xFFFFFF, scale);
                Objects.requireNonNull(font);
                this.panelTagSpots.add(new TagSpotP(x, y - this.contentScroll, w, Math.round(9.0f * scale), k.idOrTag));
            }
            String key = k.isTag ? PermaGroupKey.dmgTag(k.idOrTag, k.op) : PermaGroupKey.dmgTarget(k.idOrTag, k.op);
            this.drawToggle(ctx, y, lineH, !this.isDisabled(key));
            this.currentRowHits.add(new RowHit(y - this.contentScroll, lineH, key));
            y += lineH;
        }
        this.toggledLastY = y;
    }

    private Title getEquippedTitle() {
        class_2960 activeId = TitleClientData.getSelfActive();
        return activeId != null ? TitleRegistry.get(activeId) : null;
    }

    private Aggregated aggregatePermanent() {
        Aggregated out = new Aggregated();
        for (class_2960 id : TitleClientData.getSelfUnlocked()) {
            Title tTitle = TitleRegistry.get(id);
            if (tTitle == null) continue;
            for (Title.Bonus b : tTitle.permaBonuses) {
                DmgKey key;
                if (b == null) continue;
                if (b.attribute != null) {
                    class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)b.attribute.comp_349()));
                    if (attrId == null) continue;
                    AttrKey key2 = new AttrKey(attrId, b.operation);
                    out.attrSums.merge(key2, b.amount, Double::sum);
                    continue;
                }
                if (b.damageTarget != null && b.damageTarget.isPresent()) {
                    key = new DmgKey(b.damageTarget.get(), false, b.damageOp);
                    out.dmgSums.merge(key, b.damageAmount, Double::sum);
                    continue;
                }
                if (b.damageTag != null && b.damageTag.isPresent()) {
                    key = new DmgKey(b.damageTag.get(), true, b.damageOp);
                    out.dmgSums.merge(key, b.damageAmount, Double::sum);
                    continue;
                }
                if (b.spellId != null && b.spellId.isPresent()) {
                    out.spells.add(b.spellId.get());
                    continue;
                }
                if (b.powerId == null || !b.powerId.isPresent()) continue;
                out.powers.add(b.powerId.get());
            }
        }
        return out;
    }

    private boolean iltPresent() {
        FabricLoader fl = FabricLoader.getInstance();
        return fl.isModLoaded("iconleadingtooltip") || fl.isModLoaded("icon-leading-tooltip");
    }

    private List<class_2561> formatBonusesAttributes(List<Title.Bonus> bonuses) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        boolean ilt = this.iltPresent();
        for (Title.Bonus b : bonuses) {
            String raw;
            int[] span;
            String sign;
            if (b == null || b.attribute == null) continue;
            String attrKey = ((class_1320)b.attribute.comp_349()).method_26830();
            class_5250 attrName = class_2561.method_43471((String)attrKey);
            String string = sign = b.amount >= 0.0 ? "+" : "";
            if (ilt && (span = IconLeadingUtil.firstIconSpan((String)(raw = attrName.getString())))[0] >= 0) {
                String icon = raw.substring(span[0], span[1]);
                String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
                String rest = IconLeadingUtil.stripSectionCodes((String)restRaw).replaceFirst("^\\s+", "");
                class_5250 iconText = class_2561.method_43470((String)(icon + " "));
                class_5250 restText = class_2561.method_43470((String)rest);
                if (b.operation == class_1322.class_1323.field_6328) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount) + " "))).method_10852((class_2561)restText));
                    continue;
                }
                if (b.operation == class_1322.class_1323.field_6330) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                    continue;
                }
                out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
                continue;
            }
            if (b.operation == class_1322.class_1323.field_6328) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount) + " "))).method_10852((class_2561)attrName));
                continue;
            }
            if (b.operation == class_1322.class_1323.field_6330) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                continue;
            }
            out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
        }
        return out;
    }

    private List<class_2561> formatAggregatedAttributes(Map<AttrKey, Double> sums) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        boolean ilt = this.iltPresent();
        ArrayList<Map.Entry<AttrKey, Double>> entries = new ArrayList<Map.Entry<AttrKey, Double>>(sums.entrySet());
        entries.sort(Comparator.comparing(e -> ((AttrKey)e.getKey()).attrId.toString()));
        for (Map.Entry entry : entries) {
            String raw;
            int[] span;
            String sign;
            AttrKey k = (AttrKey)entry.getKey();
            double amt = (Double)entry.getValue();
            class_1320 attr = (class_1320)class_7923.field_41190.method_10223(k.attrId);
            class_5250 attrName = class_2561.method_43471((String)attr.method_26830());
            String string = sign = amt >= 0.0 ? "+" : "";
            if (ilt && (span = IconLeadingUtil.firstIconSpan((String)(raw = attrName.getString())))[0] >= 0) {
                String icon = raw.substring(span[0], span[1]);
                String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
                String rest = IconLeadingUtil.stripSectionCodes((String)restRaw).replaceFirst("^\\s+", "");
                class_5250 iconText = class_2561.method_43470((String)(icon + " "));
                class_5250 restText = class_2561.method_43470((String)rest);
                if (k.op == class_1322.class_1323.field_6328) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt) + " "))).method_10852((class_2561)restText));
                    continue;
                }
                if (k.op == class_1322.class_1323.field_6330) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                    continue;
                }
                out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
                continue;
            }
            if (k.op == class_1322.class_1323.field_6328) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt) + " "))).method_10852((class_2561)attrName));
                continue;
            }
            if (k.op == class_1322.class_1323.field_6330) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                continue;
            }
            out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleScreen.trim(amt * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
        }
        return out;
    }

    private List<class_2561> formatDamageLines(List<Title.Bonus> bonuses) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        for (Title.Bonus b : bonuses) {
            double v;
            if (b == null || (b.damageTarget == null || !b.damageTarget.isPresent()) && (b.damageTag == null || !b.damageTag.isPresent())) continue;
            String value = b.damageOp == Title.DamageOp.ADDED ? (b.damageAmount >= 0.0 ? "+" : "") + TitleScreen.trim(b.damageAmount) : ((v = b.damageAmount * 100.0) >= 0.0 ? "+" : "") + TitleScreen.trim(v) + "%";
            if (b.damageTarget != null && b.damageTarget.isPresent()) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(b.damageTarget.get());
                class_5250 mobName = class_2561.method_43471((String)type.method_5882());
                out.add((class_2561)class_2561.method_43470((String)(value + " DMG vs ")).method_10852((class_2561)mobName));
                continue;
            }
            class_2960 tagId = b.damageTag.get();
            String pretty = TitleScreen.toTitleCase(tagId.method_12832());
            out.add((class_2561)class_2561.method_43470((String)(value + " DMG vs any " + pretty)));
        }
        return out;
    }

    private List<class_2561> formatAggregatedDamage(Map<DmgKey, Double> sums) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        ArrayList<Map.Entry<DmgKey, Double>> entries = new ArrayList<Map.Entry<DmgKey, Double>>(sums.entrySet());
        entries.sort(Comparator.comparing(e -> (((DmgKey)e.getKey()).isTag ? "#" : "") + ((DmgKey)e.getKey()).idOrTag.toString()));
        for (Map.Entry entry : entries) {
            double v;
            DmgKey k = (DmgKey)entry.getKey();
            double amt = (Double)entry.getValue();
            String value = k.op == Title.DamageOp.ADDED ? (amt >= 0.0 ? "+" : "") + TitleScreen.trim(amt) : ((v = amt * 100.0) >= 0.0 ? "+" : "") + TitleScreen.trim(v) + "%";
            if (!k.isTag) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(k.idOrTag);
                class_5250 mobName = class_2561.method_43471((String)type.method_5882());
                out.add((class_2561)class_2561.method_43470((String)(value + " DMG vs ")).method_10852((class_2561)mobName));
                continue;
            }
            String pretty = TitleScreen.toTitleCase(k.idOrTag.method_12832());
            out.add((class_2561)class_2561.method_43470((String)(value + " DMG vs any " + pretty)));
        }
        return out;
    }

    private void drawScaled(class_332 ctx, class_5481 text, int x, int y, int color, float scale) {
        if (scale == 1.0f) {
            ctx.method_35720(this.field_22793, text, x, y, color);
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        int sx = Math.round((float)x / scale);
        int sy = Math.round((float)y / scale);
        ctx.method_35720(this.field_22793, text, sx, sy, color);
        ctx.method_51448().method_22909();
    }

    private static String trim(double v) {
        String s = String.format(Locale.ROOT, "%.2f", v);
        if (s.indexOf(46) >= 0) {
            s = s.replaceAll("0+$", "").replaceAll("\\.$", "");
        }
        return s;
    }

    private class_2561 resolveSpellName(class_2960 id) {
        class_5250 t;
        String raw;
        class_2378 reg;
        class_6880.class_6883 entry;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1687 != null && (entry = (class_6880.class_6883)(reg = SpellRegistry.from((class_1937)client.field_1687)).method_55841(id).orElse(null)) != null && !(raw = (t = class_2561.method_43471((String)("spell." + id.method_12836() + "." + id.method_12832()))).getString()).equals("spell." + id.method_12836() + "." + id.method_12832())) {
            return t;
        }
        return class_2561.method_43470((String)TitleScreen.toTitleCase(id.method_12832()));
    }

    private static String toTitleCase(String path) {
        String nice = path.replace('_', ' ');
        return Arrays.stream(nice.split(" ")).filter(s -> !s.isEmpty()).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1)).collect(Collectors.joining(" "));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.openPanel != PanelType.NONE) {
            if (this.isWithin(mouseX, mouseY, this.tabEquippedX, this.tabEquippedY, this.tabEquippedW, this.tabEquippedH)) {
                this.section = Section.EQUIPPED;
                this.contentScroll = 0;
                return true;
            }
            if (this.isWithin(mouseX, mouseY, this.tabPermanentX, this.tabPermanentY, this.tabPermanentW, this.tabPermanentH)) {
                this.section = Section.PERMANENT;
                this.contentScroll = 0;
                return true;
            }
        }
        if (this.openPanel != PanelType.NONE && this.section == Section.PERMANENT && this.isWithin(mouseX, mouseY, this.contentLeft, this.contentTop, this.contentRight - this.contentLeft, this.contentBottom - this.contentTop)) {
            int tx = this.toggleX();
            for (RowHit rh : this.currentRowHits) {
                int ry = rh.y();
                int rhH = rh.h();
                if (!(mouseX >= (double)tx) || !(mouseX < (double)(tx + 16)) || !(mouseY >= (double)ry) || !(mouseY < (double)(ry + rhH))) continue;
                this.toggleKey(rh.key());
                return true;
            }
        }
        boolean handledByChildren = false;
        if (this.titlesListBox != null && this.titlesListBox.mouseClicked(mouseX, mouseY, button)) {
            handledByChildren = true;
        } else if (this.descriptionBox != null && this.descriptionBox.mouseClicked(mouseX, mouseY, button)) {
            handledByChildren = true;
        } else if (super.method_25402(mouseX, mouseY, button)) {
            handledByChildren = true;
        }
        if (handledByChildren) {
            return true;
        }
        if (this.openPanel != PanelType.NONE && !this.isWithin(mouseX, mouseY, this.panelX, this.panelY, this.panelW, this.panelH)) {
            this.openPanel = PanelType.NONE;
            this.contentScroll = 0;
            return true;
        }
        return false;
    }

    private void sendPermaDisabledToServer(Set<String> disabled) {
        ClientPlayNetworking.send((class_8710)new TitlePayloads.RequestSetPermaToggles(new ArrayList<String>(disabled)));
    }

    private boolean isWithin(double mx, double my, int rx, int ry, int rw, int rh) {
        return mx >= (double)rx && mx < (double)(rx + rw) && my >= (double)ry && my < (double)(ry + rh);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.openPanel != PanelType.NONE && this.isWithin(mouseX, mouseY, this.contentLeft, this.contentTop, this.contentRight - this.contentLeft, this.contentBottom - this.contentTop)) {
            int step = 12;
            this.contentScroll -= (int)Math.round(verticalAmount * (double)step);
            this.clampScroll();
            return true;
        }
        if (this.titlesListBox != null && this.titlesListBox.mouseScrolled(mouseX, mouseY, verticalAmount)) {
            return true;
        }
        if (this.descriptionBox != null && this.descriptionBox.mouseScrolled(mouseX, mouseY, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.titlesListBox != null && this.titlesListBox.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.descriptionBox != null && this.descriptionBox.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.titlesListBox != null && this.titlesListBox.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.descriptionBox != null && this.descriptionBox.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        context.method_25290(BACKGROUND, this.x, this.y, 0.0f, 0.0f, 176, 166, 176, 166);
    }

    private void drawLinesScrollable(class_332 ctx, int l, int t, List<class_2561> lines, float scale) {
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(2.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        int wrapWidth = Math.max(1, Math.round((float)(this.contentRight - l) / scale));
        for (class_2561 line : lines) {
            List wrapped = font.method_1728((class_5348)line, wrapWidth);
            for (class_5481 ot : wrapped) {
                this.drawScaled(ctx, ot, l, y, 0xFFFFFF, scale);
                y += lineH;
            }
        }
    }

    private void drawSpellRowsScrollable(class_332 ctx, int l, int t, List<class_2960> spells, float scale) {
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(2.0f * scale));
        int icon = Math.max(1, Math.round(12.0f * scale));
        int gap = Math.max(1, Math.round(4.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(icon, Math.round(9.0f * scale)) + Math.max(1, Math.round(2.0f * scale));
        for (class_2960 sid : spells) {
            class_2960 tex = SpellRender.iconTexture((class_2960)sid);
            class_2561 name = this.resolveSpellName(sid);
            int iconY = y + (lineH - icon) / 2;
            ctx.method_25290(tex, l, iconY, 0.0f, 0.0f, icon, icon, icon, icon);
            class_5481 class_54812 = name.method_30937();
            Objects.requireNonNull(font);
            this.drawScaled(ctx, class_54812, l + icon + gap + 3, iconY + (icon - Math.round(9.0f * scale)) / 2, 0xFFFFFF, scale);
            y += lineH;
        }
    }

    private void drawPowerRowsScrollable(class_332 ctx, int l, int t, List<class_2960> powers, float scale) {
        class_327 font = this.field_22793;
        int y = t + Math.max(1, Math.round(2.0f * scale));
        Objects.requireNonNull(font);
        int lineH = Math.max(1, Math.round(9.0f * scale)) + Math.max(1, Math.round(6.0f * scale));
        for (class_2960 pid : powers) {
            class_5250 line = class_2561.method_43470((String)("\u2022 " + TitleScreen.toTitleCase(pid.method_12832())));
            this.drawScaled(ctx, line.method_30937(), l + 3, y, 0xFFFFFF, scale);
            y += lineH;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static final class MobSpotP {
        final int x;
        final int y;
        final int w;
        final int h;
        final class_2960 id;
        final class_2561 name;

        MobSpotP(int x, int y, int w, int h, class_2960 id, class_2561 name) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.id = id;
            this.name = name;
        }

        boolean hit(int mx, int my) {
            return mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h;
        }
    }

    private static final class TagSpotP {
        final int x;
        final int y;
        final int w;
        final int h;
        final class_2960 tagId;

        TagSpotP(int x, int y, int w, int h, class_2960 tagId) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.tagId = tagId;
        }

        boolean hit(int mx, int my) {
            return mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h;
        }
    }

    private static enum PanelType {
        NONE,
        STATS,
        SPELLS,
        POWERS;

    }

    private static enum Section {
        EQUIPPED,
        PERMANENT;

    }

    private static final class Aggregated {
        final Map<AttrKey, Double> attrSums = new LinkedHashMap<AttrKey, Double>();
        final Map<DmgKey, Double> dmgSums = new LinkedHashMap<DmgKey, Double>();
        final Set<class_2960> spells = new LinkedHashSet<class_2960>();
        final Set<class_2960> powers = new LinkedHashSet<class_2960>();

        private Aggregated() {
        }
    }

    private record RowHit(int y, int h, String key) {
    }

    private static final class AttrKey {
        final class_2960 attrId;
        final class_1322.class_1323 op;

        AttrKey(class_2960 id, class_1322.class_1323 op) {
            this.attrId = id;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AttrKey)) {
                return false;
            }
            AttrKey a = (AttrKey)o;
            return Objects.equals(this.attrId, a.attrId) && this.op == a.op;
        }

        public int hashCode() {
            return Objects.hash(this.attrId, this.op);
        }
    }

    private static final class DmgKey {
        final class_2960 idOrTag;
        final boolean isTag;
        final Title.DamageOp op;

        DmgKey(class_2960 idOrTag, boolean isTag, Title.DamageOp op) {
            this.idOrTag = idOrTag;
            this.isTag = isTag;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DmgKey)) {
                return false;
            }
            DmgKey d = (DmgKey)o;
            return this.isTag == d.isTag && this.op == d.op && Objects.equals(this.idOrTag, d.idOrTag);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.idOrTag, this.isTag, this.op});
        }
    }
}

