/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title.screen.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.client.title.TitleStyleUtil;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;

@Environment(value=EnvType.CLIENT)
public final class TitlesListBox {
    private static final int BOX_WIDTH = 59;
    private static final int BOX_HEIGHT = 64;
    private static final int LEFT_PADDING = 7;
    private static final int BOTTOM_PADDING = 12;
    private static final int VISIBLE_ROWS = 4;
    private static final class_2960 LOCKED_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/locked.png");
    private static final int LOCK_SIZE = 8;
    private static final int LOCK_RIGHT_INSET = 4;
    private static final int HIGHLIGHT_COLOR = 0x44FFFFFF;
    private static final int ROW_INNER_PAD_L = 4;
    private static final int ROW_INNER_PAD_R = 6;
    private static final float MARQUEE_SPEED_PX_PER_SEC = 42.0f;
    private static final float MARQUEE_HOLD_SECONDS = 1.5f;
    private int screenX;
    private int screenY;
    private int bgWidth;
    private int bgHeight;
    private final class_327 font;
    private int scrollOffset = 0;
    private int selectedIndex = -1;
    private final List<Consumer<Title>> selectionListeners = new ArrayList<Consumer<Title>>();
    private float textScale = 0.5f;
    private int scrollbarOffsetX = 0;
    private int scrollbarOffsetY = 0;
    private int scrollbarWidth = 1;
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;
    private static final int SCROLLBAR_TRACK_COLOR = 0x33000000;
    private static final int SCROLLBAR_BORDER_COLOR = 0x66000000;
    private static final int SCROLLBAR_THUMB_COLOR = -1711276033;
    private static final int SCROLLBAR_THUMB_HOVER_COLOR = -1140850689;

    public TitlesListBox(int screenX, int screenY, int bgWidth, int bgHeight) {
        this.font = class_310.method_1551().field_1772;
        this.screenX = screenX;
        this.screenY = screenY;
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
    }

    public void setScreenOrigin(int screenX, int screenY) {
        this.screenX = screenX;
        this.screenY = screenY;
    }

    public void setBackgroundSize(int bgWidth, int bgHeight) {
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
    }

    public void setSelectionListener(Consumer<Title> listener) {
        this.selectionListeners.clear();
        this.selectionListeners.add(listener);
    }

    public void setOnSelectionChanged(Consumer<Title> listener) {
        this.selectionListeners.add(listener);
    }

    public void setScrollbarWidth(int width) {
        this.scrollbarWidth = Math.max(2, Math.min(12, width));
    }

    public Title getSelectedTitle() {
        List<Title> all = this.visibleTitles();
        if (this.selectedIndex < 0 || this.selectedIndex >= all.size()) {
            return null;
        }
        return all.get(this.selectedIndex);
    }

    public void selectById(class_2960 id) {
        if (id == null) {
            return;
        }
        List<Title> all = this.visibleTitles();
        for (int i = 0; i < all.size(); ++i) {
            if (!all.get((int)i).id.equals((Object)id)) continue;
            this.selectedIndex = i;
            this.notifySelectionChanged();
            return;
        }
    }

    public void selectFirstVisible() {
        List<Title> all = this.visibleTitles();
        if (!all.isEmpty()) {
            this.selectedIndex = 0;
            this.notifySelectionChanged();
        }
    }

    private void notifySelectionChanged() {
        List<Title> all = this.visibleTitles();
        if (this.selectedIndex >= 0 && this.selectedIndex < all.size()) {
            Title selected = all.get(this.selectedIndex);
            for (Consumer<Title> listener : this.selectionListeners) {
                listener.accept(selected);
            }
        }
    }

    public void render(class_332 ctx, int mouseX, int mouseY, float delta) {
        int index;
        int boxX = this.screenX + 7;
        int boxY = this.screenY + this.bgHeight - 12 - 64;
        List<Title> allTitles = this.visibleTitles();
        int maxOffset = Math.max(0, allTitles.size() - 4);
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        if (this.selectedIndex >= allTitles.size()) {
            this.selectedIndex = -1;
        }
        int innerLeft = boxX + 4;
        int innerRight = boxX + 59 - 6;
        long now = class_156.method_658();
        float rowH = 16.0f;
        for (int row = 0; row < 4 && (index = this.scrollOffset + row) < allTitles.size(); ++row) {
            boolean marquee;
            boolean unlocked;
            Title t = allTitles.get(index);
            String raw = t.displayName != null ? t.displayName.getString() : t.id.toString();
            String clean = TitleStyleUtil.parse(raw).text();
            class_5250 label = class_2561.method_43470((String)clean);
            class_5481 ordered = label.method_30937();
            int partTop = boxY + Math.round(rowH * (float)row);
            int partBottom = row == 3 ? boxY + 64 : boxY + Math.round(rowH * (float)(row + 1));
            Objects.requireNonNull(this.font);
            int textHScaled = Math.max(1, Math.round(9.0f * this.textScale));
            int textY = partTop + Math.max(0, Math.round((float)(partBottom - partTop - textHScaled) / 2.0f));
            if (index == this.selectedIndex) {
                ctx.method_25294(boxX + 1, partTop + 1, boxX + 59 - 1, partBottom - 1, 0x44FFFFFF);
            }
            int lockReserve = (unlocked = TitleClientData.getSelfUnlocked().contains(t.id)) ? 0 : 12;
            int contentLeft = innerLeft;
            int contentRight = innerRight - lockReserve;
            int contentWidth = Math.max(1, contentRight - contentLeft);
            int rowClipTop = partTop + 1;
            int rowClipBottom = partBottom - 1;
            ctx.method_44379(contentLeft, rowClipTop, contentRight, rowClipBottom);
            int fullWidth = this.font.method_30880(ordered);
            int fullWidthScaled = Math.round((float)fullWidth * this.textScale);
            boolean bl = marquee = fullWidthScaled > contentWidth;
            if (!marquee) {
                this.drawScaled(ctx, ordered, contentLeft, textY, -1, this.textScale);
            } else {
                float offsetPx;
                float seconds = (float)(now % 1000000L) / 1000.0f;
                float phaseOffset = (float)row * 0.27f;
                float overflow = Math.max(1.0f, (float)(fullWidthScaled - contentWidth));
                float travelTime = overflow / 42.0f;
                float cycle = 1.5f + travelTime + 1.5f + travelTime;
                float ts = (seconds + phaseOffset) % cycle;
                if (ts < 1.5f) {
                    offsetPx = 0.0f;
                } else if (ts < 1.5f + travelTime) {
                    offsetPx = (ts - 1.5f) * 42.0f;
                } else if (ts < 1.5f + travelTime + 1.5f) {
                    offsetPx = overflow;
                } else {
                    float backT = ts - (1.5f + travelTime + 1.5f);
                    offsetPx = overflow - backT * 42.0f;
                }
                int drawX = contentLeft - Math.round(offsetPx);
                this.drawScaled(ctx, ordered, drawX, textY, -1, this.textScale);
            }
            ctx.method_44380();
            if (unlocked) continue;
            int iconX = boxX + 59 - 4 - 8;
            int iconY = partTop + Math.max(0, Math.round((rowH - 8.0f) / 2.0f));
            ctx.method_25290(LOCKED_ICON, iconX, iconY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
        this.renderScrollbar(ctx, mouseX, mouseY, allTitles);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int[] box = this.boxRect();
        int boxX = box[0];
        int boxY = box[1];
        int boxW = box[2];
        int boxH = box[3];
        if (mouseX < (double)boxX || mouseX > (double)(boxX + boxW) || mouseY < (double)boxY || mouseY > (double)(boxY + boxH)) {
            return false;
        }
        List<Title> all = this.visibleTitles();
        int maxOffset = Math.max(0, all.size() - 4);
        if (amount > 0.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
        } else if (amount < 0.0) {
            this.scrollOffset = Math.min(maxOffset, this.scrollOffset + 1);
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Title> all;
        int[] r = this.boxRect();
        int boxX = r[0];
        int boxY = r[1];
        int boxW = r[2];
        int boxH = r[3];
        if (mouseX < (double)boxX || mouseX > (double)(boxX + boxW) || mouseY < (double)boxY || mouseY > (double)(boxY + boxH)) {
            return false;
        }
        if (button != 0) {
            return true;
        }
        if (this.handleScrollbarClick(mouseX, mouseY)) {
            return true;
        }
        int relY = (int)(mouseY - (double)boxY);
        float rowH = 16.0f;
        int row = Math.min(3, Math.max(0, (int)Math.floor((float)relY / rowH)));
        int index = this.scrollOffset + row;
        if (index < (all = this.visibleTitles()).size()) {
            this.selectedIndex = index;
            Title selected = all.get(index);
            for (Consumer<Title> listener : this.selectionListeners) {
                listener.accept(selected);
            }
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.draggingScrollbar) {
            return false;
        }
        List<Title> all = this.visibleTitles();
        int maxOffset = Math.max(0, all.size() - 4);
        if (maxOffset <= 0) {
            return true;
        }
        int[] track = this.scrollbarTrackRect();
        int trackX = track[0];
        int trackY = track[1];
        int trackW = track[2];
        int trackH = track[3];
        int thumbH = this.scrollbarThumbHeight(all.size(), trackH);
        int usable = trackH - thumbH;
        int newTop = (int)Math.round(mouseY) - this.dragGrabOffsetY;
        newTop = Math.max(trackY, Math.min(trackY + usable, newTop));
        float ratio = usable <= 0 ? 0.0f : (float)(newTop - trackY) / (float)usable;
        this.scrollOffset = Math.max(0, Math.min(maxOffset, Math.round(ratio * (float)maxOffset)));
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return false;
    }

    private int[] boxRect() {
        int boxX = this.screenX + 7;
        int boxY = this.screenY + this.bgHeight - 12 - 64;
        return new int[]{boxX, boxY, 59, 64};
    }

    private void drawScaled(class_332 ctx, class_5481 text, int x, int y, int color, float scale) {
        if (scale == 1.0f) {
            ctx.method_35720(this.font, text, x, y, color);
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 0.0f);
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        int sx = Math.round((float)x / scale);
        int sy = Math.round((float)y / scale);
        ctx.method_35720(this.font, text, sx, sy, color);
        ctx.method_51448().method_22909();
    }

    private static String sortKeyFor(Title t) {
        String raw = t.displayName != null ? t.displayName.getString() : t.id.toString();
        String clean = TitleStyleUtil.parse(raw).text().trim();
        if (clean.isEmpty()) {
            clean = t.id.toString();
        }
        return clean;
    }

    private List<Title> visibleTitles() {
        Set<class_2960> unlockedSet = TitleClientData.getSelfUnlocked();
        ArrayList<Title> list = new ArrayList<Title>();
        for (Title t : TitleRegistry.all().values()) {
            if (t.hidden && !unlockedSet.contains(t.id)) continue;
            list.add(t);
        }
        list.sort((a, b) -> {
            String bk;
            String ak = TitlesListBox.sortKeyFor(a);
            int c = String.CASE_INSENSITIVE_ORDER.compare(ak, bk = TitlesListBox.sortKeyFor(b));
            if (c != 0) {
                return c;
            }
            return a.id.toString().compareTo(b.id.toString());
        });
        return list;
    }

    private void renderScrollbar(class_332 ctx, int mouseX, int mouseY, List<Title> allTitles) {
        int total = allTitles.size();
        int maxOffset = Math.max(0, total - 4);
        if (maxOffset <= 0) {
            return;
        }
        int[] track = this.scrollbarTrackRect();
        int trackX = track[0];
        int trackY = track[1];
        int trackW = track[2];
        int trackH = track[3];
        ctx.method_25294(trackX, trackY, trackX + trackW, trackY + trackH, 0x33000000);
        ctx.method_49601(trackX, trackY, trackW, trackH, 0x66000000);
        int thumbH = this.scrollbarThumbHeight(total, trackH);
        int usable = Math.max(0, trackH - thumbH);
        float ratio = maxOffset == 0 ? 0.0f : (float)this.scrollOffset / (float)maxOffset;
        int thumbTop = trackY + Math.round((float)usable * ratio);
        boolean hoveringThumb = mouseX >= trackX && mouseX <= trackX + trackW && mouseY >= thumbTop && mouseY <= thumbTop + thumbH;
        int thumbColor = hoveringThumb || this.draggingScrollbar ? -1140850689 : -1711276033;
        ctx.method_25294(trackX + 1, thumbTop, trackX + trackW - 1, thumbTop + thumbH, thumbColor);
        ctx.method_49601(trackX + 1, thumbTop, trackW - 2, thumbH, 0x66000000);
    }

    private boolean handleScrollbarClick(double mouseX, double mouseY) {
        List<Title> all = this.visibleTitles();
        int maxOffset = Math.max(0, all.size() - 4);
        if (maxOffset <= 0) {
            return false;
        }
        int[] track = this.scrollbarTrackRect();
        int trackX = track[0];
        int trackY = track[1];
        int trackW = track[2];
        int trackH = track[3];
        if (mouseX < (double)trackX || mouseX > (double)(trackX + trackW) || mouseY < (double)trackY || mouseY > (double)(trackY + trackH)) {
            return false;
        }
        int thumbH = this.scrollbarThumbHeight(all.size(), trackH);
        int usable = Math.max(0, trackH - thumbH);
        float ratio = maxOffset == 0 ? 0.0f : (float)this.scrollOffset / (float)maxOffset;
        int thumbTop = trackY + Math.round((float)usable * ratio);
        int thumbBottom = thumbTop + thumbH;
        if (mouseY >= (double)thumbTop && mouseY <= (double)thumbBottom) {
            this.draggingScrollbar = true;
            this.dragGrabOffsetY = (int)Math.round(mouseY) - thumbTop;
            return true;
        }
        this.scrollOffset = mouseY < (double)thumbTop ? Math.max(0, this.scrollOffset - 4) : Math.min(maxOffset, this.scrollOffset + 4);
        return true;
    }

    private int[] scrollbarTrackRect() {
        int[] r = this.boxRect();
        int boxX = r[0];
        int boxY = r[1];
        int boxW = r[2];
        int boxH = r[3];
        int trackW = this.scrollbarWidth;
        int baseX = boxX + boxW - trackW;
        int baseY = boxY;
        int trackX = baseX + this.scrollbarOffsetX;
        int trackY = baseY + this.scrollbarOffsetY;
        return new int[]{trackX, trackY, trackW, boxH};
    }

    private int scrollbarThumbHeight(int totalItems, int trackHeight) {
        if (totalItems <= 0) {
            return Math.max(8, trackHeight);
        }
        float visibleRatio = Math.min(1.0f, 4.0f / (float)totalItems);
        int h = Math.round((float)trackHeight * visibleRatio);
        return Math.max(8, Math.min(trackHeight, h));
    }
}

