/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.compat;

import net.fabricmc.loader.api.FabricLoader;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class LevelZCompat {
    private static final boolean IS_LOADED = FabricLoader.getInstance().isModLoaded("levelz");

    private LevelZCompat() {
    }

    public static boolean isLoaded() {
        return IS_LOADED;
    }

    public static int getLevel(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return -1;
        }
        try {
            LevelManagerAccess access;
            LevelManager manager;
            if (player instanceof LevelManagerAccess && (manager = (access = (LevelManagerAccess)player).getLevelManager()) != null) {
                return manager.getOverallLevel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static int getLevel(class_3222 player) {
        return LevelZCompat.getLevel((class_1657)player);
    }

    public static int getSkillPoints(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return -1;
        }
        try {
            LevelManagerAccess access;
            LevelManager manager;
            if (player instanceof LevelManagerAccess && (manager = (access = (LevelManagerAccess)player).getLevelManager()) != null) {
                return manager.getSkillPoints();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static float getLevelProgress(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return -1.0f;
        }
        try {
            LevelManagerAccess access;
            LevelManager manager;
            if (player instanceof LevelManagerAccess && (manager = (access = (LevelManagerAccess)player).getLevelManager()) != null) {
                return manager.getLevelProgress();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1.0f;
    }

    @Nullable
    public static LevelManager getLevelManager(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return null;
        }
        try {
            if (player instanceof LevelManagerAccess) {
                LevelManagerAccess access = (LevelManagerAccess)player;
                return access.getLevelManager();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isMaxLevel(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return false;
        }
        try {
            LevelManagerAccess access;
            LevelManager manager;
            if (player instanceof LevelManagerAccess && (manager = (access = (LevelManagerAccess)player).getLevelManager()) != null) {
                return manager.isMaxLevel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static int getNextLevelExperience(class_1657 player) {
        if (!IS_LOADED || player == null) {
            return -1;
        }
        try {
            LevelManagerAccess access;
            LevelManager manager;
            if (player instanceof LevelManagerAccess && (manager = (access = (LevelManagerAccess)player).getLevelManager()) != null) {
                return manager.getNextLevelExperience();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

