/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.mixin.client;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.party.PartyAllies;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1297.class})
public abstract class EntityCollisionClientMixin {
    private static boolean samePartyAndIgnoreClient(class_1297 a, class_1297 b) {
        if (a == null || b == null) {
            return false;
        }
        if (!ClientPartyHudData.ignorePartyCollision()) {
            return false;
        }
        UUID ownerA = PartyAllies.owningPlayerUuid(a);
        UUID ownerB = PartyAllies.owningPlayerUuid(b);
        if (ownerA == null || ownerB == null) {
            return false;
        }
        return ClientPartyHudData.isSameParty(ownerA, ownerB);
    }

    @Inject(method={"collidesWith(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpg$noPartyCollision_collidesWith(class_1297 other, CallbackInfoReturnable<Boolean> cir) {
        class_1297 self = (class_1297)this;
        if (self.method_37908().field_9236 && EntityCollisionClientMixin.samePartyAndIgnoreClient(self, other)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"pushAwayFrom(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpg$noPartyCollision_pushAwayFrom(class_1297 other, CallbackInfo ci) {
        class_1297 self = (class_1297)this;
        if (self.method_37908().field_9236 && EntityCollisionClientMixin.samePartyAndIgnoreClient(self, other)) {
            ci.cancel();
        }
    }
}

