/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.api.TitleApi;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.network.title.TitleListSyncPayload;
import net.pixeldreamstudios.rpgsystems.network.title.TitlePayloads;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;
import net.pixeldreamstudios.rpgsystems.util.TitlePowerBonusUtil;
import net.pixeldreamstudios.rpgsystems.util.TitleSpellBonusUtil;

public final class TitleNet {
    private TitleNet() {
    }

    public static void registerServer() {
        PayloadTypeRegistry.playC2S().register(TitlePayloads.RequestSetActive.ID, TitlePayloads.RequestSetActive.CODEC);
        PayloadTypeRegistry.playS2C().register(TitlePayloads.SyncSelf.ID, TitlePayloads.SyncSelf.CODEC);
        PayloadTypeRegistry.playS2C().register(TitlePayloads.SyncActive.ID, TitlePayloads.SyncActive.CODEC);
        PayloadTypeRegistry.playS2C().register(TitlePayloads.SyncDefinitions.ID, TitlePayloads.SyncDefinitions.CODEC);
        PayloadTypeRegistry.playS2C().register(TitlePayloads.SyncProgress.ID, TitlePayloads.SyncProgress.CODEC);
        PayloadTypeRegistry.playS2C().register(TitleListSyncPayload.ID, TitleListSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(TitlePayloads.RequestSetPermaToggles.ID, TitlePayloads.RequestSetPermaToggles.CODEC);
        PayloadTypeRegistry.playS2C().register(TitlePayloads.SyncPermaToggles.ID, TitlePayloads.SyncPermaToggles.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(TitlePayloads.RequestSetPermaToggles.ID, (payload, ctx) -> {
            class_3222 player = ctx.player();
            TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
            TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
            pt.permaDisabledGroups.clear();
            pt.permaDisabledGroups.addAll(payload.disabled());
            state.method_80();
            Optional<Title> unlocked = TitleApi.getActive(player).map(a -> a);
            ArrayList<Title> list = new ArrayList<Title>(pt.unlocked.size());
            for (String s : pt.unlocked) {
                try {
                    class_2960 id = class_2960.method_60654((String)s);
                    Title t = TitleRegistry.get(id);
                    if (t == null) continue;
                    list.add(t);
                }
                catch (Exception exception) {}
            }
            TitleApi.rebuildPermaAttributes(player, list);
            TitleSpellBonusUtil.rebuildAllTitleSpells(player, TitleApi.getActive(player).orElse(null), list);
            TitlePowerBonusUtil.rebuildAllTitlePowers(player, TitleApi.getActive(player).orElse(null), list);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new TitlePayloads.SyncPermaToggles(new ArrayList<String>(pt.permaDisabledGroups)));
        });
        ServerPlayNetworking.registerGlobalReceiver(TitlePayloads.RequestSetActive.ID, (payload, context) -> {
            Optional<class_2960> requested;
            class_3222 player = context.player();
            boolean ok = TitleApi.setActive(player, requested = payload.active());
            if (ok) {
                TitleNet.broadcastActiveToAll(player.method_5682(), player.method_5667(), requested);
                TitleNet.syncSelfTo(player.method_5682(), player);
                TitleNet.syncProgressTo(player.method_5682(), player);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            TitleNet.sendDefinitionsTo(server, handler.field_14140);
            TitleNet.syncSelfTo(server, handler.field_14140);
            TitleNet.syncProgressTo(server, handler.field_14140);
            TitleNet.broadcastActiveToAll(server, handler.field_14140.method_5667(), TitleNet.activeOf(server, handler.field_14140.method_5667()));
            TitleNet.broadcastAllActivesTo(server, handler.field_14140);
            TitleApi.refreshActiveOnLogin(handler.field_14140);
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new TitlePayloads.SyncPermaToggles(new ArrayList<String>(TitlesPersistentState.get((MinecraftServer)server).getOrCreate((UUID)handler.field_14140.method_5667()).permaDisabledGroups)));
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TitleNet.sendAllTitles(handler.field_14140));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            TitleApi.refreshActiveOnLogin(newPlayer);
            TitleNet.syncSelfTo(newPlayer.method_5682(), newPlayer);
            TitleNet.syncProgressTo(newPlayer.method_5682(), newPlayer);
            TitleNet.broadcastActiveToAll(newPlayer.method_5682(), newPlayer.method_5667(), TitleNet.activeOf(newPlayer.method_5682(), newPlayer.method_5667()));
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(TitlePayloads.SyncSelf.ID, (payload, context) -> context.client().execute(() -> TitleClientData.setSelf(payload.unlocked(), payload.active().orElse(null))));
        ClientPlayNetworking.registerGlobalReceiver(TitlePayloads.SyncActive.ID, (payload, context) -> context.client().execute(() -> TitleClientData.setActive(payload.playerUuid(), payload.active().orElse(null))));
        ClientPlayNetworking.registerGlobalReceiver(TitlePayloads.SyncPermaToggles.ID, (payload, ctx) -> ctx.client().execute(() -> TitleClientData.setPermaDisabled(new LinkedHashSet<String>(payload.disabled()))));
        ClientPlayNetworking.registerGlobalReceiver(TitleListSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            LinkedHashMap<class_2960, Title> merged = new LinkedHashMap<class_2960, Title>(TitleRegistry.all());
            for (TitleListSyncPayload.Entry e : payload.entries()) {
                class_2960 id = e.id();
                if (merged.containsKey(id)) continue;
                Title t = Title.builder(id, (class_2561)class_2561.method_43470((String)e.name())).hidden(e.hidden()).build();
                merged.put(id, t);
            }
            TitleRegistry.replaceAll(merged);
            TitleRegistry.bootstrapFallback();
        }));
        ClientPlayNetworking.registerGlobalReceiver(TitlePayloads.SyncDefinitions.ID, (payload, context) -> context.client().execute(() -> {
            LinkedHashMap<class_2960, Title> map = new LinkedHashMap<class_2960, Title>();
            for (TitlePayloads.SyncDefinitions.Def d : payload.defs()) {
                class_6880 entry;
                class_5321 key;
                class_2960 id = d.id();
                class_5250 name = class_2561.method_43470((String)d.name());
                class_2561 desc = (class_2561)d.description().map(class_2561::method_43470).orElse(class_2561.method_43473());
                Title.Builder b = Title.builder(id, (class_2561)name).description(desc).hidden(d.hidden());
                for (TitlePayloads.SyncDefinitions.BonusDef jb : d.bonuses()) {
                    key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)jb.attribute());
                    entry = (class_6880)class_7923.field_41190.method_40264(key).orElseThrow(() -> new IllegalArgumentException("Unknown attribute: " + String.valueOf(jb.attribute())));
                    b.add((class_6880<class_1320>)entry, jb.amount(), jb.operation());
                }
                for (TitlePayloads.SyncDefinitions.DamageBonusDef db : d.damage()) {
                    if (db.target().isPresent()) {
                        b.addDamageBonus(db.target().get(), db.amount(), db.op() == TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                        continue;
                    }
                    if (!db.tag().isPresent()) continue;
                    b.addDamageBonusTag(db.tag().get(), db.amount(), db.op() == TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                }
                for (class_2960 sid : d.spells()) {
                    b.addSpell(sid);
                }
                for (class_2960 pid : d.powers()) {
                    b.addPower(pid);
                }
                for (TitlePayloads.SyncDefinitions.BonusDef jb : d.permaBonuses()) {
                    key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)jb.attribute());
                    entry = (class_6880)class_7923.field_41190.method_40264(key).orElseThrow(() -> new IllegalArgumentException("Unknown attribute: " + String.valueOf(jb.attribute())));
                    b.addPerma((class_6880<class_1320>)entry, jb.amount(), jb.operation());
                }
                for (class_2960 sid : d.permaSpells()) {
                    b.addPermaSpell(sid);
                }
                for (class_2960 pid : d.permaPowers()) {
                    b.addPermaPower(pid);
                }
                for (TitlePayloads.SyncDefinitions.DamageBonusDef db : d.permaDamage()) {
                    if (db.target().isPresent()) {
                        b.addPermaDamageBonus(db.target().get(), db.amount(), db.op() == TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                        continue;
                    }
                    if (!db.tag().isPresent()) continue;
                    b.addPermaDamageBonusTag(db.tag().get(), db.amount(), db.op() == TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                }
                for (TitlePayloads.SyncDefinitions.ConditionDef cd : d.conditions()) {
                    Title.Condition.Type t = switch (cd.type()) {
                        default -> throw new MatchException(null, null);
                        case TitlePayloads.SyncDefinitions.CondType.OBTAIN_ITEM -> Title.Condition.Type.OBTAIN_ITEM;
                        case TitlePayloads.SyncDefinitions.CondType.KILL_MOBS -> Title.Condition.Type.KILL_MOBS;
                        case TitlePayloads.SyncDefinitions.CondType.ADVANCEMENT -> Title.Condition.Type.ADVANCEMENT;
                        case TitlePayloads.SyncDefinitions.CondType.WALK_BLOCKS -> Title.Condition.Type.WALK_BLOCKS;
                        case TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL -> Title.Condition.Type.REACH_LEVEL;
                        case TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL_XP -> Title.Condition.Type.REACH_LEVEL_XP;
                        case TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL_PUFFERFISH -> Title.Condition.Type.REACH_LEVEL_PUFFERFISH;
                        case TitlePayloads.SyncDefinitions.CondType.CRAFT_ITEM -> Title.Condition.Type.CRAFT_ITEM;
                        case TitlePayloads.SyncDefinitions.CondType.MINE_BLOCKS -> Title.Condition.Type.MINE_BLOCKS;
                        case TitlePayloads.SyncDefinitions.CondType.VISIT_BIOME -> Title.Condition.Type.VISIT_BIOME;
                        case TitlePayloads.SyncDefinitions.CondType.ENTER_DIMENSION -> Title.Condition.Type.ENTER_DIMENSION;
                        case TitlePayloads.SyncDefinitions.CondType.INTERACT_BLOCK -> Title.Condition.Type.INTERACT_BLOCK;
                        case TitlePayloads.SyncDefinitions.CondType.INTERACT_ENTITY -> Title.Condition.Type.INTERACT_ENTITY;
                        case TitlePayloads.SyncDefinitions.CondType.FIND_STRUCTURE -> Title.Condition.Type.FIND_STRUCTURE;
                        case TitlePayloads.SyncDefinitions.CondType.DEAL_DAMAGE_TOTAL -> Title.Condition.Type.DEAL_DAMAGE_TOTAL;
                        case TitlePayloads.SyncDefinitions.CondType.DEAL_DAMAGE_MAX -> Title.Condition.Type.DEAL_DAMAGE_MAX;
                        case TitlePayloads.SyncDefinitions.CondType.CHECK_ATTRIBUTE -> Title.Condition.Type.CHECK_ATTRIBUTE;
                    };
                    b.addCondition(new Title.Condition(t, cd.item(), cd.entityType(), cd.advancement(), cd.distance(), cd.count(), cd.hint(), cd.hidden(), cd.entitySpec(), cd.nbtQuery(), cd.level(), cd.block(), cd.biome(), cd.dimension(), cd.structure(), cd.attribute(), cd.min(), cd.entityTag()));
                }
                map.put(id, b.build());
            }
            TitleRegistry.replaceAll(map);
            TitleRegistry.bootstrapFallback();
        }));
        ClientPlayNetworking.registerGlobalReceiver(TitlePayloads.SyncProgress.ID, (payload, context) -> context.client().execute(() -> TitleClientData.setProgress(payload.progresses())));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> TitleClientData.clear());
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> TitleClientData.clear());
    }

    private static Optional<class_2960> activeOf(MinecraftServer server, UUID uuid) {
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(uuid);
        return Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
    }

    public static void syncSelfTo(MinecraftServer server, class_3222 player) {
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        ArrayList<class_2960> unlocked = new ArrayList<class_2960>();
        for (String s : pt.unlocked) {
            unlocked.add(class_2960.method_60654((String)s));
        }
        Optional<Object> active = Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TitlePayloads.SyncSelf(unlocked, active));
    }

    public static void sendAllTitles(class_3222 player) {
        ArrayList<TitleListSyncPayload.Entry> entries = new ArrayList<TitleListSyncPayload.Entry>();
        for (Title t : TitleRegistry.all().values()) {
            String name = t.displayName != null ? t.displayName.getString() : t.id.toString();
            boolean hidden = t.hidden;
            entries.add(new TitleListSyncPayload.Entry(t.id, name, hidden));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TitleListSyncPayload(entries));
    }

    public static void syncProgressTo(MinecraftServer server, class_3222 player) {
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        ArrayList<Map.Entry<class_2960, Title>> entries = new ArrayList<Map.Entry<class_2960, Title>>(TitleRegistry.all().entrySet());
        ArrayList<TitlePayloads.SyncProgress.TitleProgress> out = new ArrayList<TitlePayloads.SyncProgress.TitleProgress>();
        for (Map.Entry<class_2960, Title> e : entries) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (t.conditions.isEmpty()) continue;
            ArrayList<TitlePayloads.SyncProgress.CondProg> conds = new ArrayList<TitlePayloads.SyncProgress.CondProg>();
            for (int i = 0; i < t.conditions.size(); ++i) {
                class_2487 tag = pt.progress.get(id.toString());
                long cur = tag == null ? 0L : tag.method_10537("c" + i);
                boolean done = tag != null && tag.method_10577("done_" + i);
                conds.add(new TitlePayloads.SyncProgress.CondProg(cur, done));
            }
            out.add(new TitlePayloads.SyncProgress.TitleProgress(id, conds));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TitlePayloads.SyncProgress(out));
    }

    private static void sendDefinitionsTo(MinecraftServer server, class_3222 player) {
        ArrayList<TitlePayloads.SyncDefinitions.Def> defs = new ArrayList<TitlePayloads.SyncDefinitions.Def>();
        for (Map.Entry<class_2960, Title> e : TitleRegistry.all().entrySet()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            String name = t.displayName == null ? id.toString() : t.displayName.getString();
            String desc = t.description == null ? "" : t.description.getString();
            ArrayList<TitlePayloads.SyncDefinitions.BonusDef> bdefs = new ArrayList<TitlePayloads.SyncDefinitions.BonusDef>();
            ArrayList<TitlePayloads.SyncDefinitions.DamageBonusDef> ddefs = new ArrayList<TitlePayloads.SyncDefinitions.DamageBonusDef>();
            ArrayList<class_2960> sdefs = new ArrayList<class_2960>();
            ArrayList<class_2960> pdefs = new ArrayList<class_2960>();
            for (Title.Bonus b : t.bonuses) {
                class_2960 attrId;
                if (b == null) continue;
                if (b.spellId != null && b.spellId.isPresent()) {
                    sdefs.add(b.spellId.get());
                    continue;
                }
                if (b.powerId != null && b.powerId.isPresent()) {
                    pdefs.add(b.powerId.get());
                    continue;
                }
                if (b.damageTarget != null && b.damageTarget.isPresent()) {
                    op = b.damageOp == Title.DamageOp.MULTIPLIED ? TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED : TitlePayloads.SyncDefinitions.DmgOp.ADDED;
                    ddefs.add(new TitlePayloads.SyncDefinitions.DamageBonusDef(b.damageTarget, Optional.empty(), b.damageAmount, op));
                } else if (b.damageTag != null && b.damageTag.isPresent()) {
                    op = b.damageOp == Title.DamageOp.MULTIPLIED ? TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED : TitlePayloads.SyncDefinitions.DmgOp.ADDED;
                    ddefs.add(new TitlePayloads.SyncDefinitions.DamageBonusDef(Optional.empty(), b.damageTag, b.damageAmount, op));
                }
                if (b.attribute == null || (attrId = class_7923.field_41190.method_10221((Object)((class_1320)b.attribute.comp_349()))) == null) continue;
                bdefs.add(new TitlePayloads.SyncDefinitions.BonusDef(attrId, b.amount, b.operation));
            }
            ArrayList<TitlePayloads.SyncDefinitions.BonusDef> p_bdefs = new ArrayList<TitlePayloads.SyncDefinitions.BonusDef>();
            ArrayList<TitlePayloads.SyncDefinitions.DamageBonusDef> p_ddefs = new ArrayList<TitlePayloads.SyncDefinitions.DamageBonusDef>();
            ArrayList<class_2960> p_sdefs = new ArrayList<class_2960>();
            ArrayList<class_2960> p_pdefs = new ArrayList<class_2960>();
            for (Title.Bonus b : t.permaBonuses) {
                class_2960 attrId;
                if (b.spellId != null && b.spellId.isPresent()) {
                    p_sdefs.add(b.spellId.get());
                    continue;
                }
                if (b.powerId != null && b.powerId.isPresent()) {
                    p_pdefs.add(b.powerId.get());
                    continue;
                }
                if (b.damageTarget != null && b.damageTarget.isPresent()) {
                    op = b.damageOp == Title.DamageOp.MULTIPLIED ? TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED : TitlePayloads.SyncDefinitions.DmgOp.ADDED;
                    p_ddefs.add(new TitlePayloads.SyncDefinitions.DamageBonusDef(b.damageTarget, Optional.empty(), b.damageAmount, op));
                } else if (b.damageTag != null && b.damageTag.isPresent()) {
                    op = b.damageOp == Title.DamageOp.MULTIPLIED ? TitlePayloads.SyncDefinitions.DmgOp.MULTIPLIED : TitlePayloads.SyncDefinitions.DmgOp.ADDED;
                    p_ddefs.add(new TitlePayloads.SyncDefinitions.DamageBonusDef(Optional.empty(), b.damageTag, b.damageAmount, op));
                }
                if (b.attribute == null || (attrId = class_7923.field_41190.method_10221((Object)((class_1320)b.attribute.comp_349()))) == null) continue;
                p_bdefs.add(new TitlePayloads.SyncDefinitions.BonusDef(attrId, b.amount, b.operation));
            }
            ArrayList<TitlePayloads.SyncDefinitions.ConditionDef> cdefs = new ArrayList<TitlePayloads.SyncDefinitions.ConditionDef>();
            for (Title.Condition c : t.conditions) {
                TitlePayloads.SyncDefinitions.CondType type = switch (c.type) {
                    default -> throw new MatchException(null, null);
                    case Title.Condition.Type.OBTAIN_ITEM -> TitlePayloads.SyncDefinitions.CondType.OBTAIN_ITEM;
                    case Title.Condition.Type.KILL_MOBS -> TitlePayloads.SyncDefinitions.CondType.KILL_MOBS;
                    case Title.Condition.Type.ADVANCEMENT -> TitlePayloads.SyncDefinitions.CondType.ADVANCEMENT;
                    case Title.Condition.Type.WALK_BLOCKS -> TitlePayloads.SyncDefinitions.CondType.WALK_BLOCKS;
                    case Title.Condition.Type.REACH_LEVEL -> TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL;
                    case Title.Condition.Type.REACH_LEVEL_XP -> TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL_XP;
                    case Title.Condition.Type.REACH_LEVEL_PUFFERFISH -> TitlePayloads.SyncDefinitions.CondType.REACH_LEVEL_PUFFERFISH;
                    case Title.Condition.Type.CRAFT_ITEM -> TitlePayloads.SyncDefinitions.CondType.CRAFT_ITEM;
                    case Title.Condition.Type.MINE_BLOCKS -> TitlePayloads.SyncDefinitions.CondType.MINE_BLOCKS;
                    case Title.Condition.Type.VISIT_BIOME -> TitlePayloads.SyncDefinitions.CondType.VISIT_BIOME;
                    case Title.Condition.Type.ENTER_DIMENSION -> TitlePayloads.SyncDefinitions.CondType.ENTER_DIMENSION;
                    case Title.Condition.Type.INTERACT_BLOCK -> TitlePayloads.SyncDefinitions.CondType.INTERACT_BLOCK;
                    case Title.Condition.Type.INTERACT_ENTITY -> TitlePayloads.SyncDefinitions.CondType.INTERACT_ENTITY;
                    case Title.Condition.Type.FIND_STRUCTURE -> TitlePayloads.SyncDefinitions.CondType.FIND_STRUCTURE;
                    case Title.Condition.Type.DEAL_DAMAGE_TOTAL -> TitlePayloads.SyncDefinitions.CondType.DEAL_DAMAGE_TOTAL;
                    case Title.Condition.Type.DEAL_DAMAGE_MAX -> TitlePayloads.SyncDefinitions.CondType.DEAL_DAMAGE_MAX;
                    case Title.Condition.Type.CHECK_ATTRIBUTE -> TitlePayloads.SyncDefinitions.CondType.CHECK_ATTRIBUTE;
                };
                cdefs.add(new TitlePayloads.SyncDefinitions.ConditionDef(type, c.item, c.entityType, c.advancement, c.distance, c.count, c.hint, c.hidden, c.entitySpec, c.nbtQuery, c.level, c.block, c.biome, c.dimension, c.structure, c.attributeId, c.minValue, c.entityTagId));
            }
            defs.add(new TitlePayloads.SyncDefinitions.Def(id, name, Optional.ofNullable(desc.isEmpty() ? null : desc), bdefs, sdefs, pdefs, ddefs, p_bdefs, p_sdefs, p_pdefs, p_ddefs, cdefs, t.hidden));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TitlePayloads.SyncDefinitions(defs));
    }

    private static void broadcastActiveToAll(MinecraftServer server, UUID playerUuid, Optional<class_2960> active) {
        TitlePayloads.SyncActive pkt = new TitlePayloads.SyncActive(playerUuid, active);
        for (class_3222 sp : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)sp, (class_8710)pkt);
        }
    }

    private static void broadcastAllActivesTo(MinecraftServer server, class_3222 targetPlayer) {
        for (class_3222 sp : server.method_3760().method_14571()) {
            Optional<class_2960> active = TitleNet.activeOf(server, sp.method_5667());
            ServerPlayNetworking.send((class_3222)targetPlayer, (class_8710)new TitlePayloads.SyncActive(sp.method_5667(), active));
        }
    }
}

