/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.Collection;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.network.PartyNet;
import net.pixeldreamstudios.rpgsystems.network.party.PartyInvitePayloads;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsIntegration;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsJoinRequests;
import net.pixeldreamstudios.rpgsystems.party.PartyPersistentState;
import net.pixeldreamstudios.rpgsystems.party.PartySettings;

public final class FTBTeamsEventListener {
    public static void register() {
        if (!FTBTeamsIntegration.isEnabled()) {
            return;
        }
        TeamEvent.PLAYER_JOINED_PARTY.register(event -> {
            class_3222 player = event.getPlayer();
            Team team = event.getTeam();
            if (player != null && team != null) {
                String partyName = (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteJoinConfirmed(partyName));
                for (class_3222 member : team.getOnlineMembers()) {
                    if (member.method_5667().equals(player.method_5667())) continue;
                    PartyNet.sendNoticeTo(member, team.getId(), player.method_5477().getString() + " joined the party.", System.currentTimeMillis());
                }
            }
            FTBTeamsEventListener.onPartyChanged(event.getTeam());
        });
        TeamEvent.PLAYER_LEFT_PARTY.register(event -> {
            class_3222 leftPlayer = event.getPlayer();
            Team team = event.getTeam();
            if (leftPlayer != null) {
                String partyName = team != null ? (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME) : "the party";
                ServerPlayNetworking.send((class_3222)leftPlayer, (class_8710)new PartyInvitePayloads.PartyLeft(partyName));
                PartyNet.sendRosterWipeTo(leftPlayer);
            }
            if (team != null && leftPlayer != null) {
                String leftPlayerName = leftPlayer.method_5477().getString();
                for (class_3222 member : team.getOnlineMembers()) {
                    PartyNet.sendNoticeTo(member, team.getId(), leftPlayerName + " left the party.", System.currentTimeMillis());
                }
                FTBTeamsJoinRequests.clearRequestsForPlayer(leftPlayer.method_5667());
            }
            FTBTeamsEventListener.onPartyChanged(event.getTeam());
        });
        TeamEvent.PROPERTIES_CHANGED.register(event -> {
            Team team = event.getTeam();
            if (!team.isPartyTeam()) {
                return;
            }
            for (class_3222 member : team.getOnlineMembers()) {
                PartyNet.sendNoticeTo(member, team.getId(), "Party settings updated.", System.currentTimeMillis());
            }
            FTBTeamsEventListener.onPartyChanged(team);
        });
        TeamEvent.OWNERSHIP_TRANSFERRED.register(event -> {
            Team team = event.getTeam();
            if (!team.isPartyTeam()) {
                return;
            }
            class_3222 newLeader = null;
            UUID newOwnerId = team.getOwner();
            if (newOwnerId != null) {
                for (class_3222 m : team.getOnlineMembers()) {
                    if (!m.method_5667().equals(newOwnerId)) continue;
                    newLeader = m;
                    break;
                }
            }
            String leaderName = newLeader != null ? newLeader.method_5477().getString() : "the new leader";
            for (class_3222 member : team.getOnlineMembers()) {
                PartyNet.sendNoticeTo(member, team.getId(), "Leadership transferred to " + leaderName + ".", System.currentTimeMillis());
            }
            FTBTeamsEventListener.onPartyChanged(team);
        });
        TeamEvent.DELETED.register(event -> {
            class_3222 anyMember;
            MinecraftServer server;
            Team team = event.getTeam();
            if (!team.isPartyTeam()) {
                return;
            }
            Collection online = team.getOnlineMembers();
            for (class_3222 member : online) {
                PartyNet.sendNoticeTo(member, team.getId(), "Party disbanded.", System.currentTimeMillis());
                PartyNet.sendRosterWipeTo(member);
            }
            if (!online.isEmpty() && (server = (anyMember = (class_3222)online.iterator().next()).method_5682()) != null) {
                FTBTeamsIntegration.cleanupPartySettings(server, team.getId());
            }
        });
    }

    private static void onPartyChanged(Team team) {
        if (!team.isPartyTeam()) {
            return;
        }
        Collection onlineMembers = team.getOnlineMembers();
        if (onlineMembers.isEmpty()) {
            return;
        }
        class_3222 anyMember = (class_3222)onlineMembers.iterator().next();
        MinecraftServer server = anyMember.method_5682();
        if (server == null) {
            return;
        }
        FTBTeamsIntegration.FTBPartyData ftbData = FTBTeamsIntegration.getPartyDataForPlayerId(server, team.getOwner());
        if (ftbData == null) {
            PartyPersistentState state = PartyPersistentState.get(server);
            PartySettings settings = state.getFTBPartySettings(team.getId());
            ftbData = new FTBTeamsIntegration.FTBPartyData(team.getId(), (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME), team.getOwner(), team.getMembers(), settings);
        }
        for (class_3222 member : onlineMembers) {
            PartyNet.sendFTBTeamsRosterTo(server, member, ftbData);
        }
    }

    public static String getFTBTeamMemberName(MinecraftServer server, UUID memberId, class_3222 member) {
        if (member != null) {
            return member.method_5477().getString();
        }
        if (!FabricLoader.getInstance().isModLoaded("ftbteams")) {
            return memberId.toString();
        }
        try {
            TeamManager ftbManager = FTBTeamsAPI.api().getManager();
            return ftbManager.getPlayerTeamForPlayerID(memberId).map(team -> ((PlayerTeam)team).getPlayerName()).orElse(memberId.toString());
        }
        catch (Exception e) {
            return memberId.toString();
        }
    }
}

