/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1322;
import net.minecraft.class_2960;

public record TitleData(Optional<String> name, Optional<String> description, List<Condition> conditions, List<Bonus> bonuses, List<Bonus> permaBonuses) {
    public static final Codec<TitleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("name").forGetter(TitleData::name), (App)Codec.STRING.optionalFieldOf("description").forGetter(TitleData::description), (App)Codec.list(Condition.CODEC).optionalFieldOf("conditions", List.of()).forGetter(TitleData::conditions), (App)Codec.list(Bonus.CODEC).optionalFieldOf("bonuses", List.of()).forGetter(TitleData::bonuses), (App)Codec.list(Bonus.CODEC).optionalFieldOf("perma_bonuses", List.of()).forGetter(TitleData::permaBonuses)).apply((Applicative)i, TitleData::new));

    public record Condition(ConditionType type, Optional<class_2960> item, Optional<class_2960> entityType, Optional<class_2960> advancement, Optional<Long> distance, Optional<Integer> count, Optional<String> hint, Optional<Boolean> hidden, Optional<String> entity, Optional<String> nbt, Optional<Integer> level, Optional<class_2960> block, Optional<class_2960> biome, Optional<class_2960> dimension, Optional<class_2960> structure, Optional<class_2960> attribute, Optional<Double> min, Optional<class_2960> entityTag) {
        private static final MapCodec<Pair<Optional<String>, Optional<String>>> ENTITY_AND_NBT = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("entity").forGetter(Pair::getFirst), (App)Codec.STRING.optionalFieldOf("nbt").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
        private static final MapCodec<Pair<Optional<class_2960>, Optional<class_2960>>> ENTITY_TYPE_OR_TAG = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_2960.field_25139.optionalFieldOf("entity_type").forGetter(Pair::getFirst), (App)class_2960.field_25139.optionalFieldOf("entity_tag").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(i -> i.group((App)ConditionType.CODEC.fieldOf("type").forGetter(Condition::type), (App)class_2960.field_25139.optionalFieldOf("item").forGetter(Condition::item), (App)class_2960.field_25139.optionalFieldOf("advancement").forGetter(Condition::advancement), (App)Codec.LONG.optionalFieldOf("distance").forGetter(Condition::distance), (App)Codec.INT.optionalFieldOf("count").forGetter(Condition::count), (App)Codec.STRING.optionalFieldOf("hint").forGetter(Condition::hint), (App)Codec.BOOL.optionalFieldOf("hidden").forGetter(Condition::hidden), (App)ENTITY_AND_NBT.forGetter(c -> Pair.of(c.entity(), c.nbt())), (App)Codec.INT.optionalFieldOf("level").forGetter(Condition::level), (App)class_2960.field_25139.optionalFieldOf("block").forGetter(Condition::block), (App)class_2960.field_25139.optionalFieldOf("biome").forGetter(Condition::biome), (App)class_2960.field_25139.optionalFieldOf("dimension").forGetter(Condition::dimension), (App)class_2960.field_25139.optionalFieldOf("structure").forGetter(Condition::structure), (App)class_2960.field_25139.optionalFieldOf("attribute").forGetter(Condition::attribute), (App)Codec.DOUBLE.optionalFieldOf("min").forGetter(Condition::min), (App)ENTITY_TYPE_OR_TAG.forGetter(c -> Pair.of(c.entityType(), c.entityTag()))).apply((Applicative)i, (type, item, advancement, distance, count, hint, hidden, enNbt, level, block, biome, dimension, structure, attribute, min, typeOrTag) -> new Condition((ConditionType)((Object)((Object)type)), (Optional<class_2960>)item, (Optional)typeOrTag.getFirst(), (Optional<class_2960>)advancement, (Optional<Long>)distance, (Optional<Integer>)count, (Optional<String>)hint, (Optional<Boolean>)hidden, (Optional)enNbt.getFirst(), (Optional)enNbt.getSecond(), (Optional<Integer>)level, (Optional<class_2960>)block, (Optional<class_2960>)biome, (Optional<class_2960>)dimension, (Optional<class_2960>)structure, (Optional<class_2960>)attribute, (Optional<Double>)min, (Optional)typeOrTag.getSecond())));
    }

    public record Bonus(List<AttrBonus> attributes, List<class_2960> spells, List<class_2960> powers, List<DamageBonus> damageBonuses) {
        public static final Codec<Bonus> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codecs.oneOrMany(AttrBonus.CODEC).optionalFieldOf("attribute", List.of()).forGetter(Bonus::attributes), (App)Codecs.oneOrMany(class_2960.field_25139).optionalFieldOf("spell", List.of()).forGetter(Bonus::spells), (App)Codecs.oneOrMany(class_2960.field_25139).optionalFieldOf("power", List.of()).forGetter(Bonus::powers), (App)Codecs.oneOrMany(DamageBonus.CODEC).optionalFieldOf("damage_bonus", List.of()).forGetter(Bonus::damageBonuses)).apply((Applicative)i, Bonus::new));
    }

    public record DamageBonus(Optional<class_2960> id, Optional<class_2960> tag, double amount, DamageOp operation) {
        public static final Codec<DamageBonus> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.optionalFieldOf("id").forGetter(DamageBonus::id), (App)class_2960.field_25139.optionalFieldOf("tag").forGetter(DamageBonus::tag), (App)Codec.DOUBLE.fieldOf("amount").forGetter(DamageBonus::amount), (App)DamageOp.CODEC.fieldOf("operation").forGetter(DamageBonus::operation)).apply((Applicative)i, (id, tag, amount, op) -> {
            if (id.isEmpty() && tag.isEmpty()) {
                return new DamageBonus(Optional.empty(), Optional.empty(), (double)amount, (DamageOp)((Object)((Object)op)));
            }
            return new DamageBonus((Optional<class_2960>)id, (Optional<class_2960>)tag, (double)amount, (DamageOp)((Object)((Object)op)));
        }));
    }

    public static enum DamageOp {
        ADDED,
        MULTIPLIED;

        public static final Codec<DamageOp> CODEC;

        static {
            CODEC = Codec.STRING.xmap(s -> s.equalsIgnoreCase("multiplied") ? MULTIPLIED : ADDED, op -> op == MULTIPLIED ? "multiplied" : "added");
        }
    }

    public record AttrBonus(class_2960 id, double amount, class_1322.class_1323 operation) {
        public static final Codec<class_1322.class_1323> OP_CODEC = Codec.STRING.xmap(s -> {
            String k = s.toUpperCase(Locale.ROOT);
            if (k.equals("ADD_MULTIPLIED_BASE") || k.equals("MULTIPLY_BASE")) {
                return class_1322.class_1323.field_6330;
            }
            if (k.equals("ADD_MULTIPLIED_TOTAL") || k.equals("MULTIPLY_TOTAL")) {
                return class_1322.class_1323.field_6331;
            }
            return class_1322.class_1323.field_6328;
        }, op -> switch (op) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6330 -> "multiply_base";
            case class_1322.class_1323.field_6331 -> "multiply_total";
            case class_1322.class_1323.field_6328 -> "add_value";
        });
        public static final Codec<AttrBonus> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("id").forGetter(AttrBonus::id), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttrBonus::amount), (App)OP_CODEC.fieldOf("operation").forGetter(AttrBonus::operation)).apply((Applicative)i, AttrBonus::new));
    }

    public static final class Codecs {
        private Codecs() {
        }

        public static <T> Codec<List<T>> oneOrMany(Codec<T> single) {
            return Codec.either(single, (Codec)Codec.list(single)).xmap(e -> (List)e.map(List::of, l -> l), l -> l.size() == 1 ? Either.left(l.get(0)) : Either.right((Object)l));
        }
    }

    public static enum ConditionType {
        OBTAIN_ITEM,
        KILL_MOBS,
        ADVANCEMENT,
        WALK_BLOCKS,
        REACH_LEVEL,
        REACH_LEVEL_XP,
        REACH_LEVEL_PUFFERFISH,
        CRAFT_ITEM,
        MINE_BLOCKS,
        VISIT_BIOME,
        ENTER_DIMENSION,
        INTERACT_BLOCK,
        INTERACT_ENTITY,
        FIND_STRUCTURE,
        DEAL_DAMAGE_TOTAL,
        DEAL_DAMAGE_MAX,
        CHECK_ATTRIBUTE;

        public static final Codec<ConditionType> CODEC;

        static {
            CODEC = Codec.STRING.xmap(s -> {
                String k = s.toLowerCase(Locale.ROOT);
                if (k.equals("reach_level")) {
                    return REACH_LEVEL;
                }
                if (k.equals("reach_level_xp")) {
                    return REACH_LEVEL_XP;
                }
                if (k.equals("reach_level_pufferfish")) {
                    return REACH_LEVEL_PUFFERFISH;
                }
                return ConditionType.valueOf(k.toUpperCase(Locale.ROOT));
            }, t -> t.name().toLowerCase(Locale.ROOT));
        }
    }
}

