/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title.power.powers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.title.power.TitlePower;

public final class IlluminatePower
implements TitlePower {
    public static final class_2960 ID = class_2960.method_60655((String)"rpg-systems", (String)"illuminate");
    private final Map<UUID, class_2338> lastPos = new HashMap<UUID, class_2338>();
    private final Map<UUID, class_5321<class_1937>> lastDim = new HashMap<UUID, class_5321<class_1937>>();

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void onDeactivate(class_3222 player) {
        this.removeLight(player.method_5682(), player.method_5667());
    }

    @Override
    public void onServerTick(MinecraftServer server, Set<class_3222> players) {
        for (class_3222 class_32222 : players) {
            this.tryUpdateLight(class_32222);
        }
        if (!this.lastPos.isEmpty()) {
            HashSet<UUID> active = new HashSet<UUID>();
            for (class_3222 p : players) {
                active.add(p.method_5667());
            }
            ArrayList<UUID> arrayList = new ArrayList<UUID>();
            for (UUID u : this.lastPos.keySet()) {
                if (active.contains(u)) continue;
                arrayList.add(u);
            }
            for (UUID u : arrayList) {
                this.removeLight(server, u);
            }
        }
    }

    private void tryUpdateLight(class_3222 player) {
        class_2338 target;
        class_1937 world = player.method_37908();
        UUID id = player.method_5667();
        class_2338 previous = this.lastPos.get(id);
        class_5321<class_1937> prevDim = this.lastDim.get(id);
        if (previous != null && prevDim != null && prevDim != world.method_27983()) {
            this.removeLight(player, previous, prevDim, true);
            previous = null;
        }
        if ((target = this.findPlaceableAir(world, player.method_24515())) == null) {
            if (previous != null) {
                this.removeLight(player, previous, (class_5321<class_1937>)world.method_27983(), true);
            }
            return;
        }
        if (previous != null && previous.equals((Object)target)) {
            return;
        }
        if (previous != null) {
            this.removeLight(player, previous, (class_5321<class_1937>)world.method_27983(), false);
        }
        class_2680 state = class_2246.field_31037.method_9564();
        world.method_8652(target, state, 18);
        this.lastPos.put(id, target);
        this.lastDim.put(id, (class_5321<class_1937>)world.method_27983());
    }

    private void removeLight(MinecraftServer server, UUID id) {
        class_2338 prev = this.lastPos.remove(id);
        class_5321<class_1937> dim = this.lastDim.remove(id);
        if (prev == null || dim == null) {
            return;
        }
        class_3218 world = server.method_3847(dim);
        if (world == null) {
            return;
        }
        class_2680 cur = world.method_8320(prev);
        if (cur.method_27852(class_2246.field_31037)) {
            world.method_8650(prev, false);
        }
    }

    private void removeLight(class_3222 player, class_2338 pos, class_5321<class_1937> dim, boolean strictDim) {
        class_3218 world = player.method_5682().method_3847(dim);
        if (world == null) {
            return;
        }
        class_2680 cur = world.method_8320(pos);
        if (cur.method_27852(class_2246.field_31037)) {
            world.method_8650(pos, false);
        }
    }

    private class_2338 findPlaceableAir(class_1937 world, class_2338 base) {
        if (this.isAirOrLight(world, base)) {
            return base;
        }
        class_2338 above = base.method_10084();
        if (this.isAirOrLight(world, above)) {
            return above;
        }
        class_2338 below = base.method_10074();
        if (this.isAirOrLight(world, below)) {
            return below;
        }
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_2338 p = base.method_10093(d);
            if (!this.isAirOrLight(world, p)) continue;
            return p;
        }
        return null;
    }

    private boolean isAirOrLight(class_1937 world, class_2338 pos) {
        class_2680 s = world.method_8320(pos);
        return s.method_26215() || s.method_27852(class_2246.field_31037);
    }
}

