/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity;

import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.api.item.HunterContractItem;
import moriyashiine.nycto.common.component.entity.power.vampire.VampiricThrallComponent;
import moriyashiine.nycto.common.entity.mob.HunterEntity;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModGameRules;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class HunterHeatComponent
implements ServerTickingComponent {
    private static final int DECAY_TIMER = 6000;
    private static final int MAXIMUM_HEAT = 5;
    private static final int MAXIMUM_SPAWNS = 3;
    private final class_1657 obj;
    private int heatLevel = 0;
    private int decayTicks = 0;
    private int timesSpawned = 0;
    private int spawnDecayTicks = 0;

    public HunterHeatComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.heatLevel = readView.method_71424("HeatLevel", 0);
        this.decayTicks = readView.method_71424("DecayTicks", 0);
        this.timesSpawned = readView.method_71424("TimesSpawned", 0);
        this.spawnDecayTicks = readView.method_71424("SpawnDecayTicks", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71465("HeatLevel", this.heatLevel);
        writeView.method_71465("DecayTicks", this.decayTicks);
        writeView.method_71465("TimesSpawned", this.timesSpawned);
        writeView.method_71465("SpawnDecayTicks", this.spawnDecayTicks);
    }

    public void serverTick() {
        if (this.heatLevel > 0 && --this.decayTicks == 0 && --this.heatLevel > 0) {
            this.decayTicks = 6000;
        }
        if (this.timesSpawned > 0 && --this.spawnDecayTicks == 0 && --this.timesSpawned > 0) {
            this.spawnDecayTicks = 6000;
        }
    }

    public void maybeIncreaseHeat(class_1309 target, boolean maximize) {
        class_3218 world;
        class_1937 class_19372;
        if (!this.obj.method_68878() && (class_19372 = this.obj.method_73183()) instanceof class_3218 && (world = (class_3218)class_19372).method_64395().method_8355(ModGameRules.DO_HUNTER_SPAWNING) && HunterHeatComponent.canIncreaseHeat(target)) {
            if (target instanceof class_1569 && target.method_59922().method_43056()) {
                return;
            }
            if (!this.obj.method_73183().method_8390(class_1309.class, new class_238(target.method_24515()).method_1014(16.0), foundEntity -> target != foundEntity && HunterHeatComponent.canIncreaseHeat(foundEntity)).isEmpty()) {
                if (maximize) {
                    this.maximizeHeat();
                } else {
                    this.increaseHeat();
                }
            }
        }
    }

    public void increaseHeat() {
        if (this.heatLevel + 1 >= 5) {
            if (this.timesSpawned < 3 && HunterContractItem.spawnHunter(this.obj.method_73183(), this.obj, NyctoAPI.isVampire((class_1297)this.obj) ? HunterEntity.HunterType.VAMPIRE : HunterEntity.HunterType.WEREWOLF, this.obj.method_59922().method_39332(1, 3)).method_23665()) {
                this.decayTicks = 0;
                this.heatLevel = 0;
                ++this.timesSpawned;
                this.spawnDecayTicks = 6000;
            }
        } else {
            ++this.heatLevel;
            this.decayTicks = 6000;
        }
    }

    public void maximizeHeat() {
        for (int i = this.heatLevel; i < 5; ++i) {
            this.increaseHeat();
        }
    }

    private static boolean canIncreaseHeat(class_1309 target) {
        if (target.method_5864().method_20210(ModEntityTypeTags.CALLS_HUNTERS)) {
            class_3763 raider;
            if (target instanceof class_3763 && (raider = (class_3763)target).method_16478() != null) {
                return false;
            }
            @Nullable VampiricThrallComponent vampiricThrallComponent = (VampiricThrallComponent)ModEntityComponents.VAMPIRIC_THRALL.getNullable((Object)target);
            return vampiricThrallComponent == null || !vampiricThrallComponent.hasOwner();
        }
        return false;
    }
}

