/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.world.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.init.ModDamageTypes;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModParticleTypes;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.init.ModWorldComponents;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class BatSwarmComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1937 obj;
    private final List<BatSwarm> batSwarms = new ArrayList<BatSwarm>();

    public BatSwarmComponent(class_1937 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.batSwarms.clear();
        for (BatSwarm batSwarm : readView.method_71426("BatSwarms", BatSwarm.CODEC.listOf()).orElse(List.of())) {
            this.batSwarms.add(new BatSwarm(batSwarm.getOwnerId(), new ArrayList<Integer>(batSwarm.getTargetIds()), batSwarm.getPos(), batSwarm.getAge(), batSwarm.getBlood()));
        }
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71468("BatSwarms", BatSwarm.CODEC.listOf(), this.batSwarms);
    }

    public void tick() {
        for (int i = this.batSwarms.size() - 1; i >= 0; --i) {
            BatSwarm batSwarm = this.batSwarms.get(i);
            batSwarm.tick(this.obj);
            if (batSwarm.deathTicks <= 20) continue;
            this.batSwarms.remove(i);
        }
    }

    public void sync() {
        ModWorldComponents.BAT_SWARM.sync((Object)this.obj);
    }

    public void addBatSwarm(class_1309 owner) {
        this.batSwarms.add(new BatSwarm(owner.method_5667(), new ArrayList<Integer>(), owner.method_33571(), owner.method_31747() ? 0 : 300, 0));
    }

    public void addTarget(class_1309 owner, class_1309 target) {
        for (BatSwarm batSwarm : this.batSwarms) {
            if (batSwarm.owner != owner) continue;
            for (int i = batSwarm.targetIds.size() - 1; i >= 0; --i) {
                if (batSwarm.targetIds.get(i).intValue() != target.method_5628()) continue;
                batSwarm.targetIds.remove(i);
            }
            batSwarm.targetIds.add(target.method_5628());
        }
    }

    public static class BatSwarm {
        public static final Codec<BatSwarm> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("owner_id").forGetter(BatSwarm::getOwnerId), (App)Codec.INT.listOf().fieldOf("target_ids").forGetter(BatSwarm::getTargetIds), (App)class_243.field_38277.fieldOf("pos").forGetter(BatSwarm::getPos), (App)Codec.INT.fieldOf("age").forGetter(BatSwarm::getAge), (App)Codec.INT.fieldOf("blood").forGetter(BatSwarm::getBlood)).apply((Applicative)instance, BatSwarm::new));
        public static final int MAX_AGE = 600;
        private static final int MAX_BLOOD = 50;
        private static final int BLOOD_DRAIN_AMOUNT = 5;
        private static final int BLOOD_FILL_AMOUNT = 3;
        private static final int RANGE = 4;
        private final UUID ownerId;
        private final List<Integer> targetIds;
        private class_243 pos;
        private int age;
        private int blood;
        @Nullable
        private class_1309 owner = null;
        private class_243 velocity = class_243.field_1353;
        private int deathTicks = 0;
        private int nextSoundTimer = 1;

        private BatSwarm(UUID ownerId, List<Integer> targetIds, class_243 pos, int age, int blood) {
            this.ownerId = ownerId;
            this.targetIds = targetIds;
            this.pos = pos;
            this.age = age;
            this.blood = blood;
        }

        private void tick(class_1937 world) {
            if (this.owner == null) {
                class_1297 class_12972 = world.method_66347(this.getOwnerId());
                if (class_12972 instanceof class_1309) {
                    class_1309 living;
                    this.owner = living = (class_1309)class_12972;
                }
                if (this.owner != null && !this.targetIds.contains(this.owner.method_5628())) {
                    this.targetIds.add(this.owner.method_5628());
                }
            }
            if (this.shouldDie()) {
                ++this.deathTicks;
                return;
            }
            this.deathTicks = 0;
            ++this.age;
            if (this.age % 5 == 0) {
                boolean moveTo = false;
                for (int i = this.targetIds.size() - 1; i >= 0; --i) {
                    class_1297 target = world.method_8469(this.targetIds.get(i).intValue());
                    if (!NyctoUtil.isSurvival(target)) {
                        this.targetIds.remove(i);
                        continue;
                    }
                    if (!this.canSee(target)) continue;
                    class_1309 living = (class_1309)target;
                    if (!world.method_8608() && this.age % 20 == 0 && this.pos.method_1022(living.method_73189()) < 5.0) {
                        this.feed(living);
                    }
                    if (moveTo) continue;
                    this.setVelocity(target);
                    moveTo = true;
                }
            }
            this.pos = this.pos.method_1019(this.velocity);
            if (--this.nextSoundTimer == 0) {
                world.method_43128(null, this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), class_3417.field_15009, class_3419.field_15248, 0.15f, 1.0f);
                this.nextSoundTimer = this.owner.method_59922().method_39332(4, 12);
            }
            if (world.method_8608() && this.age < 580) {
                this.spawnParticles(world, this.owner.method_59922());
            }
        }

        private UUID getOwnerId() {
            return this.ownerId;
        }

        private List<Integer> getTargetIds() {
            return this.targetIds;
        }

        private class_243 getPos() {
            return this.pos;
        }

        private int getAge() {
            return this.age;
        }

        private int getBlood() {
            return this.blood;
        }

        private boolean canSee(class_243 pos) {
            return this.owner.method_73183().method_17742(new class_3959(this.getPos(), pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.owner)).method_17783() == class_239.class_240.field_1333;
        }

        private boolean canSee(class_1297 entity) {
            return entity != null && this.getPos().method_1022(entity.method_73189()) < 64.0 && this.canSee(entity.method_33571());
        }

        private boolean shouldDie() {
            return this.age >= 600 || this.owner == null || !this.owner.method_36608();
        }

        private void setVelocity(class_1297 target) {
            this.velocity = new class_243(target.method_23317() - this.getPos().method_10216(), target.method_23320() - this.getPos().method_10214(), target.method_23321() - this.getPos().method_10215()).method_1029().method_1021(0.2);
        }

        private void feed(class_1309 target) {
            if (target == this.owner) {
                if (this.getBlood() >= 3 && ((BloodComponent)ModEntityComponents.BLOOD.get((Object)target)).fill(3)) {
                    SLibUtils.playSound((class_1297)target, (class_3414)((class_3414)ModSoundEvents.ITEM_BLOOD_BOTTLE_DRINK.comp_349()));
                    this.blood -= 3;
                    ModWorldComponents.BAT_SWARM.sync((Object)target.method_73183());
                }
            } else {
                class_1657 player;
                class_1309 class_13092;
                boolean canDrain;
                boolean hasBlood = !target.method_5864().method_20210(ModEntityTypeTags.HAS_NO_BLOOD);
                boolean qualityBlood = target.method_5864().method_20210(ModEntityTypeTags.HAS_QUALITY_BLOOD);
                boolean bl = canDrain = hasBlood && this.getBlood() < 50;
                if (!qualityBlood && (class_13092 = this.owner) instanceof class_1657 && NyctoAPI.hasPower(player = (class_1657)class_13092, ModPowers.RICH_TASTES)) {
                    canDrain = false;
                }
                target.method_64419(target.method_48923().method_48797(ModDamageTypes.BLEED, null, (class_1297)this.owner), 1.0f);
                if (canDrain && ((BloodComponent)ModEntityComponents.BLOOD.get((Object)target)).drainAttack(5)) {
                    SLibUtils.playSound((class_1297)target, (class_3414)((class_3414)ModSoundEvents.ITEM_BLOOD_BOTTLE_DRINK.comp_349()));
                    this.blood += 5 / (qualityBlood ? 1 : 2);
                    ModWorldComponents.BAT_SWARM.sync((Object)target.method_73183());
                }
            }
        }

        private void spawnParticles(class_1937 world, class_5819 random) {
            for (int i = 0; i < 8; ++i) {
                class_243 particlePos = new class_243(this.getPos().method_10216() + (double)class_3532.method_15344((class_5819)random, (float)-4.0f, (float)4.0f), this.getPos().method_10214() + (double)class_3532.method_15344((class_5819)random, (float)-4.0f, (float)4.0f), this.getPos().method_10215() + (double)class_3532.method_15344((class_5819)random, (float)-4.0f, (float)4.0f));
                if (!this.canSee(particlePos)) continue;
                class_2400 particle = switch (random.method_43048(3)) {
                    case 0 -> ModParticleTypes.BAT_SWARM_LEFT;
                    case 1 -> ModParticleTypes.BAT_SWARM_RIGHT;
                    default -> ModParticleTypes.BAT_SWARM_CENTER;
                };
                world.method_8494((class_2394)particle, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), this.blood > 0 ? 1.0 : 0.0, 0.0, 0.0);
                for (int j = 0; j < 2; ++j) {
                    world.method_8406((class_2394)class_2398.field_11251, particlePos.method_10216() + random.method_43059() / 2.0, particlePos.method_10214() + random.method_43059() / 2.0, particlePos.method_10215() + random.method_43059() / 2.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

