/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.entity.mob;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Predicate;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.Nycto;
import moriyashiine.nycto.common.entity.ai.goal.hunter.PathToContractPosGoal;
import moriyashiine.nycto.common.entity.ai.goal.hunter.UltimateTargetGoal;
import moriyashiine.nycto.common.init.ModItems;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.superbsteeds.common.component.entity.HorseAttributesComponent;
import moriyashiine.superbsteeds.common.init.ModEntityComponents;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1383;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1498;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1604;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_4255;
import net.minecraft.class_4844;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class HunterEntity
extends class_1604 {
    public static final class_2941<HunterType> HUNTER_TYPE_TRACKED_DATA = class_2941.method_56031(HunterType.PACKET_CODEC);
    public static final class_2940<HunterType> HUNTER_TYPE = class_2945.method_12791(HunterEntity.class, HUNTER_TYPE_TRACKED_DATA);
    private UUID ultimateTarget = null;
    private class_2338 contractPos = null;
    private int contractPathTicks = 0;

    public HunterEntity(class_1299<? extends class_1604> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5942().method_70687(true);
    }

    public static class_5132.class_5133 createHunterAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23717, 92.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 4.0);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_5952(false);
        this.field_6011.method_12778(HUNTER_TYPE, (Object)view.method_71426("HunterType", HunterType.CODEC).orElse(HunterType.VAMPIRE));
        this.ultimateTarget = view.method_71426("UltimateTarget", class_4844.field_40825).orElse(null);
        this.contractPos = view.method_71426("ContractPos", class_2338.field_25064).orElse(null);
        this.contractPathTicks = view.method_71424("ContractPathTicks", 0);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("HunterType", HunterType.CODEC, (Object)((HunterType)this.field_6011.method_12789(HUNTER_TYPE)));
        if (this.ultimateTarget != null) {
            view.method_71468("UltimateTarget", class_4844.field_40825, (Object)this.ultimateTarget);
        }
        if (this.contractPos != null) {
            view.method_71468("ContractPos", class_2338.field_25064, (Object)this.contractPos);
        }
        view.method_71465("ContractPathTicks", this.contractPathTicks);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HUNTER_TYPE, (Object)HunterType.VAMPIRE);
    }

    public class_3414 method_20033() {
        return class_3417.field_19152;
    }

    public boolean method_16485() {
        return false;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        this.method_16480(false);
        this.method_16217(false);
        this.method_22332(false);
        return data;
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.equipGear(random.method_43056() ? HunterType.VAMPIRE : HunterType.WEREWOLF, false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new PathToContractPosGoal(this));
        this.field_6201.method_6277(0, (class_1352)new UltimateTargetGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(2, (class_1352)new class_1383((class_1588)this, 1.0, 16.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{class_3732.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, false, this::shouldAttack));
    }

    @Nullable
    protected class_3414 method_5994() {
        return ModSoundEvents.ENTITY_HUNTER_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.ENTITY_HUNTER_HURT;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.ENTITY_HUNTER_DEATH;
    }

    public void method_6007() {
        if (this.contractPathTicks > 0 && --this.contractPathTicks == 0) {
            this.method_5942().method_6340();
            this.setContractPos(null);
        }
        if (this.method_5968() != null) {
            boolean mainHandRanged = this.method_6047().method_7909() instanceof class_1811;
            if (this.method_5739((class_1297)this.method_5968()) < 8.0f) {
                if (mainHandRanged) {
                    this.swapHandStacks();
                }
            } else if (!mainHandRanged && !this.method_6079().method_7960()) {
                this.swapHandStacks();
            }
        }
        this.method_6119();
        super.method_6007();
    }

    public class_1543.class_1544 method_6990() {
        class_1543.class_1544 state = super.method_6990();
        if (state == class_1543.class_1544.field_7211) {
            state = class_1543.class_1544.field_21512;
        }
        return state;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_24520(Predicate<class_1799> predicate) {
        return predicate.test(this.method_6047());
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
    }

    @Nullable
    public class_1657 getUltimateTarget() {
        return this.ultimateTarget == null ? null : this.method_73183().method_18470(this.ultimateTarget);
    }

    public void setUltimateTarget(class_1657 ultimateTarget) {
        this.method_5980((class_1309)ultimateTarget);
        this.ultimateTarget = ultimateTarget.method_5667();
    }

    public void setContractPos(class_2338 contractPos) {
        this.contractPos = contractPos;
        this.contractPathTicks = 2400;
    }

    @Nullable
    public class_2338 getContractPos() {
        return this.contractPos;
    }

    public void equipGear(HunterType hunterType, boolean horse) {
        this.field_6011.method_12778(HUNTER_TYPE, (Object)hunterType);
        for (class_1304 slot : class_1304.values()) {
            this.method_5673(slot, class_1799.field_8037);
        }
        if (hunterType == HunterType.VAMPIRE) {
            this.method_5673(class_1304.field_6169, ModItems.VAMPIRE_HUNTER_HELMET.method_7854());
            this.method_5673(class_1304.field_6174, ModItems.VAMPIRE_HUNTER_CHESTPLATE.method_7854());
            this.method_5673(class_1304.field_6172, ModItems.VAMPIRE_HUNTER_LEGGINGS.method_7854());
            this.method_5673(class_1304.field_6166, ModItems.VAMPIRE_HUNTER_BOOTS.method_7854());
            if (horse) {
                this.method_5673(class_1304.field_6173, ModItems.GARLIC_COATED_HALBERD.method_7854());
            } else {
                this.method_5673(class_1304.field_6173, ModItems.WOODEN_STAKE.method_7854());
                this.method_5673(class_1304.field_6171, class_1802.field_8399.method_7854());
            }
        } else if (hunterType == HunterType.WEREWOLF) {
            this.method_5673(class_1304.field_6169, ModItems.WEREWOLF_HUNTER_HELMET.method_7854());
            this.method_5673(class_1304.field_6174, ModItems.WEREWOLF_HUNTER_CHESTPLATE.method_7854());
            this.method_5673(class_1304.field_6172, ModItems.WEREWOLF_HUNTER_LEGGINGS.method_7854());
            this.method_5673(class_1304.field_6166, ModItems.WEREWOLF_HUNTER_BOOTS.method_7854());
            if (horse) {
                this.method_5673(class_1304.field_6173, ModItems.ACONITE_COATED_HALBERD.method_7854());
            } else {
                this.method_5673(class_1304.field_6173, class_1802.field_8371.method_7854());
                this.method_5673(class_1304.field_6171, class_1802.field_8102.method_7854());
            }
        }
    }

    private boolean shouldAttack(class_1309 target, class_3218 world) {
        if (target == this.getUltimateTarget()) {
            return !NyctoAPI.hasRespawnLeniency(target);
        }
        if (NyctoAPI.isVampire((class_1297)target)) {
            return this.isHoldingItem(ModItems.WOODEN_STAKE);
        }
        return false;
    }

    private boolean isHoldingItem(class_1792 item) {
        return this.method_6047().method_31574(item) || this.method_6079().method_31574(item);
    }

    private void swapHandStacks() {
        class_1799 stack = this.method_6047().method_7972();
        this.method_6122(class_1268.field_5808, this.method_6079().method_7972());
        this.method_6122(class_1268.field_5810, stack);
    }

    public static void mountHorse(class_1309 entity) {
        class_1498 horse = (class_1498)class_1299.field_6139.method_5883(entity.method_73183(), class_3730.field_16461);
        if (horse.method_6082(entity.method_23317(), entity.method_23318(), entity.method_23321(), false)) {
            horse.method_5943((class_5425)entity.method_73183(), entity.method_73183().method_8404(entity.method_24515()), class_3730.field_16461, null);
            horse.method_66323(entity);
            horse.method_6766(true);
            entity.method_73183().method_8649((class_1297)horse);
            entity.method_5804((class_1297)horse);
            if (Nycto.superbSteedsLoaded) {
                HorseAttributesComponent horseAttributesComponent = (HorseAttributesComponent)ModEntityComponents.HORSE_ATTRIBUTES.get((Object)horse);
                while (horseAttributesComponent.getSpeed() < 5) {
                    horseAttributesComponent.incrementSpeed();
                }
                horseAttributesComponent.sync();
            } else {
                horse.method_5996(class_5134.field_23719).method_6192(0.3375);
            }
        }
    }

    public record HunterType(class_2960 texture) {
        public static final Codec<HunterType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(HunterType::texture)).apply((Applicative)instance, HunterType::new));
        public static final class_9139<class_2540, HunterType> PACKET_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267, HunterType::texture, HunterType::new);
        public static final HunterType VAMPIRE = new HunterType(Nycto.id("textures/entity/hunter/vampire.png"));
        public static final HunterType WEREWOLF = new HunterType(Nycto.id("textures/entity/hunter/werewolf.png"));

        public boolean shouldTarget(class_1309 entity) {
            if (this == VAMPIRE) {
                return NyctoAPI.isVampire((class_1297)entity);
            }
            if (this == WEREWOLF) {
                return NyctoAPI.isWerewolf((class_1297)entity);
            }
            return false;
        }
    }
}

