/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.power.vampire;

import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.HypnotizedComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.VampiricThrallComponent;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModParticleTypes;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.init.ModStatusEffects;
import moriyashiine.nycto.common.power.vampire.VampireActivePower;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1405;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2396;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4135;
import org.jetbrains.annotations.Nullable;

public class HypnotizePower
extends VampireActivePower {
    public static final int RANGE = 8;
    private static final int THRESHOLD = 25;

    public HypnotizePower() {
        super(200);
    }

    @Override
    protected int getBaseCost(class_1309 entity) {
        return entity.method_5715() ? 3 : 10;
    }

    @Override
    public class_3414 getUseSound(class_1657 player) {
        return player.method_5715() ? ModSoundEvents.POWER_HYPNOTIZE_USE_INVERSE : ModSoundEvents.POWER_HYPNOTIZE_USE;
    }

    @Override
    public void use(class_3218 world, class_3222 player) {
        world.method_8390(class_1309.class, new class_238(player.method_24515()).method_1014(10.0), entity -> entity.method_5739((class_1297)player) <= 8.0f && HypnotizePower.canUseOn((class_1657)player, entity)).forEach(entity -> {
            SLibUtils.addAnchoredParticle((class_1297)entity, (class_2396)ModParticleTypes.HYPNOTIZED, (double)entity.method_5751(), (double)0.0, (double)0.0);
            if (player.method_5715()) {
                entity.method_6016(ModStatusEffects.HYPNOTIZED);
                if (entity.method_31747()) {
                    entity.method_6016(ModStatusEffects.STUNNED);
                } else if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    HypnotizePower.forget(mob);
                    ((HypnotizedComponent)ModEntityComponents.HYPNOTIZED.get((Object)mob)).setOwner(null);
                }
            } else if (entity.method_31747()) {
                entity.method_6092(new class_1293(ModStatusEffects.HYPNOTIZED, 100));
                entity.method_6092(new class_1293(ModStatusEffects.STUNNED, 100));
            } else if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_6092(new class_1293(ModStatusEffects.HYPNOTIZED, 12000));
                HypnotizePower.forget(mob);
                ((HypnotizedComponent)ModEntityComponents.HYPNOTIZED.get((Object)mob)).setOwner((class_1657)player);
            }
        });
        ((BloodComponent)ModEntityComponents.BLOOD.get((Object)player)).drain(this.getCost((class_1309)player));
    }

    public static boolean canUseOn(class_1657 player, class_1309 target) {
        if (target.method_56992() || !target.method_36608() || target.method_5864().method_20210(ModEntityTypeTags.CANNOT_BE_HYPNOTIZED)) {
            return false;
        }
        if (target.method_31747() || ModEntityComponents.HYPNOTIZED.isProvidedBy((Object)target)) {
            @Nullable VampiricThrallComponent vampiricThrallComponent = (VampiricThrallComponent)ModEntityComponents.VAMPIRIC_THRALL.getNullable((Object)target);
            if (vampiricThrallComponent != null && vampiricThrallComponent.hasOwner()) {
                return false;
            }
            if (player.method_5715()) {
                if (target.method_31747()) {
                    return true;
                }
                @Nullable HypnotizedComponent hypnotizedComponent = (HypnotizedComponent)ModEntityComponents.HYPNOTIZED.getNullable((Object)target);
                return hypnotizedComponent != null && hypnotizedComponent.hasOwner();
            }
            return target.method_6032() <= 25.0f && SLibUtils.shouldHurt((class_1297)player, (class_1297)target);
        }
        return false;
    }

    public static void forget(class_1308 mob) {
        class_3218 serverWorld = (class_3218)mob.method_73183();
        if (mob instanceof class_1646) {
            class_1646 villager = (class_1646)mob;
            villager.method_19179(serverWorld);
        } else {
            mob.method_18868().method_18900(serverWorld, (class_1309)mob);
        }
        mob.method_5980(null);
        mob.method_6015(null);
        for (class_4135 goal : mob.field_6185.method_35115()) {
            if (!(goal.method_19058() instanceof class_1405)) continue;
            goal.method_6270();
        }
    }
}

