/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity;

import moriyashiine.nycto.common.init.ModDamageTypes;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModParticleTypes;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2396;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class BloodComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    public static final int MAX_BLOOD = 100;
    public static final int REGEN_TIME = 100;
    private final class_1309 obj;
    private boolean shouldRegenerateNaturally = true;
    private int blood = 100;
    private int bleedTicks = 0;
    private int regenerationBlockTicks = 0;
    private long lastLoadTime = -1L;

    public BloodComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.shouldRegenerateNaturally = readView.method_71433("ShouldRegenerateNaturally", true);
        this.blood = readView.method_71424("Blood", 100);
        this.bleedTicks = readView.method_71424("BleedTicks", 0);
        this.regenerationBlockTicks = readView.method_71424("RegenerationBlockTicks", 0);
        this.lastLoadTime = readView.method_71425("LastLoadTime", -1L);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("ShouldRegenerateNaturally", this.shouldRegenerateNaturally);
        writeView.method_71465("Blood", this.blood);
        writeView.method_71465("BleedTicks", this.bleedTicks);
        writeView.method_71465("RegenerationBlockTicks", this.regenerationBlockTicks);
        writeView.method_71466("LastLoadTime", this.lastLoadTime);
    }

    public void serverTick() {
        if (this.obj.method_73183().method_8510() % 20L == 0L && this.obj.method_73183().method_8407() == class_1267.field_5801) {
            this.fill(5);
        }
        if (this.bleedTicks > 0 && --this.bleedTicks % 20 == 0) {
            NyctoUtil.spawnBloodParticles((class_1297)this.obj);
            this.obj.method_64419(this.obj.method_48923().method_48795(ModDamageTypes.BLEED), 1.0f);
        }
        if (this.regenerationBlockTicks > 0) {
            --this.regenerationBlockTicks;
        }
        if (!this.shouldRegenerateNaturally) {
            return;
        }
        if (this.canFill() && this.obj.method_73183().method_8510() % 20L == 0L && this.obj.method_5805()) {
            if (this.lowBlood()) {
                this.obj.method_6092(new class_1293(class_1294.field_5909, 60, 1, true, false));
                this.obj.method_6092(new class_1293(class_1294.field_5911, 60, 0, true, false));
                if (this.criticalBlood()) {
                    SLibUtils.addParticles((class_1297)this.obj, (class_2396)ModParticleTypes.BLOOD, (int)8, (ParticleAnchor)ParticleAnchor.BODY);
                    this.obj.method_64419(this.obj.method_48923().method_48795(ModDamageTypes.BLEED), 2.0f);
                }
            }
            if (this.regenerationBlockTicks <= 0 && this.obj.method_73183().method_8510() % 100L == 0L) {
                this.fill(this.obj.method_6113() ? 5 : 1);
            }
        }
    }

    public void sync() {
        ModEntityComponents.BLOOD.sync((Object)this.obj);
    }

    public boolean shouldRegenerateNaturally() {
        return this.shouldRegenerateNaturally;
    }

    public void setShouldRegenerateNaturally(boolean shouldRegenerateNaturally) {
        this.shouldRegenerateNaturally = shouldRegenerateNaturally;
    }

    public int getBlood() {
        return this.blood;
    }

    public void setBlood(int blood) {
        this.blood = blood;
    }

    public void setBleedTicks(int bleedTicks) {
        this.bleedTicks = bleedTicks;
    }

    public int getRegenerationBlockTicks() {
        return this.regenerationBlockTicks;
    }

    public void setRegenerationBlockTicks(int regenerationBlockTicks) {
        this.regenerationBlockTicks = regenerationBlockTicks;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public void setLastLoadTime(long lastLoadTime) {
        this.lastLoadTime = lastLoadTime;
    }

    public boolean canFill() {
        return this.blood < 100;
    }

    public boolean aboveHalfBlood() {
        return this.blood > 50;
    }

    public boolean lowBlood() {
        return this.blood < 20;
    }

    public boolean criticalBlood() {
        return this.blood < 10;
    }

    public boolean fill(int amount) {
        if (this.canFill()) {
            this.blood = Math.min(100, this.blood + amount);
            this.sync();
            return true;
        }
        return false;
    }

    public boolean drainAttack(int amount) {
        if (amount == 0 || this.blood == 0 || !this.obj.method_33190()) {
            return false;
        }
        if (this.obj.method_59922().method_43057() <= 0.6666667f && NyctoUtil.hasBloodDrainResistance(this.obj)) {
            SLibUtils.playSound((class_1297)this.obj, (class_3414)ModSoundEvents.ENTITY_GENERIC_BLOOD_DRAIN_BLOCKED, (float)1.0f, (float)class_3532.method_15344((class_5819)this.obj.method_59922(), (float)0.95f, (float)1.05f));
            return false;
        }
        boolean drain = this.drain(amount, true);
        if (drain) {
            NyctoUtil.spawnBloodParticles((class_1297)this.obj);
            this.setRegenerationBlockTicks(200);
        }
        return drain;
    }

    public boolean drain(int amount) {
        return this.drain(amount, false);
    }

    private boolean drain(int amount, boolean alwaysAllow) {
        if (amount <= 0) {
            return true;
        }
        if (alwaysAllow || this.blood - amount >= 0) {
            if (this.obj.method_56992()) {
                return true;
            }
            this.blood = Math.max(0, this.blood - amount);
            this.sync();
            return true;
        }
        return false;
    }
}

