/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity;

import java.util.ArrayList;
import java.util.List;
import moriyashiine.nycto.api.init.NyctoRegistries;
import moriyashiine.nycto.api.power.ActivePower;
import moriyashiine.nycto.api.power.Power;
import moriyashiine.nycto.api.power.PowerInstance;
import moriyashiine.nycto.api.transformation.Transformation;
import moriyashiine.nycto.common.init.ModTransformations;
import moriyashiine.nycto.common.util.NyctoUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class TransformationComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private Transformation transformation = ModTransformations.HUMAN;
    private final List<PowerInstance> powers = new ArrayList<PowerInstance>();
    private int powerIndex = 0;
    private int upgradeCostSeed = 0;

    public TransformationComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.transformation = readView.method_71426("Transformation", NyctoRegistries.TRANSFORMATION.method_39673()).orElse(ModTransformations.HUMAN);
        this.powers.clear();
        this.powers.addAll(readView.method_71426("Powers", PowerInstance.CODEC.listOf()).orElse(List.of()));
        this.powerIndex = readView.method_71424("PowerIndex", 0);
        this.upgradeCostSeed = readView.method_71424("UpgradeCostSeed", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71468("Transformation", NyctoRegistries.TRANSFORMATION.method_39673(), (Object)this.transformation);
        writeView.method_71468("Powers", PowerInstance.CODEC.listOf(), this.powers);
        writeView.method_71465("PowerIndex", this.powerIndex);
        writeView.method_71465("UpgradeCostSeed", this.upgradeCostSeed);
    }

    public void tick() {
        if (this.obj.method_36608()) {
            class_1657 class_16572 = this.obj;
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                this.transformation.tick(player);
            }
            this.powers.forEach(instance -> {
                class_1657 patt0$temp = this.obj;
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    instance.getPower().tick(player);
                }
                if (instance.getCooldown() > 0) {
                    instance.setCooldown(instance.getCooldown() - 1);
                }
            });
        }
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public List<PowerInstance> getPowers() {
        return this.powers;
    }

    public void addPower(PowerInstance instance) {
        this.powers.add(instance);
        class_1657 class_16572 = this.obj;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            instance.getPower().onAdded(player);
        }
    }

    public void removePower(Power power) {
        for (int i = this.getPowers().size() - 1; i >= 0; --i) {
            if (this.powers.get(i).getPower() != power) continue;
            class_1657 class_16572 = this.obj;
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                power.onRemoved(player);
            }
            this.powers.remove(i);
        }
        this.powerIndex = 0;
    }

    public boolean hasPower(Power power) {
        for (PowerInstance powerInstance : this.powers) {
            if (powerInstance.getPower() != power) continue;
            return true;
        }
        return false;
    }

    public int getPowerIndex() {
        return this.powerIndex;
    }

    public void setPowerIndex(int powerIndex) {
        this.powerIndex = powerIndex;
    }

    public boolean hasActivePower() {
        return this.getPowers().stream().anyMatch(powerInstance -> powerInstance.getPower() instanceof ActivePower);
    }

    public int getRandomUpgradeCostIndex(List<?> list) {
        int index;
        if (this.upgradeCostSeed == 0) {
            this.upgradeCostSeed = this.obj.method_5667().hashCode() + NyctoUtil.truncatedWorldSeed;
        }
        if ((index = this.upgradeCostSeed % list.size()) < 0) {
            index += list.size();
        }
        return index;
    }

    public void updateUpgradeCostSeed() {
        this.upgradeCostSeed = class_5819.method_43049((long)this.upgradeCostSeed).method_43054();
    }
}

