/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity.power.vampire;

import java.util.stream.Collectors;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.Nycto;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.component.entity.power.util.VampireFormChangeComponent;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModEntityTypes;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.payload.DarkFormJumpPayload;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.event.PreventEquipmentUsageEvent;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_4168;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class DarkFormComponent
extends VampireFormChangeComponent
implements CommonTickingComponent {
    private static final class_1322 ARMOR_MODIFIER = new class_1322(Nycto.id("dark_form_armor"), 20.0, class_1322.class_1323.field_6328);
    private static final class_1322 ARMOR_TOUGHNESS_MODIFIER = new class_1322(Nycto.id("dark_form_armor_toughness"), 12.0, class_1322.class_1323.field_6328);
    private static final class_1322 ATTACK_DAMAGE_MODIFIER = new class_1322(Nycto.id("dark_form_attack_damage"), 12.0, class_1322.class_1323.field_6328);
    private static final class_1322 ATTACK_SPEED_MODIFIER = new class_1322(Nycto.id("dark_form_attack_speed"), -0.5, class_1322.class_1323.field_6331);
    private static final class_1322 BLOCK_INTERACTION_RANGE_MODIFIER = new class_1322(Nycto.id("dark_form_block_interaction_range"), 1.0, class_1322.class_1323.field_6328);
    private static final class_1322 ENTITY_INTERACTION_RANGE_MODIFIER = new class_1322(Nycto.id("dark_form_entity_interaction_range"), 1.0, class_1322.class_1323.field_6328);
    private static final class_1322 KNOCKBACK_RESISTANCE_MODIFIER = new class_1322(Nycto.id("dark_form_knockback_resistance"), 0.7, class_1322.class_1323.field_6328);
    private int jumpCooldown = 0;

    public DarkFormComponent(class_1657 obj) {
        super(obj);
    }

    @Override
    public void readData(class_11368 readView) {
        super.readData(readView);
        this.jumpCooldown = readView.method_71424("JumpCooldown", 0);
    }

    @Override
    public void writeData(class_11372 writeView) {
        super.writeData(writeView);
        writeView.method_71465("JumpCooldown", this.jumpCooldown);
    }

    public void tick() {
        if (this.enabled && this.obj.method_36608()) {
            if (this.obj.method_24828()) {
                this.jumpCooldown = 0;
            } else {
                if (this.jumpCooldown > 0) {
                    --this.jumpCooldown;
                }
                if (this.obj.field_6282 && this.canJump()) {
                    this.jump();
                    DarkFormJumpPayload.send();
                }
                if (this.obj.method_18798().method_10214() < 0.0 && !this.obj.method_5715()) {
                    this.obj.method_18799(this.obj.method_18798().method_18805(1.0, 0.8, 1.0));
                    this.obj.method_38785();
                    this.obj.field_6017 = 1.0;
                }
            }
        } else {
            this.jumpCooldown = 0;
        }
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.tick();
        if (this.enabled && NyctoUtil.isSurvival((class_1297)this.obj) && this.obj.field_6012 % 20 == 0) {
            this.obj.method_73183().method_8390(class_1646.class, this.obj.method_5829().method_1014(16.0), class_1309::method_5805).forEach(villager -> villager.method_18868().method_24526(class_4168.field_18599));
        }
    }

    public void sync() {
        ModEntityComponents.DARK_FORM.sync((Object)this.obj);
    }

    @Override
    public void toggle() {
        SLibUtils.addParticles((class_1297)this.obj, (class_2396)class_2398.field_11251, (int)48, (ParticleAnchor)ParticleAnchor.BODY);
        if (this.enabled) {
            SLibUtils.setModelReplacement((class_1657)this.obj, null);
            this.drainTicks = 0;
        } else {
            ((BloodComponent)ModEntityComponents.BLOOD.get((Object)this.obj)).drain(ModPowers.DARK_FORM.getCost((class_1309)this.obj));
            SLibUtils.setModelReplacement((class_1657)this.obj, ModEntityTypes.DARK_FORM);
            this.drainTicks = 300;
        }
        this.enabled = !this.enabled;
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_23724, (class_1322)this.getAdjustedModifier(ARMOR_MODIFIER), (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_23725, (class_1322)this.getAdjustedModifier(ARMOR_TOUGHNESS_MODIFIER), (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_23721, (class_1322)this.getAdjustedModifier(ATTACK_DAMAGE_MODIFIER), (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_23723, (class_1322)ATTACK_SPEED_MODIFIER, (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_47758, (class_1322)BLOCK_INTERACTION_RANGE_MODIFIER, (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_47759, (class_1322)ENTITY_INTERACTION_RANGE_MODIFIER, (boolean)this.enabled);
        SLibUtils.conditionallyApplyAttributeModifier((class_1309)this.obj, (class_6880)class_5134.field_23718, (class_1322)KNOCKBACK_RESISTANCE_MODIFIER, (boolean)this.enabled);
        PreventEquipmentUsageEvent.triggerEquipmentCheck((class_1309)this.obj);
        if (!this.enabled) {
            for (class_1799 stack : this.obj.method_31548().method_67533()) {
                class_1304 slot = this.obj.method_32326(stack);
                if (!slot.method_46643() || !this.obj.method_6118(slot).method_7960() || !this.obj.method_63623(stack, slot)) continue;
                this.obj.method_5673(slot, stack.method_51164());
            }
        }
        this.sync();
    }

    public void jump() {
        this.jumpCooldown = 20;
        this.obj.method_6043();
        this.obj.method_18799(this.obj.method_18798().method_18805(1.3, 1.1, 1.3));
        SLibUtils.playSound((class_1297)this.obj, (class_3414)ModSoundEvents.ENTITY_DARK_FORM_FLAP);
    }

    public boolean canJump() {
        if (this.obj.method_31549().field_7479 || this.obj.method_5799() || this.obj.method_5681()) {
            return false;
        }
        return this.jumpCooldown == 0 && !this.obj.method_6128() && this.obj.method_5854() == null && !this.obj.method_6101();
    }

    private class_1322 getAdjustedModifier(class_1322 modifier) {
        int negativePowers = NyctoAPI.getPowers(this.obj).stream().filter(instance -> instance.getPower().isNegative()).collect(Collectors.toSet()).size();
        float multiplier = switch (negativePowers) {
            case 0 -> 0.5f;
            case 1 -> 0.7f;
            case 2 -> 0.85f;
            default -> 1.0f;
        };
        return new class_1322(modifier.comp_2447(), modifier.comp_2449() * (double)multiplier, modifier.comp_2450());
    }
}

