/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.event.entity;

import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.init.ModEntityComponents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BloodEvent {

    public static class Copy
    implements ServerPlayerEvents.CopyFrom {
        public void copyFromPlayer(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
            BloodComponent newBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)newPlayer);
            BloodComponent oldBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)oldPlayer);
            newBloodComponent.setShouldRegenerateNaturally(oldBloodComponent.shouldRegenerateNaturally());
            newBloodComponent.setBlood(100);
            newBloodComponent.sync();
        }
    }

    public static class Unload
    implements ServerEntityEvents.Unload {
        public void onUnload(class_1297 entity, class_3218 world) {
            ModEntityComponents.BLOOD.maybeGet((Object)entity).ifPresent(bloodComponent -> bloodComponent.setLastLoadTime(world.method_8510()));
        }
    }

    public static class Load
    implements ServerEntityEvents.Load {
        public void onLoad(class_1297 entity, class_3218 world) {
            ModEntityComponents.BLOOD.maybeGet((Object)entity).ifPresent(bloodComponent -> {
                if (bloodComponent.getLastLoadTime() > 0L) {
                    long difference = world.method_8510() - bloodComponent.getLastLoadTime();
                    bloodComponent.setLastLoadTime(world.method_8510());
                    if (!NyctoAPI.isVampire(entity)) {
                        if (bloodComponent.getRegenerationBlockTicks() > 0) {
                            bloodComponent.setRegenerationBlockTicks((int)Math.max(0L, (long)bloodComponent.getRegenerationBlockTicks() - difference));
                        }
                        bloodComponent.fill((int)(difference / 100L));
                    }
                }
            });
        }
    }
}

