/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.api;

import java.util.HashSet;
import java.util.List;
import moriyashiine.nycto.api.power.Power;
import moriyashiine.nycto.api.power.PowerInstance;
import moriyashiine.nycto.api.transformation.Transformation;
import moriyashiine.nycto.client.payload.ModifyPowerPayload;
import moriyashiine.nycto.client.payload.SetPowerCooldownPayload;
import moriyashiine.nycto.client.payload.SetTransformationPayload;
import moriyashiine.nycto.common.NyctoAPIImpl;
import moriyashiine.nycto.common.component.entity.HealBlockComponent;
import moriyashiine.nycto.common.component.entity.RespawnLeniencyComponent;
import moriyashiine.nycto.common.component.entity.TransformationComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.HaemogenesisComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.VampiricThrallComponent;
import moriyashiine.nycto.common.init.ModCriteria;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.init.ModTransformations;
import moriyashiine.nycto.common.power.vampire.DarkFormPower;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class NyctoAPI {
    public static Transformation getTransformation(class_1657 player) {
        return ((TransformationComponent)ModEntityComponents.TRANSFORMATION.get((Object)player)).getTransformation();
    }

    public static void setTransformation(class_3222 player, Transformation transformation) {
        NyctoAPI.getTransformation((class_1657)player).onRemoved(player);
        NyctoAPIImpl.setTransformation((class_1657)player, transformation);
        transformation.onAdded(player);
        SetTransformationPayload.send(player, (class_1297)player, transformation);
        PlayerLookup.tracking((class_1297)player).forEach(receiver -> SetTransformationPayload.send(receiver, (class_1297)player, transformation));
        ModCriteria.CHANGE_TRANSFORMATION.method_9141(player);
    }

    public static void addPower(class_3222 player, Power power) {
        Transformation transformation = NyctoAPI.getTransformation((class_1657)player);
        transformation.applyModifiers(player, false);
        NyctoAPIImpl.addPower((class_1657)player, power);
        transformation.applyModifiers(player, true);
        ModifyPowerPayload.send(player, (class_1297)player, power, true);
        PlayerLookup.tracking((class_1297)player).forEach(receiver -> ModifyPowerPayload.send(receiver, (class_1297)player, power, true));
        ModCriteria.CHANGE_POWERS.method_9141(player);
    }

    public static void removePower(class_3222 player, Power power) {
        Transformation transformation = NyctoAPI.getTransformation((class_1657)player);
        transformation.applyModifiers(player, false);
        NyctoAPIImpl.removePower((class_1657)player, power);
        transformation.applyModifiers(player, true);
        ModifyPowerPayload.send(player, (class_1297)player, power, false);
        PlayerLookup.tracking((class_1297)player).forEach(receiver -> ModifyPowerPayload.send(receiver, (class_1297)player, power, false));
        ModCriteria.CHANGE_POWERS.method_9141(player);
    }

    public static List<PowerInstance> getPowers(class_1657 player) {
        return ((TransformationComponent)ModEntityComponents.TRANSFORMATION.get((Object)player)).getPowers();
    }

    public static boolean hasPower(class_1657 player, Power power) {
        return ((TransformationComponent)ModEntityComponents.TRANSFORMATION.get((Object)player)).hasPower(power);
    }

    public static void setPowerCooldown(class_3222 player, Power power, int cooldown) {
        NyctoAPIImpl.setPowerCooldown((class_1657)player, power, cooldown);
        SetPowerCooldownPayload.send(player, power, cooldown);
    }

    public static void applyHealBlock(class_1309 entity, int ticks, @Nullable class_1297 lifeStealer) {
        @Nullable HaemogenesisComponent haemogenesisComponent = (HaemogenesisComponent)ModEntityComponents.HAEMOGENESIS.getNullable((Object)entity);
        if (haemogenesisComponent == null || !haemogenesisComponent.isHealing()) {
            if (NyctoUtil.hasHealBlockResistance(entity)) {
                ticks = (int)((float)(ticks * 2) / 3.0f);
            }
            HealBlockComponent healBlockComponent = (HealBlockComponent)ModEntityComponents.HEAL_BLOCK.get((Object)entity);
            healBlockComponent.setTicksToBlock(ticks);
            healBlockComponent.setLifeStealer(lifeStealer);
            healBlockComponent.sync();
        }
    }

    public static void applyHealBlock(class_1309 entity, int ticks) {
        NyctoAPI.applyHealBlock(entity, ticks, null);
    }

    public static boolean isWerewolf(class_1297 entity) {
        return NyctoAPIImpl.isPlayerWerewolf(entity);
    }

    public static boolean isVampire(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        @Nullable VampiricThrallComponent vampiricThrallComponent = (VampiricThrallComponent)ModEntityComponents.VAMPIRIC_THRALL.getNullable((Object)entity);
        if (vampiricThrallComponent != null && vampiricThrallComponent.hasOwner()) {
            return true;
        }
        return entity.method_5864().method_20210(ModEntityTypeTags.VAMPIRES) || NyctoAPIImpl.isPlayerVampire(entity);
    }

    public static boolean isBeastForm(class_1282 source) {
        return NyctoAPI.isBeastForm(source.method_5526());
    }

    public static boolean isBeastForm(class_1297 entity) {
        return DarkFormPower.isDarkFormActive(entity);
    }

    public static boolean hasRespawnLeniency(class_1309 entity) {
        @Nullable RespawnLeniencyComponent respawnLeniencyComponent = (RespawnLeniencyComponent)ModEntityComponents.RESPAWN_LENIENCY.getNullable((Object)entity);
        return respawnLeniencyComponent != null && respawnLeniencyComponent.hasLeniency();
    }

    public static void giveRespawnLeniency(class_1309 entity) {
        @Nullable RespawnLeniencyComponent respawnLeniencyComponent = (RespawnLeniencyComponent)ModEntityComponents.RESPAWN_LENIENCY.getNullable((Object)entity);
        if (respawnLeniencyComponent != null) {
            respawnLeniencyComponent.giveLeniency();
        }
    }

    public static void partiallyCureTransformation(class_3222 player, class_6862<Power> tagKey) {
        List<PowerInstance> powers = NyctoAPI.getPowers((class_1657)player);
        HashSet<Power> toRemove = new HashSet<Power>();
        boolean foundNegative = false;
        for (int i = powers.size() - 1; i >= 0; --i) {
            PowerInstance instance = powers.get(i);
            if (!instance.getPower().isIn(tagKey)) continue;
            toRemove.add(instance.getPower());
            if (foundNegative) break;
            if (!instance.getPower().isNegative()) continue;
            foundNegative = true;
        }
        toRemove.forEach(power -> NyctoAPI.removePower(player, power));
        SLibUtils.addParticles((class_1297)player, (class_2396)class_2398.field_11251, (int)16, (ParticleAnchor)ParticleAnchor.BODY);
        if (toRemove.isEmpty()) {
            SLibUtils.playAnchoredSound((class_1297)player, (class_3414)ModSoundEvents.ENTITY_GENERIC_TRANSFORM_HUMAN);
            NyctoAPI.setTransformation(player, ModTransformations.HUMAN);
        } else {
            SLibUtils.playAnchoredSound((class_1297)player, (class_3414)ModSoundEvents.ENTITY_GENERIC_REMOVE_POWER);
        }
    }
}

