/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.api.screenhandler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.api.init.NyctoRegistries;
import moriyashiine.nycto.api.power.Power;
import moriyashiine.nycto.api.power.PowerInstance;
import moriyashiine.nycto.common.component.entity.TransformationComponent;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModSoundEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public abstract class AltarScreenHandler
extends class_1703 {
    public final List<Power> selectablePowers = new ArrayList<Power>();
    public final List<Power> playerPowers = new ArrayList<Power>();
    private final class_1263 inventory = new class_1277(2){

        public void method_5431() {
            super.method_5431();
            AltarScreenHandler.this.method_7609((class_1263)this);
        }
    };
    protected final class_3914 context;
    public class_1799 itemCost;

    public AltarScreenHandler(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context, class_6862<Power> allowedPowers) {
        super(type, syncId);
        this.context = context;
        this.method_7621(new class_1735(this.inventory, 0, 122, 94){

            public boolean method_7680(class_1799 stack) {
                return class_1799.method_7984((class_1799)stack, (class_1799)AltarScreenHandler.this.itemCost);
            }
        });
        this.method_7621(new class_1735(this.inventory, 1, 142, 94){

            public boolean method_7680(class_1799 stack) {
                return AltarScreenHandler.this.isStackValidForSecondSlot(stack);
            }
        });
        this.method_61624((class_1263)playerInventory, 8, 141);
        for (Power power : NyctoRegistries.POWER) {
            if (!power.isIn(allowedPowers) || NyctoAPI.hasPower(playerInventory.field_7546, power)) continue;
            this.selectablePowers.add(power);
        }
        for (PowerInstance instance : NyctoAPI.getPowers(playerInventory.field_7546)) {
            if (!instance.getPower().isIn(allowedPowers)) continue;
            this.playerPowers.add(instance.getPower());
        }
        this.sort(this.selectablePowers);
        this.sort(this.playerPowers);
        this.itemCost = this.refreshItemCost(playerInventory.field_7546);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            stack = stackInSlot.method_7972();
            if (slotIndex == 0 || slotIndex == 1) {
                if (!this.method_7616(stackInSlot, 2, 38, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(0).method_7680(stackInSlot)) {
                if (!this.method_7616(stackInSlot, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(1).method_7680(stackInSlot)) {
                if (!this.method_7616(stackInSlot, 1, 2, false)) {
                    return class_1799.field_8037;
                }
            } else if (!((class_1735)this.field_7761.getFirst()).method_7681() && ((class_1735)this.field_7761.getFirst()).method_7680(stackInSlot)) {
                ((class_1735)this.field_7761.getFirst()).method_53512(stackInSlot.method_7971(1));
            } else {
                return class_1799.field_8037;
            }
            if (stackInSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return stack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7604(class_1657 player, int id) {
        if (this.canUpgrade(player)) {
            AltarScreenHandler.apply(player, id);
            this.context.method_17393((world, pos) -> {
                if (!player.method_68878()) {
                    player.method_7316(-this.getExpCost());
                    this.inventory.method_5438(0).method_7934(this.getMaterialCost());
                    this.inventory.method_5438(1).method_7934(this.getMaterialCost());
                }
                this.method_7607(player, this.inventory);
                this.inventory.method_5431();
                this.method_7609(this.inventory);
                world.method_8396(null, pos, ModSoundEvents.BLOCK_ALTAR_USE, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
            });
            return true;
        }
        return false;
    }

    public abstract int getMaterialCost();

    public abstract int getExpCost();

    protected abstract class_1799 refreshItemCost(class_1657 var1);

    protected abstract boolean isStackValidForSecondSlot(class_1799 var1);

    public boolean canUpgrade(class_1657 player) {
        if (player.method_68878()) {
            return true;
        }
        return player.field_7520 >= this.getExpCost() && this.inventory.method_5438(0).method_7947() >= this.getMaterialCost() && this.inventory.method_5438(1).method_7947() >= this.getMaterialCost();
    }

    public int getPositivePowers() {
        return this.playerPowers.stream().filter(power -> !power.isNegative()).collect(Collectors.toSet()).size();
    }

    public void sort(List<Power> powers) {
        if (powers == this.selectablePowers) {
            powers.sort(Comparator.comparing(p -> ((class_5321)p.getEntry().method_40230().orElseThrow()).method_29177()));
        }
        powers.sort(Comparator.comparing(Power::isNegative));
    }

    public static void apply(class_1657 player, int rawId) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof AltarScreenHandler) {
            AltarScreenHandler handler = (AltarScreenHandler)class_17032;
            for (int i = handler.selectablePowers.size() - 1; i >= 0; --i) {
                Power power = handler.selectablePowers.get(i);
                if (NyctoRegistries.POWER.method_10206((Object)power) != rawId) continue;
                handler.selectablePowers.remove(i);
                handler.playerPowers.add(power);
                handler.sort(handler.playerPowers);
                ((TransformationComponent)ModEntityComponents.TRANSFORMATION.get((Object)player)).updateUpgradeCostSeed();
                handler.itemCost = handler.refreshItemCost(player);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    NyctoAPI.addPower(serverPlayer, power);
                }
                return;
            }
        }
    }
}

