/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity.power.vampire;

import moriyashiine.nycto.client.payload.AddBloodBarrierParticlesPayload;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class BloodBarrierComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private static final int MAX_BARRIERS = 3;
    private static final int MAX_TICKS = 300;
    private final class_1309 obj;
    private int barriers = 0;
    private int ticks = 0;

    public BloodBarrierComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.barriers = readView.method_71424("Barriers", 0);
        this.ticks = readView.method_71424("Ticks", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71465("Barriers", this.barriers);
        writeView.method_71465("Ticks", this.ticks);
    }

    public void tick() {
        if (this.ticks > 0 && --this.ticks == 0) {
            if (!this.obj.method_73183().method_8608()) {
                for (int i = 0; i < this.barriers; ++i) {
                    this.addParticles(i);
                }
            }
            this.barriers = 0;
        }
    }

    public void sync() {
        ModEntityComponents.BLOOD_BARRIER.sync((Object)this.obj);
    }

    public int getBarriers() {
        return this.barriers;
    }

    public void breakBarrier() {
        SLibUtils.playSound((class_1297)this.obj, (class_3414)ModSoundEvents.POWER_BLOOD_BARRIER_BREAK, (float)1.0f, (float)class_3532.method_15344((class_5819)this.obj.method_59922(), (float)0.8f, (float)1.2f));
        --this.barriers;
        this.addParticles(this.barriers);
        if (this.barriers == 0) {
            this.ticks = 0;
        }
        this.sync();
    }

    public void use() {
        for (int i = 0; i < 3; ++i) {
            this.addParticles(i);
        }
        this.barriers = 3;
        this.ticks = 300;
        this.sync();
    }

    private void addParticles(int barrier) {
        PlayerLookup.tracking((class_1297)this.obj).forEach(receiver -> AddBloodBarrierParticlesPayload.send(receiver, (class_1297)this.obj, barrier));
        class_1309 class_13092 = this.obj;
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            AddBloodBarrierParticlesPayload.send(player, (class_1297)this.obj, barrier);
        }
    }

    public static float getHeightOffset(int barrier, float height) {
        return switch (barrier) {
            case 0 -> height * 0.5f;
            case 1 -> height * 0.2f;
            default -> height * 0.8f;
        };
    }
}

