/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.entity.mob;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.api.init.NyctoRegistries;
import moriyashiine.nycto.api.power.Power;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.entity.ai.goal.vampire.BatSwarmGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.BatstepGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.BloodBarrierGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.BloodFlechettesGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.CarnageGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.HaemogenesisGoal;
import moriyashiine.nycto.common.entity.ai.goal.vampire.VampireEscapeSunlightGoal;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModGameRules;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import moriyashiine.nycto.common.transformation.VampireTransformation;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class VampireEntity
extends class_1588 {
    public static final class_2940<Boolean> ATTACKING = class_2945.method_12791(VampireEntity.class, (class_2941)class_2943.field_13323);
    private static final int ABILITY_COOLDOWN = 40;
    private static final Object2IntMap<Power> USABLE_POWERS = new Object2IntArrayMap(Map.of(ModPowers.BATSTEP, 160, ModPowers.BAT_SWARM, 400, ModPowers.BLOOD_BARRIER, 300, ModPowers.BLOOD_FLECHETTES, 120, ModPowers.CARNAGE, 300, ModPowers.HAEMOGENESIS, 200));
    private final Set<UsablePower> usablePowers = new HashSet<UsablePower>();
    private int abilityCooldown = 0;

    public VampireEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createVampireAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23721, 6.0);
    }

    public static boolean canSpawn(class_1299<VampireEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return class_1588.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && world.method_30273() == 4 && world.method_8410().method_64395().method_8355(ModGameRules.DO_VAMPIRE_SPAWNING);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.usablePowers.clear();
        this.usablePowers.addAll(view.method_71426("UsablePowers", UsablePower.CODEC.listOf()).orElse(List.of()));
        this.field_6011.method_12778(ATTACKING, (Object)view.method_71433("Attacking", false));
        this.abilityCooldown = view.method_71424("AbilityCooldown", 0);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("UsablePowers", UsablePower.CODEC.listOf(), new ArrayList<UsablePower>(this.usablePowers));
        view.method_71472("Attacking", ((Boolean)this.field_6011.method_12789(ATTACKING)).booleanValue());
        view.method_71465("AbilityCooldown", this.abilityCooldown);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACKING, (Object)false);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData);
        VampireTransformation.setComponents((class_1309)this, true);
        ArrayList selectablePowers = new ArrayList(USABLE_POWERS.keySet());
        for (int i = 0; i < 3; ++i) {
            Power selectablePower = (Power)selectablePowers.remove(this.method_59922().method_43048(selectablePowers.size()));
            this.usablePowers.add(new UsablePower(selectablePower, USABLE_POWERS.getInt((Object)selectablePower), 0));
        }
        return data;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new VampireEscapeSunlightGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BloodBarrierGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HaemogenesisGoal(this));
        this.field_6201.method_6277(3, (class_1352)new CarnageGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BatstepGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BatSwarmGoal(this));
        this.field_6201.method_6277(5, (class_1352)new BloodFlechettesGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1309.class, false, (target, world) -> !target.method_31747() && target.method_5864().method_20210(ModEntityTypeTags.HAS_QUALITY_BLOOD) && !NyctoAPI.isVampire((class_1297)target)));
    }

    @Nullable
    protected class_3414 method_5994() {
        return ModSoundEvents.ENTITY_VAMPIRE_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.ENTITY_VAMPIRE_HURT;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.ENTITY_VAMPIRE_DEATH;
    }

    public void method_5773() {
        super.method_5773();
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        this.usablePowers.forEach(usablePower -> {
            if (usablePower.cooldown > 0) {
                --usablePower.cooldown;
            }
        });
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        this.field_6011.method_12778(ATTACKING, (Object)(target != null ? 1 : 0));
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        boolean attacked = super.method_6121(world, target);
        if (attacked) {
            int amount;
            BloodComponent selfBloodComponent;
            BloodComponent targetBloodComponent;
            this.method_6104(class_1268.field_5808);
            if (target.method_5864().method_20210(ModEntityTypeTags.HAS_QUALITY_BLOOD) && (targetBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.getNullable((Object)target)) != null && (selfBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)this)).canFill() && targetBloodComponent.drainAttack(amount = Math.min(5, targetBloodComponent.getBlood()))) {
                selfBloodComponent.fill(amount);
                SLibUtils.playSound((class_1297)target, (class_3414)((class_3414)ModSoundEvents.ITEM_BLOOD_BOTTLE_DRINK.comp_349()));
            }
        }
        return attacked;
    }

    public boolean method_5974(double distanceSquared) {
        return super.method_5974(distanceSquared) && !this.method_73183().method_23886();
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_73183().method_23886();
    }

    public boolean canUsePower(Power power) {
        if (this.abilityCooldown == 0 && !((BloodComponent)ModEntityComponents.BLOOD.get((Object)this)).lowBlood()) {
            for (UsablePower usablePower : this.usablePowers) {
                if (usablePower.power != power) continue;
                return usablePower.cooldown == 0;
            }
        }
        return false;
    }

    public void useAbility(Power power) {
        this.abilityCooldown = 40;
        this.method_6104(class_1268.field_5808);
        for (UsablePower usablePower : this.usablePowers) {
            if (usablePower.power != power) continue;
            usablePower.cooldown = usablePower.maxCooldown;
        }
    }

    public static class UsablePower {
        private static final Codec<UsablePower> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NyctoRegistries.POWER.method_39673().fieldOf("power").forGetter(UsablePower::getPower), (App)Codec.INT.fieldOf("max_cooldown").forGetter(UsablePower::getMaxCooldown), (App)Codec.INT.fieldOf("cooldown").forGetter(UsablePower::getCooldown)).apply((Applicative)instance, UsablePower::new));
        private final Power power;
        private final int maxCooldown;
        private int cooldown;

        public UsablePower(Power power, int maxCooldown, int cooldown) {
            this.power = power;
            this.maxCooldown = maxCooldown;
            this.cooldown = cooldown;
        }

        private Power getPower() {
            return this.power;
        }

        private int getMaxCooldown() {
            return this.maxCooldown;
        }

        private int getCooldown() {
            return this.cooldown;
        }
    }
}

