/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.transformation;

import java.util.stream.Collectors;
import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.api.misc.AttributeModifierSet;
import moriyashiine.nycto.api.misc.PowerHotbarTextureSet;
import moriyashiine.nycto.api.transformation.Transformation;
import moriyashiine.nycto.common.Nycto;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.component.entity.SunExposureComponent;
import moriyashiine.nycto.common.component.entity.VampireChargeJumpComponent;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.tag.ModPowerTags;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class VampireTransformation
extends Transformation {
    public static final class_1322 STEP_HEIGHT_MODIFIER = new class_1322(Nycto.id("vampire_bonus"), 1.0, class_1322.class_1323.field_6328);
    public static final float VAMPIRE_EXHAUSTION_MULTIPLIER = 3.25f;
    private static final PowerHotbarTextureSet POWER_HOTBAR_TEXTURE_SET = new PowerHotbarTextureSet(Nycto.id("hud/power_hotbar/vampire/hotbar"), Nycto.id("hud/power_hotbar/vampire/selection"), Nycto.id("hud/power_hotbar/vampire/hotbar_overlay"), Nycto.id("hud/power_hotbar/vampire/selection_overlay"));

    @Override
    public void onAdded(class_3222 player) {
        super.onAdded(player);
        NyctoAPI.addPower(player, ModPowers.NIGHT_VISION);
        VampireTransformation.setComponents((class_1309)player, true);
        VampireChargeJumpComponent vampireChargeJumpComponent = (VampireChargeJumpComponent)ModEntityComponents.VAMPIRE_CHARGE_JUMP.get((Object)player);
        vampireChargeJumpComponent.setEnabled(true);
        vampireChargeJumpComponent.sync();
    }

    @Override
    public void onRemoved(class_3222 player) {
        super.onRemoved(player);
        VampireTransformation.setComponents((class_1309)player, false);
        VampireChargeJumpComponent vampireChargeJumpComponent = (VampireChargeJumpComponent)ModEntityComponents.VAMPIRE_CHARGE_JUMP.get((Object)player);
        vampireChargeJumpComponent.setEnabled(false);
        vampireChargeJumpComponent.sync();
    }

    @Override
    public void tick(class_3222 player) {
        if (player.method_51469().method_8510() % 6000L == 0L) {
            player.method_7266(class_3468.field_15419.method_14956((Object)class_3468.field_15429));
        }
    }

    @Override
    public AttributeModifierSet getAttributeModifiers(class_3222 player) {
        AttributeModifierSet attributeModifierSet = super.getAttributeModifiers(player);
        int negativePowers = NyctoAPI.getPowers((class_1657)player).stream().filter(instance -> instance.getPower().isIn(ModPowerTags.VAMPIRE_CHOOSABLE) && instance.getPower().isNegative()).collect(Collectors.toSet()).size();
        attributeModifierSet.addModifier((class_6880<class_1320>)class_5134.field_23721, new class_1322(Nycto.id("vampire_bonus"), 1.0 + 0.6666666666666666 * (double)negativePowers, class_1322.class_1323.field_6328));
        attributeModifierSet.addModifier((class_6880<class_1320>)class_5134.field_23719, new class_1322(Nycto.id("vampire_bonus"), 0.15 + 0.1 * (double)negativePowers, class_1322.class_1323.field_6331));
        attributeModifierSet.addModifier((class_6880<class_1320>)class_5134.field_23728, new class_1322(Nycto.id("vampire_bonus"), 0.06 * (double)negativePowers, class_1322.class_1323.field_6328));
        attributeModifierSet.addModifier((class_6880<class_1320>)class_5134.field_49079, new class_1322(Nycto.id("vampire_bonus"), (double)(1 + negativePowers), class_1322.class_1323.field_6328));
        return attributeModifierSet;
    }

    @Override
    public PowerHotbarTextureSet getPowerHotbarTextureSet() {
        return POWER_HOTBAR_TEXTURE_SET;
    }

    public static void setComponents(class_1309 living, boolean vampire) {
        NyctoAPI.giveRespawnLeniency(living);
        ((BloodComponent)ModEntityComponents.BLOOD.get((Object)living)).setShouldRegenerateNaturally(!vampire);
        SunExposureComponent sunExposureComponent = (SunExposureComponent)ModEntityComponents.SUN_EXPOSURE.get((Object)living);
        sunExposureComponent.setShouldTick(vampire);
        sunExposureComponent.reset();
        sunExposureComponent.sync();
    }
}

