/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.event.entity;

import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.component.entity.BloodComponent;
import moriyashiine.nycto.common.component.entity.VampireChargeJumpComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.MistFormComponent;
import moriyashiine.nycto.common.component.entity.power.vampire.VampiricThrallComponent;
import moriyashiine.nycto.common.init.ModDamageTypes;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModParticleTypes;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.init.ModSoundEvents;
import moriyashiine.nycto.common.init.ModStatusEffects;
import moriyashiine.nycto.common.tag.ModBlockTags;
import moriyashiine.nycto.common.tag.ModEntityTypeTags;
import moriyashiine.nycto.common.tag.ModItemTags;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.event.AfterDamageIncludingDeathEvent;
import moriyashiine.strawberrylib.api.event.EatFoodEvent;
import moriyashiine.strawberrylib.api.event.ModifyMovementEvents;
import moriyashiine.strawberrylib.api.event.TickEntityEvent;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4139;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class VampireEvent {

    public static class TickHarming
    implements TickEntityEvent {
        public void tick(class_3218 world, class_1297 entity) {
            if (entity.field_6012 % 10 == 0 && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (living.field_6235 == 0 && living.method_33190() && !NyctoAPI.hasRespawnLeniency(living)) {
                    int count = 0;
                    for (class_1304 slot : class_1304.values()) {
                        if (!living.method_6118(slot).method_31573(ModItemTags.HURTS_VAMPIRES)) continue;
                        ++count;
                    }
                    if (count > 0 && NyctoUtil.affectedByHurtsVampiresTag((class_1297)living)) {
                        NyctoUtil.damageWithToxicTouch(living, count);
                    }
                }
            }
        }
    }

    public static class BreakHarming
    implements PlayerBlockBreakEvents.After {
        public void afterBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
            if (state.method_26164(ModBlockTags.HURTS_VAMPIRES) && !player.method_6047().method_31573(ConventionalItemTags.SHEAR_TOOLS) && NyctoUtil.affectedByHurtsVampiresTag((class_1297)player)) {
                NyctoUtil.damageWithToxicTouch((class_1309)player, player.method_6063() / 5.0f);
            }
        }
    }

    public static class WeaknessItem
    implements AfterDamageIncludingDeathEvent {
        public void afterDamage(class_1309 entity, class_1282 source, float baseDamageTaken, float damageTaken, boolean blocked) {
            if (!blocked && NyctoAPI.isVampire((class_1297)entity) && NyctoUtil.isVampireWeaknessItem(source)) {
                SLibUtils.playSound((class_1297)entity, (class_3414)class_3417.field_15016);
                SLibUtils.addEmitterParticle((class_1297)entity, (class_2396)class_2398.field_11208);
            }
        }
    }

    public static class HealBlock
    implements ServerLivingEntityEvents.AfterDamage {
        public void afterDamage(class_1309 entity, class_1282 source, float baseDamageTaken, float damageTaken, boolean blocked) {
            if (!blocked && NyctoAPI.isVampire((class_1297)entity) && NyctoUtil.haltsVampireRegeneration(source)) {
                NyctoAPI.applyHealBlock(entity, NyctoUtil.isVampireWeaknessItem(source) ? 60 : 100);
            }
        }
    }

    public static class FreezeImmunity
    implements ServerLivingEntityEvents.AllowDamage {
        public boolean allowDamage(class_1309 entity, class_1282 source, float amount) {
            return !source.method_48789(class_8103.field_42252) || !NyctoAPI.isVampire((class_1297)entity);
        }
    }

    public static class EatFood
    implements EatFoodEvent {
        public void eat(class_1937 world, class_1309 entity, class_1799 food, class_4174 foodComponent) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (NyctoAPI.isVampire((class_1297)entity) && !food.method_31573(ModItemTags.SAFE_EDIBLES)) {
                    entity.method_6092(new class_1293(class_1294.field_5903, 200, 2));
                    entity.method_6092(new class_1293(class_1294.field_5916, 200, 1));
                    entity.method_6092(new class_1293(class_1294.field_5920, 200, 1));
                    entity.method_6092(new class_1293(class_1294.field_5911, 200, 1));
                    if (food.method_31573(ModItemTags.HURTS_VAMPIRES)) {
                        entity.method_64397(serverWorld, world.method_48963().method_48795(ModDamageTypes.TOXIC_TOUCH), Float.MAX_VALUE);
                    }
                }
            }
        }
    }

    public static class DrinkBlood
    implements UseEntityCallback {
        public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
            if (hand == class_1268.field_5808 && player.method_5715() && player.method_36608() && player.method_5998(hand).method_7960() && !entity.method_5864().method_20210(ModEntityTypeTags.HAS_NO_BLOOD) && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (living.field_6235 == 0 && living.method_5805() && !living.method_56992() && NyctoAPI.isVampire((class_1297)player)) {
                    boolean qualityBlood = entity.method_5864().method_20210(ModEntityTypeTags.HAS_QUALITY_BLOOD);
                    if (!qualityBlood && NyctoAPI.hasPower(player, ModPowers.RICH_TASTES)) {
                        return class_1269.field_5811;
                    }
                    @Nullable VampiricThrallComponent vampiricThrallComponent = (VampiricThrallComponent)ModEntityComponents.VAMPIRIC_THRALL.getNullable((Object)entity);
                    if (vampiricThrallComponent != null && vampiricThrallComponent.isOwner((class_1297)player)) {
                        return class_1269.field_5811;
                    }
                    BloodComponent playerBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)player);
                    BloodComponent livingBloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)living);
                    int fillAmount = (qualityBlood ? 5 : 1) + (NyctoUtil.getsMoreBlood((class_1309)player) ? 2 : 0);
                    int drainAmount = qualityBlood ? 10 : 25;
                    double armorMultiplier = DrinkBlood.getArmorMultiplier(living);
                    fillAmount = class_3532.method_15384((double)((double)fillAmount * armorMultiplier));
                    drainAmount = class_3532.method_15384((double)((double)drainAmount * armorMultiplier));
                    if (fillAmount > 0 && playerBloodComponent.canFill() && livingBloodComponent.getBlood() > 0) {
                        if (world instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)world;
                            player.method_23667(class_1268.field_5808, true);
                            if (DrinkBlood.canSafelyDrain(player, living, livingBloodComponent, drainAmount)) {
                                living.field_6254 = 10;
                                living.field_6235 = 10;
                                if (NyctoUtil.isVillager((class_1297)living)) {
                                    NyctoUtil.notifyNearbyVillagers(living, player, class_4139.field_18425, 10);
                                }
                            } else {
                                living.method_64397(serverWorld, world.method_48963().method_48796(ModDamageTypes.BLEED, (class_1297)player), 2.0f);
                            }
                            if (livingBloodComponent.drainAttack(drainAmount)) {
                                SLibUtils.playSound((class_1297)entity, (class_3414)((class_3414)ModSoundEvents.ITEM_BLOOD_BOTTLE_DRINK.comp_349()));
                                fillAmount = DrinkBlood.getModifiedFillAmount(fillAmount, qualityBlood, living.method_59922());
                                if (fillAmount > 0) {
                                    playerBloodComponent.fill(fillAmount);
                                }
                            }
                        }
                        return class_1269.field_21466;
                    }
                }
            }
            return class_1269.field_5811;
        }

        public static double getArmorMultiplier(class_1309 living) {
            return Math.max(0.3333333432674408, class_3532.method_16436((double)((double)living.method_6096() / ((class_1329)class_5134.field_23724.comp_349()).method_35062()), (double)1.0, (double)0.0));
        }

        private static int getModifiedFillAmount(int fillAmount, boolean qualityBlood, class_5819 random) {
            if (!qualityBlood && (fillAmount /= 2) == 0 && random.method_43056()) {
                fillAmount = 1;
            }
            return fillAmount;
        }

        private static boolean canSafelyDrain(class_1657 attacker, class_1309 target, BloodComponent targetBloodComponent, int toDrain) {
            if (target.method_6059(ModStatusEffects.HYPNOTIZED)) {
                return targetBloodComponent.getBlood() - toDrain > 0;
            }
            if (targetBloodComponent.aboveHalfBlood()) {
                return target.method_6113() || ((MistFormComponent)ModEntityComponents.MIST_FORM.get((Object)attacker)).isEnabled();
            }
            return false;
        }
    }

    public static class ChargeJump
    implements ModifyMovementEvents.JumpVelocity {
        public class_243 modify(class_243 velocity, class_1309 entity) {
            float boostProgress;
            class_1657 player;
            if (entity instanceof class_1657 && NyctoAPI.isVampire((class_1297)(player = (class_1657)entity)) && (boostProgress = ((VampireChargeJumpComponent)ModEntityComponents.VAMPIRE_CHARGE_JUMP.get((Object)entity)).getBoostProgress()) > 0.0f) {
                class_1937 class_19372;
                if (boostProgress > 0.25f && (class_19372 = entity.method_73183()) instanceof class_3218) {
                    class_3218 world = (class_3218)class_19372;
                    world.method_65096((class_2394)ModParticleTypes.BLOOD, entity.method_23317(), entity.method_23318() + (double)entity.method_17682() * 0.5, entity.method_23321(), 8, (double)(entity.method_17681() / 2.0f), 0.0, (double)(entity.method_17681() / 2.0f), 0.15);
                    SLibUtils.playSound((class_1297)entity, (class_3414)class_3417.field_14560, (float)1.0f, (float)0.75f);
                    entity.method_32876((class_6880)class_5712.field_45148);
                }
                return velocity.method_1031(0.0, (double)(boostProgress * 0.34f), 0.0);
            }
            return velocity;
        }
    }

    public static class BloodVeil
    implements ServerLivingEntityEvents.AllowDeath {
        public boolean allowDeath(class_1309 entity, class_1282 damageSource, float damageAmount) {
            BloodComponent bloodComponent;
            if (entity.method_6032() - damageAmount <= 0.0f && NyctoAPI.isVampire((class_1297)entity) && !NyctoUtil.bypassesBloodVeil(damageSource) && !BloodVeil.hasThinBlood(entity) && (bloodComponent = (BloodComponent)ModEntityComponents.BLOOD.get((Object)entity)).drain(class_3532.method_15357((double)((double)damageAmount * DrinkBlood.getArmorMultiplier(entity))))) {
                NyctoAPI.applyHealBlock(entity, 60);
                entity.method_6033(1.0f);
                return false;
            }
            return true;
        }

        private static boolean hasThinBlood(class_1309 living) {
            class_1657 player;
            return living instanceof class_1657 && NyctoAPI.hasPower(player = (class_1657)living, ModPowers.THIN_BLOOD);
        }
    }
}

