/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.nycto.common.component.entity;

import moriyashiine.nycto.api.NyctoAPI;
import moriyashiine.nycto.common.init.ModEntityComponents;
import moriyashiine.nycto.common.init.ModPowers;
import moriyashiine.nycto.common.tag.ModBlockTags;
import moriyashiine.nycto.common.util.NyctoUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SunExposureComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final int MAX_EXPOSURE_TIME = 320;
    private final class_1309 obj;
    private boolean shouldTick;
    private boolean exposed = false;
    private int exposureTime = 0;

    public SunExposureComponent(class_1309 obj, boolean shouldTick) {
        this.obj = obj;
        this.shouldTick = shouldTick;
    }

    public void readData(class_11368 readView) {
        this.shouldTick = readView.method_71433("ShouldTick", false);
        this.exposed = readView.method_71433("Exposed", false);
        this.exposureTime = readView.method_71424("ExposureTime", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("ShouldTick", this.shouldTick);
        writeView.method_71472("Exposed", this.exposed);
        writeView.method_71465("ExposureTime", this.exposureTime);
    }

    public void tick() {
        if (this.shouldTick) {
            if (this.exposed) {
                if (this.exposureTime < 320) {
                    this.exposureTime = Math.min(320, this.exposureTime + this.getExposureTicks());
                } else {
                    this.obj.method_5639(4.0f);
                }
            } else if (this.exposureTime > 0) {
                this.exposureTime = Math.max(0, this.exposureTime - 8);
            }
        }
    }

    public void serverTick() {
        boolean isExposed;
        this.tick();
        if (this.shouldTick && this.exposed != (isExposed = this.updateExposed())) {
            this.exposed = isExposed;
            this.sync();
        }
    }

    public void clientTick() {
        this.tick();
        if (this.exposureTime > 0 && this.exposureTime % 8 == 0) {
            SLibClientUtils.addParticles((class_1297)this.obj, (class_2396)class_2398.field_11251, (int)1, (ParticleAnchor)ParticleAnchor.BODY);
        }
    }

    public void sync() {
        ModEntityComponents.SUN_EXPOSURE.sync((Object)this.obj);
    }

    public void reset() {
        this.exposed = false;
        this.exposureTime = 0;
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public void setShouldTick(boolean shouldTick) {
        this.shouldTick = shouldTick;
    }

    public boolean isExposed() {
        return this.exposed;
    }

    public int getExposureTime() {
        return this.exposureTime;
    }

    private int getExposureTicks() {
        class_1657 player;
        int ticks;
        class_1309 class_13092 = this.obj;
        int n = ticks = class_13092 instanceof class_1657 && NyctoAPI.hasPower(player = (class_1657)class_13092, ModPowers.PHOTOPHOBIA) ? 16 : 2;
        if (NyctoUtil.hasSunResistance(this.obj)) {
            ticks /= 2;
        }
        return ticks;
    }

    private boolean updateExposed() {
        if (NyctoAPI.hasRespawnLeniency(this.obj) || !this.obj.method_73183().method_8530() || !this.obj.method_33190() || this.obj.method_5778()) {
            return false;
        }
        if (this.obj.method_18398().isPresent() && this.obj.method_73183().method_8320((class_2338)this.obj.method_18398().get()).method_26164(ModBlockTags.COFFINS)) {
            return false;
        }
        return SunExposureComponent.exposedAtPos((class_1297)this.obj, this.obj.method_24515());
    }

    public static boolean exposedAtPos(class_1297 entity, class_2338 pos) {
        for (int i = class_3532.method_15386((float)entity.method_17682()) - 1; i >= 0; --i) {
            if (!entity.method_73183().method_8311(pos.method_10086(i))) continue;
            return true;
        }
        return false;
    }
}

