/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client;

import net.jitl.client.render.world.BoilRenderInfo;
import net.jitl.client.render.world.CloudiaRenderInfo;
import net.jitl.client.render.world.CorbaRenderInfo;
import net.jitl.client.render.world.DepthsRenderInfo;
import net.jitl.client.render.world.EucaRenderInfo;
import net.jitl.client.render.world.FrozenRenderInfo;
import net.jitl.client.render.world.TerraniaRenderInfo;
import net.jitl.client.render.world.clouds.JCloudRenderer;
import net.jitl.client.util.ClientGetter;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.JITL;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="jitl", value={Dist.CLIENT})
public class ClientEventHandler {
    public static void regToBus(IEventBus forgeBus) {
        forgeBus.addListener(ClientEventHandler::onFogDensityEvent);
    }

    @SubscribeEvent
    public static void addReload(AddClientReloadListenersEvent event) {
        event.addListener(JITL.rl("clouds"), (PreparableReloadListener)new JCloudRenderer());
    }

    public static void onFogDensityEvent(ViewportEvent.RenderFog event) {
        float density;
        float farPlaneDistance = event.getFarPlaneDistance();
        Player player = ClientGetter.player();
        if (ClientGetter.level().dimension() == Dimensions.CLOUDIA) {
            density = 0.35f;
            event.setNearPlaneDistance(density);
            event.setFarPlaneDistance(density * farPlaneDistance);
        }
        if (ClientGetter.level().dimension() == Dimensions.DEPTHS) {
            density = 0.85f;
            event.setNearPlaneDistance(density);
            event.setFarPlaneDistance(density * farPlaneDistance);
        }
    }

    @SubscribeEvent
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(Dimensions.EUCA_EFFECTS, (DimensionSpecialEffects)new EucaRenderInfo());
        event.register(Dimensions.DEPTHS_EFFECTS, (DimensionSpecialEffects)new DepthsRenderInfo());
        event.register(Dimensions.BOIL_EFFECTS, (DimensionSpecialEffects)new BoilRenderInfo());
        event.register(Dimensions.FROZEN_EFFECTS, (DimensionSpecialEffects)new FrozenRenderInfo());
        event.register(Dimensions.CORBA_EFFECTS, (DimensionSpecialEffects)new CorbaRenderInfo());
        event.register(Dimensions.TERRANIA_EFFECTS, (DimensionSpecialEffects)new TerraniaRenderInfo());
        event.register(Dimensions.CLOUDIA_EFFECTS, (DimensionSpecialEffects)new CloudiaRenderInfo());
    }
}

