/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client;

import java.io.IOException;
import java.net.SocketException;
import net.jitl.client.util.ChatUtils;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.helper.InternetHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="jitl", value={Dist.CLIENT})
public class ClientLoginChecker {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (((Boolean)JClientConfig.UPDATE_MESSAGE.get()).booleanValue() && !player.level().isClientSide()) {
            ChatUtils.sendColouredMessage(player, ChatFormatting.GOLD, "[|---------------------------------------------------|]");
            ChatUtils.sendColouredMessage(player, ChatFormatting.GOLD, "[Journey Into the Light]");
            ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.LIGHT_PURPLE, "jitl.message.thank_you", player.getDisplayName());
            ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.BLUE, "jitl.message.current_version", "2.2.6");
            try {
                if (!InternetHandler.isOnline()) {
                    MutableComponent msg = Component.translatable((String)"jitl.message.no_internet");
                    msg.withStyle(ChatFormatting.RED);
                    player.displayClientMessage((Component)msg, false);
                }
                try {
                    if (InternetHandler.isUpdateAvailable() && InternetHandler.isOnline()) {
                        ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.GREEN, "jitl.message.update_available", InternetHandler.getUpdateVersion());
                    }
                    if (!InternetHandler.isUpdateAvailable() && InternetHandler.isOnline()) {
                        ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.AQUA, "jitl.message.up_to_date", new Object[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
            ChatUtils.sendColouredMessage(player, ChatFormatting.GOLD, "[|---------------------------------------------------|]");
        }
    }
}

