/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.ClientPlayerStats;
import net.jitl.client.util.GuiHelper;
import net.jitl.core.helper.internal.ArgbColor;
import net.jitl.core.helper.internal.EmptyContainer;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class PlayerStats
extends AbstractContainerScreen<EmptyContainer> {
    private PageButton nextButton;
    private PageButton previousButton;
    private final ResourceLocation KNOWLEDGE_SPRITE = JITL.rl("textures/gui/knowledge/knowledge_sprites.png");
    private final ResourceLocation BACKGROUND = JITL.rl("textures/gui/stats.png");
    public int pageNumber = 0;
    public Player player;

    public PlayerStats(Player player) {
        super((AbstractContainerMenu)new EmptyContainer(), player.getInventory(), (Component)Component.translatable((String)"jitl.stats"));
        this.imageWidth = 242;
        this.imageHeight = 197;
        this.player = player;
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.updateButtonVisibility();
        graphics.drawString(this.font, "COINS" + ClientPlayerStats.getSentacoins(), this.leftPos, this.height, ArgbColor.from(ChatFormatting.WHITE));
    }

    protected void init() {
        super.init();
        int w = (this.width - this.imageWidth) / 2;
        int h = (this.height - this.imageHeight) / 2;
        int xPos = w + 95;
        int yPos = h + 177;
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(xPos + 32, yPos, true, button -> this.flipPage(true), true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(xPos, yPos, false, button -> this.flipPage(false), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.nextButton.visible = true;
        this.previousButton.visible = true;
        this.nextButton.active = this.pageNumber != 1;
        this.previousButton.active = this.pageNumber != 0;
    }

    protected void flipPage(boolean forward) {
        this.pageNumber = forward ? ++this.pageNumber : --this.pageNumber;
        this.updateButtonVisibility();
    }

    protected void renderBg(@NotNull GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.BACKGROUND).getTextureView());
        poseStack.blit(RenderPipelines.GUI_TEXTURED, this.BACKGROUND, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        switch (this.pageNumber) {
            case 0: {
                this.page1(poseStack);
                break;
            }
            case 1: {
                this.page2(poseStack);
                break;
            }
        }
    }

    public void page1(GuiGraphics stack) {
        int height = 43;
        int x = 9;
        int h = 9;
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.OVERWORLD, "Overworld");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.NETHER, "The Nether");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.END, "End");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.BOIL, "Boiling Point");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.FROZEN, "Frozen Lands");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.EUCA, "Euca");
        this.drawKnowledgeSprite(stack, 126, h += height, EnumKnowledge.DEPTHS, "The Depths");
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.CORBA, "Corba");
    }

    public void page2(GuiGraphics stack) {
        int height = 43;
        int x = 9;
        int h = 9;
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.TERRANIA, "Terrania");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.CLOUDIA, "Cloudia");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.SENTERIAN, "Senterian");
        this.drawSprite(stack, 126, h, 0, 74, "Sentacoins:");
    }

    public void drawSprite(GuiGraphics matrixStack, int x, int y, int spriteX, int spriteY, String s) {
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.BACKGROUND).getTextureView());
        GuiHelper.drawTexture(matrixStack, this.BACKGROUND, k + x - 4, l + y - 4, 0, 216, 115, 40, 256, 256);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.KNOWLEDGE_SPRITE).getTextureView());
        GuiHelper.drawTexture(matrixStack, this.KNOWLEDGE_SPRITE, k + x, l + y, spriteX, spriteY, 32, 32, 256, 256);
        GuiHelper.drawString(matrixStack, s, k + x + 35, l + y + 5, -12566464, false);
        if (s.contains("Sentacoins")) {
            GuiHelper.drawString(matrixStack, "x" + ClientPlayerStats.getSentacoins(), k + x + 35, l + y + 15, -333333, true);
        }
    }

    public void drawKnowledgeSprite(GuiGraphics matrixStack, int x, int y, EnumKnowledge type, String s) {
        matrixStack.pose().pushMatrix();
        this.drawSprite(matrixStack, x, y, type.getSpriteX(), type.getSpriteY(), s);
        int progressBarSize = 65;
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.KNOWLEDGE_SPRITE).getTextureView());
        if (this.player != null) {
            net.jitl.common.capability.stats.PlayerStats knowledge = (net.jitl.common.capability.stats.PlayerStats)this.player.getData(JDataAttachments.PLAYER_STATS);
            boolean completed = knowledge.isCompleted(type);
            float percents = knowledge.getXP(type) / knowledge.getLevelCapacity(knowledge.getLevel(type));
            int width = (int)(percents * (float)progressBarSize);
            int progressBarX = k + x + 35;
            int progressBarY = l + y + 19;
            GuiHelper.drawTexture(matrixStack, this.KNOWLEDGE_SPRITE, progressBarX, progressBarY, 0, 5, progressBarSize, 5, 256, 256);
            GuiHelper.drawTexture(matrixStack, this.KNOWLEDGE_SPRITE, progressBarX, progressBarY, 0, 0, width, 5, 256, 256);
            if (completed) {
                GuiHelper.drawTexture(matrixStack, this.KNOWLEDGE_SPRITE, k + x, l + y + 3, 130, 43, 32, 29, 256, 256);
            }
            int lvX = progressBarX + 29;
            int lvY = progressBarY - 1;
            int getLevelCount = knowledge.getLevel(type);
            String level = "" + getLevelCount;
            GuiHelper.drawString(matrixStack, "" + getLevelCount, lvX - this.font.width(level) / 2 + 4, lvY, -333333, true);
            matrixStack.pose().popMatrix();
        }
    }

    protected void containerTick() {
        super.containerTick();
        this.nextButton.active = this.pageNumber < 1;
        this.previousButton.active = this.pageNumber > 0;
    }

    protected void renderLabels(@NotNull GuiGraphics matrixStack, int x, int y) {
    }
}

