/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.util.Mth;

public class ShiverwolfModel
extends EntityModel<WolfRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private static final String REAL_HEAD = "real_head";
    private static final String UPPER_BODY = "upper_body";
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;
    private static final int LEG_SIZE = 8;

    public ShiverwolfModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.realHead = this.head.getChild(REAL_HEAD);
        this.body = root.getChild("body");
        this.upperBody = root.getChild(UPPER_BODY);
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
        this.realTail = this.tail.getChild(REAL_TAIL);
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.addOrReplaceChild(REAL_HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(UPPER_BODY, CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild(REAL_TAIL, CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        return meshdefinition;
    }

    public void setupAnim(WolfRenderState p_365164_) {
        super.setupAnim((Object)p_365164_);
        float f = p_365164_.walkAnimationPos;
        float f1 = p_365164_.walkAnimationSpeed;
        this.tail.yRot = p_365164_.isAngry ? 0.0f : Mth.cos((float)(f * 0.6662f)) * 1.4f * f1;
        if (p_365164_.isSitting) {
            float f2 = p_365164_.ageScale;
            ModelPart var10000 = this.upperBody;
            var10000.y += 2.0f * f2;
            this.upperBody.xRot = 1.2566371f;
            this.upperBody.yRot = 0.0f;
            var10000 = this.body;
            var10000.y += 4.0f * f2;
            var10000 = this.body;
            var10000.z -= 2.0f * f2;
            this.body.xRot = 0.7853982f;
            var10000 = this.tail;
            var10000.y += 9.0f * f2;
            var10000 = this.tail;
            var10000.z -= 2.0f * f2;
            var10000 = this.rightHindLeg;
            var10000.y += 6.7f * f2;
            var10000 = this.rightHindLeg;
            var10000.z -= 5.0f * f2;
            this.rightHindLeg.xRot = 4.712389f;
            var10000 = this.leftHindLeg;
            var10000.y += 6.7f * f2;
            var10000 = this.leftHindLeg;
            var10000.z -= 5.0f * f2;
            this.leftHindLeg.xRot = 4.712389f;
            this.rightFrontLeg.xRot = 5.811947f;
            var10000 = this.rightFrontLeg;
            var10000.x += 0.01f * f2;
            var10000 = this.rightFrontLeg;
            var10000.y += 1.0f * f2;
            this.leftFrontLeg.xRot = 5.811947f;
            var10000 = this.leftFrontLeg;
            var10000.x -= 0.01f * f2;
            var10000 = this.leftFrontLeg;
            var10000.y += 1.0f * f2;
        } else {
            this.rightHindLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * f1;
            this.leftHindLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * f1;
            this.rightFrontLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * f1;
            this.leftFrontLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * f1;
        }
        this.realHead.zRot = p_365164_.headRollAngle + p_365164_.getBodyRollAngle(0.0f);
        this.upperBody.zRot = p_365164_.getBodyRollAngle(-0.08f);
        this.body.zRot = p_365164_.getBodyRollAngle(-0.16f);
        this.realTail.zRot = p_365164_.getBodyRollAngle(-0.2f);
        this.head.xRot = p_365164_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_365164_.yRot * ((float)Math.PI / 180);
        this.tail.xRot = p_365164_.tailAngle;
    }
}

