/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.entity.frozen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jitl.client.render.entity.frozen.state.ShiveringRamState;
import net.jitl.common.entity.frozen.ShiveringRam;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ShiveringRamRenderer<T extends ShiveringRamState>
extends GeoEntityRenderer<ShiveringRam, T> {
    public ShiveringRamRenderer(EntityRendererProvider.Context renderManager, DefaultedEntityGeoModel<ShiveringRam> modelProvider) {
        super(renderManager, modelProvider);
        this.shadowRadius = 0.5f;
    }

    public void preRender(T renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        float size = 1.1f;
        if (((ShiveringRamState)((Object)renderState)).isBaby) {
            size = 0.5f;
        }
        poseStack.scale(size, size, size);
        super.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
    }

    public T createRenderState(ShiveringRam animatable, Void relatedObject) {
        return (T)((Object)new ShiveringRamState());
    }

    public void extractRenderState(ShiveringRam entity, T entityRenderState, float partialTick) {
        super.extractRenderState((Entity)entity, entityRenderState, partialTick);
        ((ShiveringRamState)((Object)entityRenderState)).isSheared = entity.isSheared();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        String name = ((ShiveringRamState)((Object)entity)).isSheared ? "shivering_ram" : "shivering_ram_wool";
        return ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)("textures/entity/frozen/" + name + ".png"));
    }
}

