/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jitl.client.render.item.state.SentacoinRenderState;
import net.jitl.common.entity.misc.Sentacoin;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class SentacoinRender<T extends Sentacoin>
extends EntityRenderer<T, SentacoinRenderState> {
    private final ItemModelResolver renderEntity;
    private final Sentacoin.Type type;

    public SentacoinRender(EntityRendererProvider.Context context, Sentacoin.Type type) {
        super(context);
        this.type = type;
        this.shadowRadius = 0.07f;
        this.shadowStrength = 0.75f;
        this.renderEntity = context.getItemModelResolver();
    }

    public void submit(SentacoinRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        this.renderItem(renderState, new double[]{0.5, 1.25, 0.5}, poseStack, nodeCollector);
    }

    private void renderItem(SentacoinRenderState state, double[] translation, PoseStack matrixStack, SubmitNodeCollector collector) {
        ItemStackRenderState item = state.item;
        if (!item.isEmpty()) {
            matrixStack.pushPose();
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) / 16.0f;
            matrixStack.translate(translation[0], translation[1], translation[2]);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(timeD));
            matrixStack.scale(state.scale, state.scale, state.scale);
            item.submit(matrixStack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            matrixStack.popPose();
        }
    }

    @NotNull
    public SentacoinRenderState createRenderState() {
        return new SentacoinRenderState();
    }

    public void extractRenderState(@NotNull T entity, @NotNull SentacoinRenderState item, float f) {
        super.extractRenderState(entity, (EntityRenderState)item, f);
        ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
        ItemStack stack = new ItemStack((ItemLike)JItems.SENTACOIN.get());
        item.scale = 0.55f;
        switch (this.type) {
            case COIN: {
                stack = new ItemStack((ItemLike)JItems.SENTACOIN.get());
                break;
            }
            case BAG: {
                stack = new ItemStack((ItemLike)JItems.SENTACOIN_BAG.get());
                item.scale = 1.0f;
            }
        }
        this.renderEntity.updateForTopItem(itemstackrenderstate, stack, ItemDisplayContext.GROUND, entity.level(), null, item.seed);
    }
}

