/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.jitl.client.render.projectile.state.JThrownItemRenderState;
import net.jitl.common.entity.projectile.PiercerEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class PiercerRenderer<T extends PiercerEntity>
extends EntityRenderer<T, JThrownItemRenderState> {
    private final ItemModelResolver renderEntity;
    private final Random random = new Random();

    public PiercerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.renderEntity = context.getItemModelResolver();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    public void submit(JThrownItemRenderState entityIn, PoseStack matrixStackIn, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        matrixStackIn.pushPose();
        ItemStack itemstack = entityIn.item;
        int i = itemstack.isEmpty() ? 187 : Item.getId((Item)itemstack.getItem()) + itemstack.getDamageValue();
        this.random.setSeed(i);
        float f1 = (entityIn.tick + entityIn.partialTick) / 10.0f * ((float)Math.PI * 2);
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)entityIn.partialTick, (float)entityIn.yRot, (float)entityIn.yRot) - 90.0f));
        matrixStackIn.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)entityIn.partialTick, (float)entityIn.xRot, (float)entityIn.xRot) + 90.0f));
        if (!entityIn.inGround) {
            matrixStackIn.mulPose((Quaternionfc)Axis.ZP.rotation(f1));
        }
        ItemStackRenderState item = entityIn.renderState;
        float scale = 1.0f;
        matrixStackIn.scale(scale, scale, scale);
        item.submit(matrixStackIn, nodeCollector, entityIn.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        matrixStackIn.popPose();
    }

    public void extractRenderState(T e, JThrownItemRenderState s, float f) {
        super.extractRenderState(e, (EntityRenderState)s, f);
        s.tick = ((PiercerEntity)((Object)e)).tickCount;
        s.xRot = ((PiercerEntity)((Object)e)).xRotO;
        s.yRot = ((PiercerEntity)((Object)e)).yRotO;
        s.level = e.level();
        s.inGround = e.isInGround();
        s.id = e.getId();
        ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
        this.renderEntity.updateForTopItem(itemstackrenderstate, ((PiercerEntity)((Object)e)).getItem(), ItemDisplayContext.GROUND, e.level(), null, (int)e.blockPosition().asLong());
        s.item = ((PiercerEntity)((Object)e)).getItem();
        s.renderState = itemstackrenderstate;
    }

    @NotNull
    public JThrownItemRenderState createRenderState() {
        return new JThrownItemRenderState();
    }
}

