/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.stats;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.ClientPlayerStats;
import net.jitl.core.init.JITL;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketPlayerStats(boolean hasBlizzard, int sentacoins, float knowledgeXP, int level, EnumKnowledge knowledge) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketPlayerStats> TYPE = new CustomPacketPayload.Type(JITL.rl("player_stats"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayerStats> STREAM_CODEC = CustomPacketPayload.codec(PacketPlayerStats::write, PacketPlayerStats::decode);

    public static PacketPlayerStats decode(FriendlyByteBuf buffer) {
        return new PacketPlayerStats(buffer.readBoolean(), buffer.readInt(), buffer.readFloat(), buffer.readInt(), (EnumKnowledge)buffer.readEnum(EnumKnowledge.class));
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.hasBlizzard);
        buf.writeInt(this.sentacoins);
        buf.writeFloat(this.knowledgeXP);
        buf.writeInt(this.level);
        buf.writeEnum((Enum)this.knowledge);
    }

    public static void handle(PacketPlayerStats payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientPlayerStats.setHasBlizzard(payload.hasBlizzard);
            ClientPlayerStats.setSentacoins(payload.sentacoins);
            ClientPlayerStats.setClientKnowledgeLevel(payload.knowledge, payload.level);
            ClientPlayerStats.setClientKnowledgeXP(payload.knowledge, payload.knowledgeXP);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

