/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JChestBlock
extends AbstractChestBlock<JChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<JChestBlock> CODEC = JChestBlock.simpleCodec(JChestBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape NORTHAABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTHAABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WESTAABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EASTAABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final BooleanProperty IS_LOCKED = BlockStateProperties.LOCKED;
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>> CHESTCOMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>>(){

        @NotNull
        public Optional<Container> acceptDouble(JChestBlockEntity j, JChestBlockEntity j1) {
            return Optional.of(new CompoundContainer((Container)j, (Container)j1));
        }

        @NotNull
        public Optional<Container> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>>(){

        @NotNull
        public Optional<MenuProvider> acceptDouble(final @NotNull JChestBlockEntity JChestBlockEntity3, final @NotNull JChestBlockEntity JChestBlockEntity4) {
            CompoundContainer container = new CompoundContainer((Container)JChestBlockEntity3, (Container)JChestBlockEntity4);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player1) {
                    if (JChestBlockEntity3.canOpen(player1) && JChestBlockEntity4.canOpen(player1)) {
                        JChestBlockEntity3.unpackLootTable(inventory.player);
                        JChestBlockEntity4.unpackLootTable(inventory.player);
                        return ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                @NotNull
                public Component getDisplayName() {
                    if (JChestBlockEntity3.hasCustomName()) {
                        return JChestBlockEntity3.getDisplayName();
                    }
                    return JChestBlockEntity4.hasCustomName() ? JChestBlockEntity4.getDisplayName() : Component.translatable((String)"container.chestDouble");
                }
            });
        }

        @NotNull
        public Optional<MenuProvider> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public JChestBlock(BlockBehaviour.Properties props) {
        super(props, () -> JBlockEntities.JCHEST.get());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state1) {
        ChestType chesttype = (ChestType)state1.getValue(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    protected BlockState updateShape(BlockState p_51555_, LevelReader p_374487_, ScheduledTickAccess p_374060_, BlockPos p_51559_, Direction p_51556_, BlockPos p_51560_, BlockState p_51557_, RandomSource p_374212_) {
        if (((Boolean)p_51555_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374060_.scheduleTick(p_51559_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374487_));
        }
        if (p_51557_.is((Block)this) && p_51556_.getAxis().isHorizontal()) {
            ChestType chesttype = (ChestType)p_51557_.getValue(TYPE);
            if (p_51555_.getValue(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && p_51555_.getValue(FACING) == p_51557_.getValue(FACING) && JChestBlock.getConnectedDirection(p_51557_) == p_51556_.getOpposite()) {
                return (BlockState)p_51555_.setValue(TYPE, (Comparable)chesttype.getOpposite());
            }
        } else if (JChestBlock.getConnectedDirection(p_51555_) == p_51556_) {
            return (BlockState)p_51555_.setValue(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.updateShape(p_51555_, p_374487_, p_374060_, p_51559_, p_51556_, p_51560_, p_51557_, p_374212_);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.getValue(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        return switch (JChestBlock.getConnectedDirection(state)) {
            case Direction.NORTH -> NORTHAABB;
            case Direction.SOUTH -> SOUTHAABB;
            case Direction.WEST -> WESTAABB;
            case Direction.EAST -> EASTAABB;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(JChestBlock.getConnectedDirection(state)));
        };
    }

    public static Direction getConnectedDirection(BlockState state2) {
        Direction direction = (Direction)state2.getValue(FACING);
        return state2.getValue(TYPE) == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = context.isSecondaryUseActive();
        Direction direction1 = context.getClickedFace();
        if (direction1.getAxis().isHorizontal() && flag && (direction2 = this.candidatePartnerFacing(context, direction1.getOpposite())) != null && direction2.getAxis() != direction1.getAxis()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.getCounterClockWise() == direction1.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(context, direction.getClockWise())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(context, direction.getCounterClockWise())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction)).setValue(TYPE, (Comparable)chesttype)).setValue((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        return blockstate.is((Block)this) && blockstate.getValue(TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue(FACING) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ServerLevel serverlevel;
        MenuProvider menuprovider;
        if (level instanceof ServerLevel && (menuprovider = this.getMenuProvider(state, (Level)(serverlevel = (ServerLevel)level), pos)) != null && (!((Boolean)state.getValue((Property)IS_LOCKED)).booleanValue() || player.isCreative())) {
            player.openMenu(menuprovider);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    @Nullable
    public static Container getContainer(JChestBlock chest, BlockState state, Level level, BlockPos pos, boolean override) {
        return ((Optional)chest.combine(state, level, pos, override).apply(CHESTCOMBINER)).orElse(null);
    }

    protected MapCodec<? extends AbstractChestBlock<JChestBlockEntity>> codec() {
        return CODEC;
    }

    @NotNull
    public DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> combine(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, boolean override) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = override ? (world, pos2) -> false : JChestBlock::isJChestBlockedAt;
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)this.blockEntityType.get()), JChestBlock::getBlockType, JChestBlock::getConnectedDirection, FACING, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, bipredicate);
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lid) {
        return new DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction>(){

            @NotNull
            public Float2FloatFunction acceptDouble(@NotNull JChestBlockEntity JChestBlockEntity8, @NotNull JChestBlockEntity JChestBlockEntity9) {
                return tickDelta -> Math.max(JChestBlockEntity8.getOpenNess(tickDelta), JChestBlockEntity9.getOpenNess(tickDelta));
            }

            @NotNull
            public Float2FloatFunction acceptSingle(@NotNull JChestBlockEntity JChestBlockEntity10) {
                return JChestBlockEntity10::getOpenNess;
            }

            @NotNull
            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lid).getOpenNess(arg_0);
            }
        };
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new JChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? JChestBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)this.blockEntityType.get()), JChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isJChestBlockedAt(LevelAccessor level1, BlockPos pos1) {
        return JChestBlock.isBlockedChestByBlock((BlockGetter)level1, pos1) || JChestBlock.isCatSittingOnChest(level1, pos1);
    }

    private static boolean isBlockedChestByBlock(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return level.getBlockState(blockpos).isRedstoneConductor(level, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Cat.class, new AABB((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)JChestBlock.getContainer(this, state, level, pos, false));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        BlockState rotated = state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
        return mirror == Mirror.NONE ? rotated : (BlockState)rotated.setValue(TYPE, (Comparable)((ChestType)rotated.getValue(TYPE)).getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED, IS_LOCKED});
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof JChestBlockEntity) {
            ((JChestBlockEntity)blockentity).recheckOpen();
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)IS_LOCKED) != false ? 1000000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public float getDestroyProgress(BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)IS_LOCKED) != false ? 0.0f : super.getDestroyProgress(state, player, level, pos);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }
}

