/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JDirtPathBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public JDirtPathBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    public boolean useShapeForLightOcclusion(BlockState p_153159_) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext b) {
        return !this.defaultBlockState().canSurvive((LevelReader)b.getLevel(), b.getClickedPos()) ? Block.pushEntitiesUp((BlockState)this.defaultBlockState(), (BlockState)this.getDirt().defaultBlockState(), (LevelAccessor)b.getLevel(), (BlockPos)b.getClickedPos()) : super.getStateForPlacement(b);
    }

    private Block getDirt() {
        Block dirt = (Block)JBlocks.PERMAFROST_ROAD.get();
        if (this == JBlocks.PERMAFROST_ROAD.get()) {
            dirt = (Block)JBlocks.CRUMBLED_PERMAFROST.get();
        }
        if (this == JBlocks.CORBA_PATH.get()) {
            dirt = (Block)JBlocks.CORBA_DIRT.get();
        }
        if (this == JBlocks.GOLDITE_PATH.get()) {
            dirt = (Block)JBlocks.GOLDITE_DIRT.get();
        }
        if (this == JBlocks.DEPTHS_PATH.get()) {
            dirt = (Block)JBlocks.DEPTHS_DIRT.get();
        }
        return dirt;
    }

    public BlockState updateShape(BlockState stateIn, LevelReader reader, ScheduledTickAccess tick, BlockPos currentPos, Direction dir, BlockPos facingPos, BlockState state, RandomSource source) {
        if (dir == Direction.UP && !stateIn.canSurvive(reader, currentPos)) {
            tick.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, reader, tick, currentPos, dir, facingPos, state, source);
    }

    public void tick(BlockState s, ServerLevel l, BlockPos p, RandomSource r) {
        l.setBlockAndUpdate(p, JDirtPathBlock.pushEntitiesUp((BlockState)s, (BlockState)this.getDirt().defaultBlockState(), (LevelAccessor)l, (BlockPos)p));
    }

    public boolean canSurvive(BlockState s, LevelReader l, BlockPos p) {
        BlockState blockstate = l.getBlockState(p.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock;
    }

    public VoxelShape getShape(BlockState s, BlockGetter b, BlockPos p, CollisionContext c) {
        return SHAPE;
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }
}

