/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import net.jitl.common.block.SummoningTableBlock;
import net.jitl.common.block.entity.container.SummoningTableContainer;
import net.jitl.core.helper.EnumSummoningRecipes;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningTableTile
extends RandomizableContainerBlockEntity
implements MenuProvider,
Nameable {
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);

    public SummoningTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SummoningTableTile entity) {
        for (EnumSummoningRecipes summoningRecipes : EnumSummoningRecipes.values()) {
            entity.checkRecipeAndSummon(entity, summoningRecipes, state, level, pos);
        }
        if (entity.startedSummon()) {
            active_state = (BlockState)state.setValue((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.TRUE);
            level.setBlock(pos, active_state, 2);
        } else {
            active_state = (BlockState)((BlockState)state.setValue((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.FALSE)).setValue((Property)SummoningTableBlock.SUMMON, (Comparable)Boolean.FALSE);
            level.setBlock(pos, active_state, 2);
        }
    }

    public void checkRecipeAndSummon(SummoningTableTile entity, EnumSummoningRecipes recipe, BlockState state, Level level, BlockPos pos) {
        if (entity.areItemsInSlots(recipe.getItem(0), recipe.getItem(1), recipe.getItem(2), recipe.getItem(3), recipe.getItem(4), recipe.getItem(5), recipe.getItem(6))) {
            entity.summonItem(new ItemStack((ItemLike)recipe.getItem(7)));
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)SummoningTableBlock.SUMMON, (Comparable)Boolean.valueOf(true))).setValue((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void summonItem(ItemStack orb) {
        ((ItemStack)this.inventory.get(0)).shrink(1);
        ((ItemStack)this.inventory.get(1)).shrink(1);
        ((ItemStack)this.inventory.get(2)).shrink(1);
        ((ItemStack)this.inventory.get(3)).shrink(1);
        ((ItemStack)this.inventory.get(4)).shrink(1);
        ((ItemStack)this.inventory.get(5)).shrink(1);
        ((ItemStack)this.inventory.get(6)).shrink(1);
        this.inventory.set(3, (Object)orb);
        assert (this.level != null);
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)JSounds.EUCA_DISC_1.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public ItemStack getItemInSlot(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public boolean areItemsInSlots(Item s, Item s1, Item s2, Item s3, Item s4, Item s5, Item s6) {
        return this.getItemInSlot(0).getItem() == s && this.getItemInSlot(1).getItem() == s1 && this.getItemInSlot(2).getItem() == s2 && this.getItemInSlot(3).getItem() == s3 && this.getItemInSlot(4).getItem() == s4 && this.getItemInSlot(5).getItem() == s5 && this.getItemInSlot(6).getItem() == s6;
    }

    public boolean startedSummon() {
        return this.getItemInSlot(0) != ItemStack.EMPTY || this.getItemInSlot(1) != ItemStack.EMPTY || this.getItemInSlot(2) != ItemStack.EMPTY || this.getItemInSlot(3) != ItemStack.EMPTY || this.getItemInSlot(4) != ItemStack.EMPTY || this.getItemInSlot(5) != ItemStack.EMPTY || this.getItemInSlot(6) != ItemStack.EMPTY;
    }

    protected void loadAdditional(ValueInput nbt) {
        super.loadAdditional(nbt);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)nbt, this.inventory);
    }

    protected void saveAdditional(ValueOutput pTag) {
        super.saveAdditional(pTag);
        ContainerHelper.saveAllItems((ValueOutput)pTag, this.inventory);
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> item) {
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"jitl.tile.summon_table");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerID, @NotNull Inventory inventory) {
        return new SummoningTableContainer(containerID, inventory, (Container)this);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerID, Inventory inventory, Player player) {
        return new SummoningTableContainer(containerID, inventory, (Container)this);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    @NotNull
    public ItemStack removeItem(int pIndex, int pCount) {
        return ContainerHelper.removeItem(this.inventory, (int)pIndex, (int)pCount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pIndex) {
        return ContainerHelper.takeItem(this.inventory, (int)pIndex);
    }

    public void setItem(int pIndex, ItemStack pStack) {
        this.inventory.set(pIndex, (Object)pStack);
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
    }
}

