/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity.logic;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class DarkNotNeededSpawner
extends BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int spawnDelay = 20;
    private WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> pType, @Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        this.getOrCreateNextSpawnData(pLevel, pRandom, pPos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(pType).toString());
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.hasNearbyAlivePlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(@NotNull Level pLevel, @NotNull BlockPos pPos) {
        if (!this.isNearPlayer(pLevel, pPos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = pLevel.getRandom();
            double d0 = (double)pPos.getX() + randomsource.nextDouble();
            double d1 = (double)pPos.getY() + randomsource.nextDouble();
            double d2 = (double)pPos.getZ() + randomsource.nextDouble();
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos pos) {
        if (this.isNearPlayer((Level)serverLevel, pos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)serverLevel, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = serverLevel.getRandom();
                SpawnData spawndata = this.getOrCreateNextSpawnData((Level)serverLevel, randomsource, pos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(() -> this.toString(), LOGGER);){
                        ValueInput compoundtag = TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)serverLevel.registryAccess(), (CompoundTag)spawndata.getEntityToSpawn());
                        Optional optional = EntityType.by((ValueInput)compoundtag);
                        if (optional.isEmpty()) {
                            this.delay((Level)serverLevel, pos);
                            return;
                        }
                        Vec3 vec3 = compoundtag.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)pos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5, (double)(pos.getY() + randomsource.nextInt(3) - 1), (double)pos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5));
                        if (!serverLevel.noCollision(((EntityType)optional.get()).getSpawnAABB(vec3.x, vec3.y, vec3.z))) continue;
                        BlockPos blockpos = BlockPos.containing((Position)vec3);
                        if (spawndata.getCustomSpawnRules().isPresent()) {
                            SpawnData.CustomSpawnRules spawndata$customspawnrules;
                            if (!((EntityType)optional.get()).getCategory().isFriendly() && serverLevel.getDifficulty() == Difficulty.PEACEFUL || !(spawndata$customspawnrules = (SpawnData.CustomSpawnRules)spawndata.getCustomSpawnRules().get()).isValidPosition(blockpos, serverLevel)) continue;
                        } else if (!SpawnPlacements.checkSpawnRules((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)serverLevel, (EntitySpawnReason)EntitySpawnReason.SPAWNER, (BlockPos)blockpos, (RandomSource)serverLevel.getRandom())) continue;
                        Entity entity = EntityType.loadEntityRecursive((ValueInput)compoundtag, (Level)serverLevel, (EntitySpawnReason)EntitySpawnReason.SPAWNER, p_404552_ -> {
                            p_404552_.snapTo(vec3.x, vec3.y, vec3.z, p_404552_.getYRot(), p_404552_.getXRot());
                            return p_404552_;
                        });
                        if (entity == null) {
                            this.delay((Level)serverLevel, pos);
                            return;
                        }
                        int j = serverLevel.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                        if (j >= this.maxNearbyEntities) {
                            this.delay((Level)serverLevel, pos);
                            return;
                        }
                        entity.snapTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            if (!EventHooks.checkSpawnPositionSpawner((Mob)mob, (ServerLevelAccessor)serverLevel, (EntitySpawnReason)EntitySpawnReason.SPAWNER, (SpawnData)spawndata, (BaseSpawner)this)) continue;
                            boolean flag1 = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().getString("id").isPresent();
                            EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(entity.blockPosition()), (EntitySpawnReason)EntitySpawnReason.SPAWNER, (SpawnGroupData)null, (IOwnedSpawner)this, (boolean)flag1);
                        }
                        if (!serverLevel.tryAddFreshEntityWithPassengers(entity)) {
                            this.delay((Level)serverLevel, pos);
                            return;
                        }
                        serverLevel.levelEvent(2004, pos, 0);
                        serverLevel.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                        if (entity instanceof Mob) {
                            ((Mob)entity).spawnAnim();
                        }
                        flag = true;
                        continue;
                    }
                }
                if (flag) {
                    this.delay((Level)serverLevel, pos);
                }
            }
        }
    }

    private void delay(Level level, BlockPos pos) {
        RandomSource randomsource = level.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(p_393311_ -> this.setNextSpawnData(level, pos, (SpawnData)p_393311_));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable Level level, BlockPos pos, ValueInput tag) {
        this.spawnDelay = tag.getShortOr("Delay", (short)20);
        tag.read("SpawnData", SpawnData.CODEC).ifPresent(p_400944_ -> this.setNextSpawnData(level, pos, (SpawnData)p_400944_));
        this.spawnPotentials = tag.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData())));
        this.minSpawnDelay = tag.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = tag.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = tag.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = tag.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = tag.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = tag.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public void save(ValueOutput tag) {
        tag.putShort("Delay", (short)this.spawnDelay);
        tag.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        tag.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tag.putShort("SpawnCount", (short)this.spawnCount);
        tag.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.putShort("SpawnRange", (short)this.spawnRange);
        tag.storeNullable("SpawnData", SpawnData.CODEC, (Object)this.nextSpawnData);
        tag.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level, BlockPos pos) {
        if (this.displayEntity == null) {
            CompoundTag compoundtag = this.getOrCreateNextSpawnData(level, level.getRandom(), pos).getEntityToSpawn();
            if (compoundtag.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)level, (EntitySpawnReason)EntitySpawnReason.SPAWNER, Function.identity());
            if (compoundtag.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(@NotNull Level pLevel, int pId) {
        if (pId == 1) {
            if (pLevel.isClientSide()) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level pLevel, @NotNull BlockPos pPos, @NotNull SpawnData pNextSpawnData) {
        this.nextSpawnData = pNextSpawnData;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(pLevel, pPos, this.spawnPotentials.getRandom(pRandom).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(@NotNull Level var1, @NotNull BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        return null;
    }
}

