/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.Objects;
import java.util.UUID;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JTamableEntity
extends TamableAnimal
implements NeutralMob,
GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(JTamableEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    protected EnumKnowledge knowledge;
    protected float knowledgeAmount = 0.0f;
    protected boolean addKnowledgeWhenTame = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected JTamableEntity(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setTame(false, false);
    }

    protected boolean shouldDespawnInPeaceful() {
        return !this.isTame();
    }

    public boolean checkSpawnRules(LevelAccessor level, EntitySpawnReason type) {
        return !level.getBiome(this.blockPosition()).is(Tags.Biomes.IS_MUSHROOM) && !level.getBiome(this.blockPosition()).is(Biomes.DEEP_DARK);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount, boolean addKnowledgeWhenTame) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
        this.addKnowledgeWhenTame = addKnowledgeWhenTame;
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
        this.addKnowledgeWhenTame = false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((JTamableEntity)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void readAdditionalSaveData(ValueInput compound) {
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    protected void actuallyHurt(@NotNull ServerLevel level, @NotNull DamageSource damageSource, float damageAmount) {
        if (!this.isInvulnerableTo(level, damageSource)) {
            if (!this.level().isClientSide()) {
                this.setOrderedToSit(false);
            }
            super.actuallyHurt(level, damageSource, damageAmount);
        }
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addXP(this.knowledge, this.knowledgeAmount, player);
            }
        }
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue((double)this.setTameHealth());
            this.setHealth(this.setTameHealth());
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue((double)this.setBaseHealth());
        }
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public abstract int setBaseHealth();

    public abstract int setTameHealth();

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.level().isClientSide() || this.isBaby() && this.isFood(itemstack)) {
            if (this.isTame()) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(2.0f * f);
                    itemstack.consume(1, (LivingEntity)pPlayer);
                    this.gameEvent((Holder)GameEvent.EAT);
                    return InteractionResult.SUCCESS;
                }
                InteractionResult interactionresult = super.mobInteract(pPlayer, pHand);
                if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)pPlayer)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            if (itemstack.is(this.getTameItem()) && !this.isAngry()) {
                itemstack.consume(1, (LivingEntity)pPlayer);
                this.tryToTame(pPlayer);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(pPlayer, pHand);
        }
        boolean flag = this.isOwnedBy((LivingEntity)pPlayer) || this.isTame() || itemstack.is(Items.BONE) && !this.isTame() && !this.isAngry();
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public abstract Item getTameItem();

    protected void tryToTame(Player pPlayer) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)pPlayer)) {
            this.tame(pPlayer);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            if (this.knowledge != null) {
                ((PlayerStats)pPlayer.getData(JDataAttachments.PLAYER_STATS)).addXP(this.knowledge, this.knowledgeAmount * 2.0f, pPlayer);
            }
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public boolean isFood(ItemStack s) {
        return s.is(this.getTameItem()) || s.is(JItems.PET_FOOD);
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int pTime) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean wantsToAttack(@NotNull LivingEntity pTarget, @NotNull LivingEntity pOwner) {
        TamableAnimal tamableanimal;
        if (pTarget instanceof Creeper || pTarget instanceof Ghast || pTarget instanceof ArmorStand) {
            return false;
        }
        if (pTarget instanceof JTamableEntity) {
            JTamableEntity e = (JTamableEntity)pTarget;
            return !e.isTame() || e.getOwner() != pOwner;
        }
        if (pTarget instanceof Player) {
            Player player1;
            Player player = (Player)pTarget;
            if (pOwner instanceof Player && !(player1 = (Player)pOwner).canHarmPlayer(player)) {
                return false;
            }
        }
        return !(pTarget instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)pTarget).isTame();
    }

    public boolean canBeLeashed() {
        return !this.isAngry() && super.canBeLeashed();
    }

    @NotNull
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }
}

